/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.utils;

import com.dexcoder.commons.exceptions.CommonsAssistantException;
import com.dexcoder.commons.utils.StrUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class PropertyUtils {
    private static final String PRO_SUFFIX = ".properties";
    private static Map<String, String> propMap = new HashMap<String, String>();

    public static InputStream loadResource(String resourceName) {
        try {
            File configFile = PropertyUtils.getConfigFile(resourceName);
            if (configFile == null) {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
                return is;
            }
            return new FileInputStream(configFile);
        }
        catch (FileNotFoundException e) {
            throw new CommonsAssistantException("\u52a0\u8f7dxml\u6587\u4ef6\u5931\u8d25:" + resourceName, (Throwable)e);
        }
    }

    public static void loadProperties(String resourceName) {
        try {
            if (!StrUtils.endsWith(resourceName, PRO_SUFFIX)) {
                resourceName = resourceName + PRO_SUFFIX;
            }
            Properties prop = new Properties();
            prop.load(PropertyUtils.loadResource(resourceName));
            for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                propMap.put(resourceName + String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
            propMap.put(resourceName, "true");
        }
        catch (IOException e) {
            throw new CommonsAssistantException("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25:" + resourceName, (Throwable)e);
        }
    }

    public static String getProperty(String resourceName, String key) {
        return PropertyUtils.getProperty(resourceName, key, null);
    }

    public static String getProperty(String resourceName, String key, String defaultValue) {
        String value;
        if (!StrUtils.endsWith(resourceName, PRO_SUFFIX)) {
            resourceName = resourceName + PRO_SUFFIX;
        }
        String finalKey = resourceName + key;
        if (propMap.get(resourceName) == null) {
            PropertyUtils.loadProperties(resourceName);
        }
        return StrUtils.isBlank(value = propMap.get(finalKey)) ? defaultValue : value;
    }

    private static File getConfigFile(String resourceName) {
        String resourcePath = System.getProperty("catalina.home") + "/conf";
        File file = new File(resourcePath, resourceName);
        if (file.exists()) {
            return file;
        }
        resourcePath = System.getProperty("user.dir");
        file = new File(resourcePath, resourceName);
        if (file.exists()) {
            return file;
        }
        return null;
    }
}

