/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.utils;

import com.dexcoder.commons.exceptions.CommonsAssistantException;
import com.dexcoder.commons.utils.ArrUtils;
import com.dexcoder.commons.utils.StrUtils;
import java.io.UnsupportedEncodingException;

public class TextUtils {
    public static String convertHtmlSpecialChars(String str) {
        if (StrUtils.isBlank(str)) {
            return null;
        }
        String[][] chars = new String[][]{{"&", "&amp;"}, {"<", "&lt;"}, {">", "&gt;"}, {"\"", "&quot;"}, {"\u3000", " "}};
        return TextUtils.replaceChars(str, chars);
    }

    public static String reverseHtmlSpecialChars(String str) {
        if (StrUtils.isBlank(str)) {
            return null;
        }
        String[][] chars = new String[][]{{"&amp;", "&"}, {"&lt;", "<"}, {"&gt;", ">"}, {"&quot;", "\""}, {"\u3000", " "}};
        return TextUtils.replaceChars(str, chars);
    }

    public static String replaceChars(String str, String[][] chars) {
        for (String[] cs : chars) {
            str = str.replace(cs[0], cs[1]);
        }
        return str;
    }

    public static String substringForByte(String text, int length) {
        return TextUtils.substringForByte(text, length, true);
    }

    public static String substringForByte(String text, int length, boolean isConvertSpecialChars) {
        if (StrUtils.isBlank(text) || length < 1) {
            return text;
        }
        try {
            byte[] bytes = text.getBytes("GBK");
            byte[] contentNameBytes = ArrUtils.subarray(bytes, 0, length);
            int count = 0;
            for (byte b : contentNameBytes) {
                if (b >= 0) continue;
                ++count;
            }
            if (count % 2 != 0) {
                contentNameBytes = ArrUtils.subarray(contentNameBytes, 0, contentNameBytes.length - 1);
            }
            String contentName = new String(contentNameBytes, "GBK");
            if (isConvertSpecialChars) {
                contentName = TextUtils.convertHtmlSpecialChars(contentName);
            }
            return contentName;
        }
        catch (UnsupportedEncodingException e) {
            throw new CommonsAssistantException("\u6839\u636ebyte\u622a\u53d6\u5b57\u7b26\u4e32\u5931\u8d25", (Throwable)e);
        }
    }
}

