/*
 * Decompiled with CFR 0.152.
 */
package com.dinuscxj.progressbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.dinuscxj.progressbar.R;
import com.dinuscxj.progressbar.UnitUtils;

public class CircleProgressBar
extends View {
    private static final int DEFAULT_MAX = 100;
    private static final float MAX_DEGREE = 360.0f;
    private static final float LINEAR_START_DEGREE = 90.0f;
    private static final int LINE = 0;
    private static final int SOLID = 1;
    private static final int SOLID_LINE = 2;
    private static final int LINEAR = 0;
    private static final int RADIAL = 1;
    private static final int SWEEP = 2;
    private static final int DEFAULT_START_DEGREE = -90;
    private static final int DEFAULT_LINE_COUNT = 45;
    private static final float DEFAULT_LINE_WIDTH = 4.0f;
    private static final float DEFAULT_PROGRESS_TEXT_SIZE = 11.0f;
    private static final float DEFAULT_PROGRESS_STROKE_WIDTH = 1.0f;
    private static final String COLOR_FFF2A670 = "#fff2a670";
    private static final String COLOR_FFD3D3D5 = "#ffe3e3e5";
    private final RectF mProgressRectF = new RectF();
    private final Rect mProgressTextRect = new Rect();
    private final Paint mProgressPaint = new Paint(1);
    private final Paint mProgressBackgroundPaint = new Paint(1);
    private final Paint mProgressTextPaint = new TextPaint(1);
    private float mRadius;
    private float mCenterX;
    private float mCenterY;
    private int mProgress;
    private int mMax = 100;
    private int mLineCount;
    private float mLineWidth;
    private float mProgressStrokeWidth;
    private float mProgressTextSize;
    private int mProgressStartColor;
    private int mProgressEndColor;
    private int mProgressTextColor;
    private int mProgressBackgroundColor;
    private int mStartDegree;
    private boolean mDrawBackgroundOutsideProgress;
    private ProgressFormatter mProgressFormatter = new DefaultProgressFormatter();
    private int mStyle;
    private int mShader;
    private Paint.Cap mCap;

    public CircleProgressBar(Context context) {
        this(context, null);
    }

    public CircleProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initFromAttributes(context, attrs);
        this.initPaint();
    }

    private void initFromAttributes(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircleProgressBar);
        this.mLineCount = a.getInt(R.styleable.CircleProgressBar_line_count, 45);
        this.mStyle = a.getInt(R.styleable.CircleProgressBar_style, 0);
        this.mShader = a.getInt(R.styleable.CircleProgressBar_progress_shader, 0);
        this.mCap = a.hasValue(R.styleable.CircleProgressBar_progress_stroke_cap) ? Paint.Cap.values()[a.getInt(R.styleable.CircleProgressBar_progress_stroke_cap, 0)] : Paint.Cap.BUTT;
        this.mLineWidth = a.getDimensionPixelSize(R.styleable.CircleProgressBar_line_width, UnitUtils.dip2px(this.getContext(), 4.0f));
        this.mProgressTextSize = a.getDimensionPixelSize(R.styleable.CircleProgressBar_progress_text_size, UnitUtils.dip2px(this.getContext(), 11.0f));
        this.mProgressStrokeWidth = a.getDimensionPixelSize(R.styleable.CircleProgressBar_progress_stroke_width, UnitUtils.dip2px(this.getContext(), 1.0f));
        this.mProgressStartColor = a.getColor(R.styleable.CircleProgressBar_progress_start_color, Color.parseColor((String)COLOR_FFF2A670));
        this.mProgressEndColor = a.getColor(R.styleable.CircleProgressBar_progress_end_color, Color.parseColor((String)COLOR_FFF2A670));
        this.mProgressTextColor = a.getColor(R.styleable.CircleProgressBar_progress_text_color, Color.parseColor((String)COLOR_FFF2A670));
        this.mProgressBackgroundColor = a.getColor(R.styleable.CircleProgressBar_progress_background_color, Color.parseColor((String)COLOR_FFD3D3D5));
        this.mStartDegree = a.getInt(R.styleable.CircleProgressBar_progress_start_degree, -90);
        this.mDrawBackgroundOutsideProgress = a.getBoolean(R.styleable.CircleProgressBar_drawBackgroundOutsideProgress, false);
        a.recycle();
    }

    private void initPaint() {
        this.mProgressTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mProgressTextPaint.setTextSize(this.mProgressTextSize);
        this.mProgressPaint.setStyle(this.mStyle == 1 ? Paint.Style.FILL : Paint.Style.STROKE);
        this.mProgressPaint.setStrokeWidth(this.mProgressStrokeWidth);
        this.mProgressPaint.setColor(this.mProgressStartColor);
        this.mProgressPaint.setStrokeCap(this.mCap);
        this.mProgressBackgroundPaint.setStyle(this.mStyle == 1 ? Paint.Style.FILL : Paint.Style.STROKE);
        this.mProgressBackgroundPaint.setStrokeWidth(this.mProgressStrokeWidth);
        this.mProgressBackgroundPaint.setColor(this.mProgressBackgroundColor);
        this.mProgressBackgroundPaint.setStrokeCap(this.mCap);
    }

    private void updateProgressShader() {
        if (this.mProgressStartColor != this.mProgressEndColor) {
            RadialGradient shader = null;
            switch (this.mShader) {
                case 0: {
                    shader = new LinearGradient(this.mProgressRectF.left, this.mProgressRectF.top, this.mProgressRectF.left, this.mProgressRectF.bottom, this.mProgressStartColor, this.mProgressEndColor, Shader.TileMode.CLAMP);
                    Matrix matrix = new Matrix();
                    matrix.setRotate(90.0f, this.mCenterX, this.mCenterY);
                    shader.setLocalMatrix(matrix);
                    break;
                }
                case 1: {
                    shader = new RadialGradient(this.mCenterX, this.mCenterY, this.mRadius, this.mProgressStartColor, this.mProgressEndColor, Shader.TileMode.CLAMP);
                    break;
                }
                case 2: {
                    float radian = (float)((double)this.mProgressStrokeWidth / Math.PI * 2.0 / (double)this.mRadius);
                    float rotateDegrees = (float)(-(this.mCap == Paint.Cap.BUTT && this.mStyle == 2 ? 0.0 : Math.toDegrees(radian)));
                    shader = new SweepGradient(this.mCenterX, this.mCenterY, new int[]{this.mProgressStartColor, this.mProgressEndColor}, new float[]{0.0f, 1.0f});
                    Matrix matrix = new Matrix();
                    matrix.setRotate(rotateDegrees, this.mCenterX, this.mCenterY);
                    shader.setLocalMatrix(matrix);
                    break;
                }
            }
            this.mProgressPaint.setShader(shader);
        } else {
            this.mProgressPaint.setShader(null);
            this.mProgressPaint.setColor(this.mProgressStartColor);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        canvas.rotate((float)this.mStartDegree, this.mCenterX, this.mCenterY);
        this.drawProgress(canvas);
        canvas.restore();
        this.drawProgressText(canvas);
    }

    private void drawProgressText(Canvas canvas) {
        if (this.mProgressFormatter == null) {
            return;
        }
        CharSequence progressText = this.mProgressFormatter.format(this.mProgress, this.mMax);
        if (TextUtils.isEmpty((CharSequence)progressText)) {
            return;
        }
        this.mProgressTextPaint.setTextSize(this.mProgressTextSize);
        this.mProgressTextPaint.setColor(this.mProgressTextColor);
        this.mProgressTextPaint.getTextBounds(String.valueOf(progressText), 0, progressText.length(), this.mProgressTextRect);
        canvas.drawText(progressText, 0, progressText.length(), this.mCenterX, this.mCenterY + (float)(this.mProgressTextRect.height() / 2), this.mProgressTextPaint);
    }

    private void drawProgress(Canvas canvas) {
        switch (this.mStyle) {
            case 1: {
                this.drawSolidProgress(canvas);
                break;
            }
            case 2: {
                this.drawSolidLineProgress(canvas);
                break;
            }
            default: {
                this.drawLineProgress(canvas);
            }
        }
    }

    private void drawLineProgress(Canvas canvas) {
        float unitDegrees = (float)(Math.PI * 2 / (double)this.mLineCount);
        float outerCircleRadius = this.mRadius;
        float interCircleRadius = this.mRadius - this.mLineWidth;
        int progressLineCount = (int)((float)this.mProgress / (float)this.mMax * (float)this.mLineCount);
        for (int i = 0; i < this.mLineCount; ++i) {
            float rotateDegrees = (float)i * -unitDegrees;
            float startX = this.mCenterX + (float)Math.cos(rotateDegrees) * interCircleRadius;
            float startY = this.mCenterY - (float)Math.sin(rotateDegrees) * interCircleRadius;
            float stopX = this.mCenterX + (float)Math.cos(rotateDegrees) * outerCircleRadius;
            float stopY = this.mCenterY - (float)Math.sin(rotateDegrees) * outerCircleRadius;
            if (this.mDrawBackgroundOutsideProgress) {
                if (i >= progressLineCount) {
                    canvas.drawLine(startX, startY, stopX, stopY, this.mProgressBackgroundPaint);
                }
            } else {
                canvas.drawLine(startX, startY, stopX, stopY, this.mProgressBackgroundPaint);
            }
            if (i >= progressLineCount) continue;
            canvas.drawLine(startX, startY, stopX, stopY, this.mProgressPaint);
        }
    }

    private void drawSolidProgress(Canvas canvas) {
        if (this.mDrawBackgroundOutsideProgress) {
            float startAngle = 360.0f * (float)this.mProgress / (float)this.mMax;
            float sweepAngle = 360.0f - startAngle;
            canvas.drawArc(this.mProgressRectF, startAngle, sweepAngle, true, this.mProgressBackgroundPaint);
        } else {
            canvas.drawArc(this.mProgressRectF, 0.0f, 360.0f, true, this.mProgressBackgroundPaint);
        }
        canvas.drawArc(this.mProgressRectF, 0.0f, 360.0f * (float)this.mProgress / (float)this.mMax, true, this.mProgressPaint);
    }

    private void drawSolidLineProgress(Canvas canvas) {
        if (this.mDrawBackgroundOutsideProgress) {
            float startAngle = 360.0f * (float)this.mProgress / (float)this.mMax;
            float sweepAngle = 360.0f - startAngle;
            canvas.drawArc(this.mProgressRectF, startAngle, sweepAngle, false, this.mProgressBackgroundPaint);
        } else {
            canvas.drawArc(this.mProgressRectF, 0.0f, 360.0f, false, this.mProgressBackgroundPaint);
        }
        canvas.drawArc(this.mProgressRectF, 0.0f, 360.0f * (float)this.mProgress / (float)this.mMax, false, this.mProgressPaint);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mCenterX = w / 2;
        this.mCenterY = h / 2;
        this.mRadius = Math.min(this.mCenterX, this.mCenterY);
        this.mProgressRectF.top = this.mCenterY - this.mRadius;
        this.mProgressRectF.bottom = this.mCenterY + this.mRadius;
        this.mProgressRectF.left = this.mCenterX - this.mRadius;
        this.mProgressRectF.right = this.mCenterX + this.mRadius;
        this.updateProgressShader();
        this.mProgressRectF.inset(this.mProgressStrokeWidth / 2.0f, this.mProgressStrokeWidth / 2.0f);
    }

    public void setProgressFormatter(ProgressFormatter progressFormatter) {
        this.mProgressFormatter = progressFormatter;
        this.invalidate();
    }

    public void setProgressStrokeWidth(float progressStrokeWidth) {
        this.mProgressStrokeWidth = progressStrokeWidth;
        this.mProgressRectF.inset(this.mProgressStrokeWidth / 2.0f, this.mProgressStrokeWidth / 2.0f);
        this.invalidate();
    }

    public void setProgressTextSize(float progressTextSize) {
        this.mProgressTextSize = progressTextSize;
        this.invalidate();
    }

    public void setProgressStartColor(int progressStartColor) {
        this.mProgressStartColor = progressStartColor;
        this.updateProgressShader();
        this.invalidate();
    }

    public void setProgressEndColor(int progressEndColor) {
        this.mProgressEndColor = progressEndColor;
        this.updateProgressShader();
        this.invalidate();
    }

    public void setProgressTextColor(int progressTextColor) {
        this.mProgressTextColor = progressTextColor;
        this.invalidate();
    }

    public void setProgressBackgroundColor(int progressBackgroundColor) {
        this.mProgressBackgroundColor = progressBackgroundColor;
        this.mProgressBackgroundPaint.setColor(this.mProgressBackgroundColor);
        this.invalidate();
    }

    public void setLineCount(int lineCount) {
        this.mLineCount = lineCount;
        this.invalidate();
    }

    public void setLineWidth(float lineWidth) {
        this.mLineWidth = lineWidth;
        this.invalidate();
    }

    public void setStyle(int style) {
        this.mStyle = style;
        this.mProgressPaint.setStyle(this.mStyle == 1 ? Paint.Style.FILL : Paint.Style.STROKE);
        this.mProgressBackgroundPaint.setStyle(this.mStyle == 1 ? Paint.Style.FILL : Paint.Style.STROKE);
        this.invalidate();
    }

    public void setShader(int shader) {
        this.mShader = shader;
        this.updateProgressShader();
        this.invalidate();
    }

    public void setCap(Paint.Cap cap) {
        this.mCap = cap;
        this.mProgressPaint.setStrokeCap(cap);
        this.mProgressBackgroundPaint.setStrokeCap(cap);
        this.invalidate();
    }

    public void setProgress(int progress) {
        this.mProgress = progress;
        this.invalidate();
    }

    public void setMax(int max) {
        this.mMax = max;
        this.invalidate();
    }

    public int getProgress() {
        return this.mProgress;
    }

    public int getMax() {
        return this.mMax;
    }

    public int getStartDegree() {
        return this.mStartDegree;
    }

    public void setStartDegree(int startDegree) {
        this.mStartDegree = startDegree;
        this.invalidate();
    }

    public boolean isDrawBackgroundOutsideProgress() {
        return this.mDrawBackgroundOutsideProgress;
    }

    public void setDrawBackgroundOutsideProgress(boolean drawBackgroundOutsideProgress) {
        this.mDrawBackgroundOutsideProgress = drawBackgroundOutsideProgress;
        this.invalidate();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.progress = this.mProgress;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setProgress(ss.progress);
    }

    private static final class SavedState
    extends View.BaseSavedState {
        int progress;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.progress = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.progress);
        }
    }

    private static final class DefaultProgressFormatter
    implements ProgressFormatter {
        private static final String DEFAULT_PATTERN = "%d%%";

        private DefaultProgressFormatter() {
        }

        @Override
        public CharSequence format(int progress, int max) {
            return String.format(DEFAULT_PATTERN, (int)((float)progress / (float)max * 100.0f));
        }
    }

    public static interface ProgressFormatter {
        public CharSequence format(int var1, int var2);
    }
}

