/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.adobe;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.adobe.AdobeJpegDirectory;
import java.io.IOException;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdobeJpegReader
implements JpegSegmentMetadataReader {
    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Arrays.asList(JpegSegmentType.APPE);
    }

    @Override
    public boolean canProcess(@NotNull byte[] segmentBytes, @NotNull JpegSegmentType segmentType) {
        return segmentBytes.length == 12 && "Adobe".equalsIgnoreCase(new String(segmentBytes, 0, 5));
    }

    @Override
    public void extract(@NotNull byte[] segmentBytes, @NotNull Metadata metadata, @NotNull JpegSegmentType segmentType) {
        this.extract(new SequentialByteArrayReader(segmentBytes), metadata);
    }

    public void extract(@NotNull SequentialReader reader, @NotNull Metadata metadata) {
        AdobeJpegDirectory directory = metadata.getOrCreateDirectory(AdobeJpegDirectory.class);
        try {
            reader.setMotorolaByteOrder(false);
            if (!reader.getString(5).equals("Adobe")) {
                directory.addError("Invalid Adobe JPEG data header.");
                return;
            }
            directory.setInt(0, reader.getUInt16());
            directory.setInt(1, reader.getUInt16());
            directory.setInt(2, reader.getUInt16());
            directory.setInt(3, reader.getInt8());
        }
        catch (IOException ex) {
            directory.addError("IO exception processing data: " + ex.getMessage());
        }
    }
}

