/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.AgentUtil;
import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.DTXActionImpl;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.WebReqTag;
import com.dynatrace.android.agent.util.Utility;
import org.apache.http.Header;
import org.apache.http.HttpRequest;

public class ApacheUtil {
    private static final String LOGTAG = Global.LOG_PREFIX + "ApacheUtil";

    public static String fetchWebReqTag(HttpRequest httpReq, String tagName) {
        if (httpReq == null) {
            return null;
        }
        try {
            Header header = httpReq.getLastHeader(tagName);
            if (header != null) {
                return header.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void removeHeaderFromRequest(HttpRequest httpReq, String headerTag) {
        if (httpReq != null) {
            try {
                httpReq.removeHeaders(headerTag);
            }
            catch (Exception e) {
                Utility.zlogE((String)LOGTAG, (String)"can't remove header", (Throwable)e);
            }
        }
    }

    public static WebReqTag tagRequest(HttpRequest request) {
        if (!Dynatrace.getCaptureStatus() || request == null) {
            return null;
        }
        WebReqTag wrTag = AgentUtil.getRequestTag();
        if (wrTag == null) {
            return null;
        }
        request.setHeader(Dynatrace.getRequestTagHeader(), wrTag.toString());
        return wrTag;
    }

    public static WebReqTag tagRequest(DTXActionImpl action, HttpRequest request) {
        if (!action.getPreconditions() || request == null || !action.session.getPrivacyRules().shouldCollectEvent(EventType.WEB_REQUEST)) {
            return null;
        }
        WebReqTag wrTag = action.getInternalRequestTag();
        if (wrTag == null) {
            return null;
        }
        request.setHeader(Dynatrace.getRequestTagHeader(), wrTag.toString());
        CustomSegment webReq = new CustomSegment(wrTag.toString(), 110, EventType.PLACEHOLDER, action.getTagId(), action.session, action.serverId, true);
        action.addChildEvent(webReq);
        return wrTag;
    }
}

