/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.internal.api.recyclerview.interceptor;

import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.dynatrace.android.sessionreplay.tracking.utils.InterceptionCache;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB'\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000bR&\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/dynatrace/android/internal/api/recyclerview/interceptor/RecyclerViewScrollInterceptor;", "", "trackingHandler", "Lkotlin/Function3;", "Landroid/view/View;", "", "", "<init>", "(Lkotlin/jvm/functions/Function3;)V", "intercepted", "Lcom/dynatrace/android/sessionreplay/tracking/utils/InterceptionCache;", "Landroidx/recyclerview/widget/RecyclerView;", "Landroidx/recyclerview/widget/RecyclerView$OnScrollListener;", "intercept", "recyclerView", "RecyclerViewScrollListener", "api.androidx_release"})
public final class RecyclerViewScrollInterceptor {
    @NotNull
    private final Function3<View, Integer, Integer, Unit> trackingHandler;
    @NotNull
    private final InterceptionCache<RecyclerView, RecyclerView.OnScrollListener> intercepted;

    public RecyclerViewScrollInterceptor(@NotNull Function3<? super View, ? super Integer, ? super Integer, Unit> trackingHandler) {
        Intrinsics.checkNotNullParameter(trackingHandler, (String)"trackingHandler");
        this.trackingHandler = trackingHandler;
        this.intercepted = new InterceptionCache();
    }

    public final void intercept(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        RecyclerView.OnScrollListener previous = (RecyclerView.OnScrollListener)this.intercepted.get((Object)recyclerView);
        if (previous != null) {
            recyclerView.removeOnScrollListener(previous);
        }
        RecyclerViewScrollListener listener = new RecyclerViewScrollListener();
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)listener);
        this.intercepted.set((Object)recyclerView, (Object)listener);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J \u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/dynatrace/android/internal/api/recyclerview/interceptor/RecyclerViewScrollInterceptor$RecyclerViewScrollListener;", "Landroidx/recyclerview/widget/RecyclerView$OnScrollListener;", "<init>", "(Lcom/dynatrace/android/internal/api/recyclerview/interceptor/RecyclerViewScrollInterceptor;)V", "currState", "", "dx", "dy", "onScrollStateChanged", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "newState", "onScrolled", "api.androidx_release"})
    private final class RecyclerViewScrollListener
    extends RecyclerView.OnScrollListener {
        private int currState;
        private int dx;
        private int dy;

        public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
            Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
            if (this.currState != newState && newState == 0) {
                RecyclerViewScrollInterceptor.this.trackingHandler.invoke((Object)recyclerView, (Object)this.dx, (Object)this.dy);
                this.dx = 0;
                this.dy = 0;
            }
            this.currState = newState;
        }

        public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
            Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
            this.dx += dx;
            this.dy += dy;
        }
    }
}

