/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.internal.api.compose17.handler;

import androidx.compose.ui.Modifier;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutInfo;
import androidx.compose.ui.layout.ModifierInfo;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.input.TextFieldValue;
import com.dynatrace.android.internal.api.compose.InstrumentorComposeApi;
import com.dynatrace.android.internal.api.compose.model.ViewHolder;
import com.dynatrace.android.internal.api.compose17.model.DTInputTextModifier;
import com.dynatrace.android.internal.api.compose17.model.DTLayoutInfoNode;
import com.dynatrace.android.sessionreplay.tracking.TrackingManager;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\"\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/dynatrace/android/internal/api/compose17/handler/InputTextHandler;", "", "<init>", "()V", "textInputValuesMap", "", "", "", "onAttach", "", "layoutInfo", "Landroidx/compose/ui/layout/LayoutInfo;", "onDetach", "onTextFieldValueChange", "input", "Landroidx/compose/ui/text/input/TextFieldValue;", "modifier", "Landroidx/compose/ui/Modifier;", "onTextFieldStateFocus", "coordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "annotatedString", "Landroidx/compose/ui/text/AnnotatedString;", "focused", "", "api.compose17_release"})
@SourceDebugExtension(value={"SMAP\nInputTextHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputTextHandler.kt\ncom/dynatrace/android/internal/api/compose17/handler/InputTextHandler\n+ 2 ComposeUtils.kt\ncom/dynatrace/android/internal/api/compose/util/ComposeUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n14#2,2:72\n16#2:75\n1#3:74\n1#3:76\n*S KotlinDebug\n*F\n+ 1 InputTextHandler.kt\ncom/dynatrace/android/internal/api/compose17/handler/InputTextHandler\n*L\n18#1:72,2\n18#1:75\n18#1:74\n*E\n"})
public final class InputTextHandler {
    @NotNull
    private Map<Integer, String> textInputValuesMap = new LinkedHashMap();

    public final void onAttach(@NotNull LayoutInfo layoutInfo) {
        block6: {
            DTInputTextModifier dTInputTextModifier;
            Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
            LayoutInfo $this$getModifierOrNull$iv = layoutInfo;
            boolean $i$f$getModifierOrNull = false;
            try {
                Object v0;
                block5: {
                    for (Object t : (Iterable)$this$getModifierOrNull$iv.getModifierInfo()) {
                        ModifierInfo it$iv = (ModifierInfo)t;
                        boolean bl = false;
                        if (!(it$iv.getModifier() instanceof DTInputTextModifier)) continue;
                        v0 = t;
                        break block5;
                    }
                    v0 = null;
                }
                ModifierInfo modifierInfo = v0;
                Object object = modifierInfo != null ? modifierInfo.getModifier() : null;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.dynatrace.android.internal.api.compose17.model.DTInputTextModifier");
                }
                dTInputTextModifier = (DTInputTextModifier)((Object)object);
            }
            catch (Exception e$iv) {
                dTInputTextModifier = null;
            }
            DTInputTextModifier dTInputTextModifier2 = dTInputTextModifier;
            if (dTInputTextModifier2 == null) break block6;
            DTInputTextModifier modifier = dTInputTextModifier2;
            boolean bl = false;
            DTLayoutInfoNode dTLayoutInfoNode = modifier.getCompoundNode();
            if (dTLayoutInfoNode != null) {
                dTLayoutInfoNode.setLayoutInfo(layoutInfo);
            }
        }
    }

    public final void onDetach(@NotNull LayoutInfo layoutInfo) {
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        if (this.textInputValuesMap.keySet().contains(layoutInfo.getSemanticsId())) {
            this.textInputValuesMap.remove(layoutInfo.getSemanticsId());
        }
    }

    public final void onTextFieldValueChange(@NotNull TextFieldValue input, @NotNull Modifier modifier) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        ViewHolder viewHolder = InstrumentorComposeApi.INSTANCE.getComposeViewHolder();
        if (viewHolder == null) {
            return;
        }
        ViewHolder viewHolder2 = viewHolder;
        String inputText = input.getText();
        modifier.foldIn((Object)Unit.INSTANCE, (arg_0, arg_1) -> InputTextHandler.onTextFieldValueChange$lambda$4(this, inputText, viewHolder2, arg_0, arg_1));
    }

    public final void onTextFieldStateFocus(@Nullable LayoutCoordinates coordinates, @Nullable AnnotatedString annotatedString, boolean focused) {
        Object object = annotatedString;
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        Object text = object;
        ViewHolder viewHolder = InstrumentorComposeApi.INSTANCE.getComposeViewHolder();
        if (viewHolder == null) {
            return;
        }
        ViewHolder viewHolder2 = viewHolder;
        TrackingManager.INSTANCE.getTrackingApi().trackInputFocus((String)text, coordinates, viewHolder2.getView(), viewHolder2.getWindow(), focused);
    }

    private static final Unit onTextFieldValueChange$lambda$4(InputTextHandler this$0, String $inputText, ViewHolder $viewHolder, Unit unit, Modifier.Element element) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)unit, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (!(element instanceof DTInputTextModifier)) break block3;
            DTLayoutInfoNode dTLayoutInfoNode = ((DTInputTextModifier)element).getCompoundNode();
            if (dTLayoutInfoNode != null && (dTLayoutInfoNode = dTLayoutInfoNode.getLayoutInfo()) != null) {
                LayoutCoordinates layoutCoordinates;
                DTLayoutInfoNode layoutInfo = dTLayoutInfoNode;
                boolean bl = false;
                String storedValue = this$0.textInputValuesMap.get(layoutInfo.getSemanticsId());
                this$0.textInputValuesMap.put(layoutInfo.getSemanticsId(), $inputText);
                if (storedValue == null || Intrinsics.areEqual((Object)storedValue, (Object)$inputText)) {
                    return Unit.INSTANCE;
                }
                LayoutCoordinates it = layoutCoordinates = layoutInfo.getCoordinates();
                boolean bl2 = false;
                Object object = it.isAttached() ? layoutCoordinates : null;
                if (object != null) {
                    LayoutCoordinates coordinates = object;
                    boolean bl3 = false;
                    TrackingManager.INSTANCE.getTrackingApi().trackInputKeystroke($inputText, coordinates, $viewHolder.getView(), $viewHolder.getWindow());
                }
            }
        }
        return Unit.INSTANCE;
    }
}

