/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking;

import android.app.Application;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.ConfigurationApi;
import com.dynatrace.android.sessionreplay.tracking.InterceptionApi;
import com.dynatrace.android.sessionreplay.tracking.TrackingApi;
import com.dynatrace.android.sessionreplay.tracking.TrackingInjection;
import com.dynatrace.android.sessionreplay.tracking.UninitializedInterceptionApiImpl;
import com.dynatrace.android.sessionreplay.tracking.UninitializedTrackingApiImpl;
import com.dynatrace.android.sessionreplay.tracking.listeners.ApplicationWatchers;
import com.dynatrace.android.sessionreplay.tracking.observer.TrackingObserver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/TrackingManager;", "", "<init>", "()V", "initialized", "", "value", "Lcom/dynatrace/android/sessionreplay/tracking/TrackingApi;", "trackingApi", "getTrackingApi", "()Lcom/dynatrace/android/sessionreplay/tracking/TrackingApi;", "Lcom/dynatrace/android/sessionreplay/tracking/InterceptionApi;", "interceptionApi", "getInterceptionApi", "()Lcom/dynatrace/android/sessionreplay/tracking/InterceptionApi;", "Lcom/dynatrace/android/sessionreplay/tracking/ConfigurationApi;", "configurationApi", "getConfigurationApi", "()Lcom/dynatrace/android/sessionreplay/tracking/ConfigurationApi;", "init", "", "application", "Landroid/app/Application;", "subscribe", "observer", "Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;", "unsubscribe", "trackinglayer_release"})
public final class TrackingManager {
    @NotNull
    public static final TrackingManager INSTANCE = new TrackingManager();
    private static boolean initialized;
    @NotNull
    private static TrackingApi trackingApi;
    @NotNull
    private static InterceptionApi interceptionApi;
    @NotNull
    private static ConfigurationApi configurationApi;

    private TrackingManager() {
    }

    @NotNull
    public final TrackingApi getTrackingApi() {
        return trackingApi;
    }

    @NotNull
    public final InterceptionApi getInterceptionApi() {
        return interceptionApi;
    }

    @NotNull
    public final ConfigurationApi getConfigurationApi() {
        return configurationApi;
    }

    public final void init(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        if (initialized) {
            return;
        }
        TrackingInjection.Companion.init(configurationApi.getTrackingConfiguration());
        trackingApi = TrackingInjection.Companion.get().getTrackingApi();
        interceptionApi = TrackingInjection.Companion.get().getInterceptionApi();
        ApplicationWatchers applicationWatchers = TrackingInjection.Companion.get().getApplicationWatchers();
        applicationWatchers.startWatch(application);
        initialized = true;
    }

    public final void subscribe(@NotNull TrackingObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        if (!initialized) {
            DTLogger.INSTANCE.error("TrackingManager not initialized.");
            return;
        }
        TrackingInjection.Companion.setTrackingEnabled(observer);
        DTLogger.INSTANCE.info("Tracking layer connected");
    }

    public final void unsubscribe() {
        if (!initialized) {
            DTLogger.INSTANCE.error("TrackingManager not initialized.");
            return;
        }
        TrackingInjection.Companion.setTrackingDisabled();
        DTLogger.INSTANCE.info("Tracking layer disconnected");
    }

    static {
        trackingApi = new UninitializedTrackingApiImpl();
        interceptionApi = new UninitializedInterceptionApiImpl();
        configurationApi = new ConfigurationApi();
    }
}

