/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.helpers;

import android.graphics.Rect;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.extensions.RectExtensionsKt;
import com.dynatrace.android.sessionreplay.tracking.helpers.DividedRectangles;
import com.dynatrace.android.sessionreplay.tracking.utils.ViewExtensionKt;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\fH\u0002R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/helpers/OcclusionHandler;", "", "<init>", "()V", "rectMaps", "Ljava/util/LinkedHashMap;", "", "Lcom/dynatrace/android/sessionreplay/tracking/helpers/DividedRectangles;", "Lkotlin/collections/LinkedHashMap;", "updateViews", "", "view", "Landroid/view/View;", "getVisibleFrames", "getViewFrames", "Lkotlin/Pair;", "Landroid/graphics/Rect;", "cropRects", "viewOrParent", "viewRect", "getCroppedVisibleRect", "getDrawableRect", "getMappedParent", "needOcclusion", "", "trackinglayer_release"})
@SourceDebugExtension(value={"SMAP\nOcclusionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OcclusionHandler.kt\ncom/dynatrace/android/sessionreplay/tracking/helpers/OcclusionHandler\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n216#2,2:201\n2632#3,3:203\n*S KotlinDebug\n*F\n+ 1 OcclusionHandler.kt\ncom/dynatrace/android/sessionreplay/tracking/helpers/OcclusionHandler\n*L\n145#1:201,2\n194#1:203,3\n*E\n"})
public final class OcclusionHandler {
    @NotNull
    private LinkedHashMap<Integer, DividedRectangles> rectMaps = new LinkedHashMap();

    public final void updateViews(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (!this.needOcclusion(view)) {
            return;
        }
        this.rectMaps.clear();
        View contentView = view.findViewById(0x1020002);
        if (contentView == null || !(contentView instanceof ViewGroup) || ((ViewGroup)contentView).getChildCount() == 0) {
            return;
        }
        View topContent = ((ViewGroup)contentView).getChildAt(0);
        if (topContent instanceof ViewGroup) {
            for (int index = ((ViewGroup)topContent).getChildCount() - 1; -1 < index; --index) {
                View child = ((ViewGroup)topContent).getChildAt(index);
                Intrinsics.checkNotNull((Object)child);
                DividedRectangles dividedRectangles = this.getCroppedVisibleRect(child);
                ((Map)this.rectMaps).put(ViewExtensionKt.getIdentityHashCode(child), dividedRectangles);
            }
        }
        Log.d((String)"Occlusion", (String)"updateViews finished");
    }

    @NotNull
    public final DividedRectangles getVisibleFrames(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Rect viewRect = new Rect();
        boolean globallyVisible = view.getGlobalVisibleRect(viewRect);
        boolean isComposeView = ViewExtensionKt.isComposeView(view);
        if (!globallyVisible || isComposeView) {
            if (isComposeView) {
                DTLogger.INSTANCE.db("OcclusionHandler.getVisibleFrames: ComposeView detected area " + viewRect);
            }
        } else {
            View mappedParent = this.getMappedParent(view);
            return mappedParent != null ? this.cropRects(mappedParent, viewRect) : new DividedRectangles(viewRect);
        }
        Object[] objectArray = new Rect[]{viewRect};
        return new DividedRectangles(SetsKt.mutableSetOf((Object[])objectArray));
    }

    @NotNull
    public final Pair<DividedRectangles, Rect> getViewFrames(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Rect viewRect = new Rect();
        boolean globallyVisible = view.getGlobalVisibleRect(viewRect);
        if (globallyVisible && this.needOcclusion(view)) {
            Pair pair;
            View mappedParent = this.getMappedParent(view);
            if (mappedParent != null) {
                DividedRectangles dividedRectangles = this.rectMaps.get(ViewExtensionKt.getIdentityHashCode(mappedParent));
                if (dividedRectangles == null) {
                    dividedRectangles = new DividedRectangles(viewRect);
                }
                DividedRectangles dividedRectangles2 = dividedRectangles;
                pair = new Pair((Object)dividedRectangles2, (Object)viewRect);
            } else {
                pair = new Pair((Object)new DividedRectangles(viewRect), (Object)viewRect);
            }
            return pair;
        }
        Object[] objectArray = new Rect[]{viewRect};
        return new Pair((Object)new DividedRectangles(SetsKt.mutableSetOf((Object[])objectArray)), (Object)viewRect);
    }

    private final DividedRectangles cropRects(View viewOrParent, Rect viewRect) {
        DividedRectangles dividedRect;
        block0: {
            DividedRectangles rect;
            dividedRect = null;
            Object[] objectArray = new Rect[]{viewRect};
            dividedRect = new DividedRectangles(SetsKt.mutableSetOf((Object[])objectArray));
            DividedRectangles dividedRectangles = rect = viewOrParent != null ? this.rectMaps.get(ViewExtensionKt.getIdentityHashCode(viewOrParent)) : null;
            if (dividedRectangles == null) break block0;
            DividedRectangles it = dividedRectangles;
            boolean bl = false;
            dividedRect = it.intersection(viewRect);
        }
        return dividedRect;
    }

    private final DividedRectangles getCroppedVisibleRect(View view) {
        Rect visibleRect = this.getDrawableRect(view);
        DividedRectangles dividedRect = null;
        Object[] objectArray = new Rect[]{visibleRect};
        dividedRect = new DividedRectangles(SetsKt.mutableSetOf((Object[])objectArray));
        if (this.rectMaps.values().isEmpty()) {
            return dividedRect;
        }
        Map $this$forEach$iv = this.rectMaps;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            DividedRectangles rectangles = (DividedRectangles)entry.getValue();
            dividedRect = dividedRect.difference(rectangles);
        }
        return dividedRect;
    }

    private final Rect getDrawableRect(View view) {
        if (!ViewExtensionKt.isVisible(view)) {
            return new Rect();
        }
        Rect totalRect = new Rect();
        if (view.getBackground() == null && view instanceof ViewGroup) {
            for (int index = ((ViewGroup)view).getChildCount() - 1; -1 < index; --index) {
                View view2 = ((ViewGroup)view).getChildAt(index);
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getChildAt(...)");
                Rect rect = this.getDrawableRect(view2);
                totalRect.union(rect);
            }
        } else {
            boolean globalVisibility = view.getGlobalVisibleRect(totalRect);
            if (!globalVisibility) {
                RectExtensionsKt.clear(totalRect);
            }
        }
        return totalRect;
    }

    private final View getMappedParent(View view) {
        View view2;
        if (this.rectMaps.containsKey(ViewExtensionKt.getIdentityHashCode(view))) {
            view2 = view;
        } else if (!(view.getParent() instanceof View)) {
            view2 = null;
        } else {
            ViewParent viewParent = view.getParent();
            Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.View");
            view2 = this.getMappedParent((View)viewParent);
        }
        return view2;
    }

    private final boolean needOcclusion(View $this$needOcclusion) {
        return true;
    }
}

