/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.interceptors.impl;

import android.content.res.Resources;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.extensions.ViewExtensionsKt;
import com.dynatrace.android.sessionreplay.tracking.interceptors.ViewInterceptor;
import com.dynatrace.android.sessionreplay.tracking.listeners.TrackableTextWatcher;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.validator.Validation;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u00d7\u0002\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u008f\u0001\u0010\u0007\u001a\u008a\u0001\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\bj\u0002`\u0013\u0012d\u0010\u0014\u001a`\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u00120\u0015j\u0002`\u0016\u0012:\u0010\u0017\u001a6\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00120\u0018j\u0002`\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0002H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0097\u0001\u0010\u0007\u001a\u008a\u0001\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\bj\u0002`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rl\u0010\u0014\u001a`\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u00120\u0015j\u0002`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0017\u001a6\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00120\u0018j\u0002`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/EditTextInterceptor;", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/ViewInterceptor;", "Landroid/widget/EditText;", "maskingValidator", "Lcom/dynatrace/android/sessionreplay/tracking/validator/Validation;", "Landroid/view/View;", "securedViewValidator", "inputTakeFocusHandler", "Lkotlin/Function6;", "Lkotlin/ParameterName;", "name", "view", "", "field", "value", "", "isSecured", "isMasked", "", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/OnInputTakeFocus;", "inputLoseFocusHandler", "Lkotlin/Function4;", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/OnInputLoseFocus;", "inputTextChangeHandler", "Lkotlin/Function2;", "keystroke", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/OnInputTextChange;", "<init>", "(Lcom/dynatrace/android/sessionreplay/tracking/validator/Validation;Lcom/dynatrace/android/sessionreplay/tracking/validator/Validation;Lkotlin/jvm/functions/Function6;Lkotlin/jvm/functions/Function4;Lkotlin/jvm/functions/Function2;)V", "interceptView", "editText", "getResourceName", "Companion", "trackinglayer_release"})
public final class EditTextInterceptor
implements ViewInterceptor<EditText> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Validation<View> maskingValidator;
    @NotNull
    private final Validation<View> securedViewValidator;
    @NotNull
    private final Function6<View, String, String, String, Boolean, Boolean, Unit> inputTakeFocusHandler;
    @NotNull
    private final Function4<View, String, String, String, Unit> inputLoseFocusHandler;
    @NotNull
    private final Function2<View, String, Unit> inputTextChangeHandler;
    @NotNull
    private static final String UNKNOWN_RESOURCE_NAME = "Unknown name";

    public EditTextInterceptor(@NotNull Validation<? super View> maskingValidator, @NotNull Validation<? super View> securedViewValidator, @NotNull Function6<? super View, ? super String, ? super String, ? super String, ? super Boolean, ? super Boolean, Unit> inputTakeFocusHandler, @NotNull Function4<? super View, ? super String, ? super String, ? super String, Unit> inputLoseFocusHandler, @NotNull Function2<? super View, ? super String, Unit> inputTextChangeHandler) {
        Intrinsics.checkNotNullParameter(maskingValidator, (String)"maskingValidator");
        Intrinsics.checkNotNullParameter(securedViewValidator, (String)"securedViewValidator");
        Intrinsics.checkNotNullParameter(inputTakeFocusHandler, (String)"inputTakeFocusHandler");
        Intrinsics.checkNotNullParameter(inputLoseFocusHandler, (String)"inputLoseFocusHandler");
        Intrinsics.checkNotNullParameter(inputTextChangeHandler, (String)"inputTextChangeHandler");
        this.maskingValidator = maskingValidator;
        this.securedViewValidator = securedViewValidator;
        this.inputTakeFocusHandler = inputTakeFocusHandler;
        this.inputLoseFocusHandler = inputLoseFocusHandler;
        this.inputTextChangeHandler = inputTextChangeHandler;
    }

    @Override
    public void interceptView(@NotNull EditText editText) {
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        int id = editText.getId();
        String name = this.getResourceName(editText);
        String field = editText.getClass().getSimpleName();
        boolean isSecured = this.securedViewValidator.validate((View)editText);
        boolean isMasked = isSecured || this.maskingValidator.validate((View)editText);
        DTLogger.INSTANCE.tracking("Intercepting EditText " + id + " name: " + name);
        View.OnFocusChangeListener preFocusListener = editText.getOnFocusChangeListener();
        editText.setOnFocusChangeListener((arg_0, arg_1) -> EditTextInterceptor.interceptView$lambda$0(name, this, field, isSecured, isMasked, preFocusListener, arg_0, arg_1));
        if (!isSecured) {
            TrackableTextWatcher textWatcher = new TrackableTextWatcher(this.inputTextChangeHandler, new UIView((View)editText, null, null, 6, null));
            editText.addTextChangedListener((TextWatcher)textWatcher);
        }
        if (editText.hasFocus()) {
            Intrinsics.checkNotNull((Object)field);
            this.inputTakeFocusHandler.invoke((Object)editText, (Object)field, (Object)name, (Object)editText.getText().toString(), (Object)isSecured, (Object)isMasked);
        }
    }

    private final String getResourceName(EditText editText) {
        String string;
        if (ViewExtensionsKt.hasValidId((View)editText)) {
            String string2;
            try {
                string2 = editText.getResources().getResourceEntryName(editText.getId());
            }
            catch (Resources.NotFoundException e) {
                string2 = UNKNOWN_RESOURCE_NAME;
            }
            string = string2;
        } else {
            string = UNKNOWN_RESOURCE_NAME;
        }
        return string;
    }

    private static final void interceptView$lambda$0(String $name, EditTextInterceptor this$0, String $field, boolean $isSecured, boolean $isMasked, View.OnFocusChangeListener $preFocusListener, View view, boolean hasFocus) {
        block4: {
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.EditText");
            String value = ((EditText)view).getText().toString();
            boolean bl = hasFocus;
            if (bl) {
                DTLogger.INSTANCE.tracking("EditText " + $name + " has focus.");
                Function6<View, String, String, String, Boolean, Boolean, Unit> function6 = this$0.inputTakeFocusHandler;
                Intrinsics.checkNotNull((Object)$field);
                function6.invoke((Object)view, (Object)$field, (Object)$name, (Object)value, (Object)$isSecured, (Object)$isMasked);
            } else if (!bl) {
                DTLogger.INSTANCE.tracking("EditText " + $name + " lost focus.");
                Function4<View, String, String, String, Unit> function4 = this$0.inputLoseFocusHandler;
                Intrinsics.checkNotNull((Object)$field);
                function4.invoke((Object)view, (Object)$field, (Object)$name, (Object)value);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            View.OnFocusChangeListener onFocusChangeListener = $preFocusListener;
            if (onFocusChangeListener == null) break block4;
            onFocusChangeListener.onFocusChange(view, hasFocus);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/EditTextInterceptor$Companion;", "", "<init>", "()V", "UNKNOWN_RESOURCE_NAME", "", "trackinglayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

