/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.interceptors.impl;

import android.graphics.Point;
import android.view.View;
import android.view.ViewTreeObserver;
import com.dynatrace.android.sessionreplay.tracking.interceptors.ViewInterceptor;
import com.dynatrace.android.sessionreplay.tracking.utils.Debouncer;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0011\u0012\u0013B+\u0012\"\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/ViewScrollInterceptor;", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/ViewInterceptor;", "Landroid/view/View;", "scrollListener", "Lkotlin/Function3;", "", "", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/OnScrollChangeListenerCompat;", "<init>", "(Lkotlin/jvm/functions/Function3;)V", "interceptedViews", "Ljava/util/WeakHashMap;", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/ViewScrollInterceptor$ScrollState;", "observerOnScrollChangedListener", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/ViewScrollInterceptor$ScrollChangeListener;", "interceptView", "view", "ScrollChangeListener", "ScrollState", "Companion", "trackinglayer_release"})
public final class ViewScrollInterceptor
implements ViewInterceptor<View> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function3<View, Integer, Integer, Unit> scrollListener;
    @NotNull
    private final WeakHashMap<View, ScrollState> interceptedViews;
    @NotNull
    private final ScrollChangeListener observerOnScrollChangedListener;
    private static final long DELAY_MS = 100L;

    public ViewScrollInterceptor(@NotNull Function3<? super View, ? super Integer, ? super Integer, Unit> scrollListener) {
        Intrinsics.checkNotNullParameter(scrollListener, (String)"scrollListener");
        this.scrollListener = scrollListener;
        this.interceptedViews = new WeakHashMap();
        this.observerOnScrollChangedListener = new ScrollChangeListener();
    }

    @Override
    public void interceptView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (!this.interceptedViews.containsKey(view)) {
            view.getViewTreeObserver().removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this.observerOnScrollChangedListener);
            view.getViewTreeObserver().addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this.observerOnScrollChangedListener);
        }
        ((Map)this.interceptedViews).put(view, new ScrollState(new Point(view.getScrollX(), view.getScrollY()), this.scrollListener));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/ViewScrollInterceptor$Companion;", "", "<init>", "()V", "DELAY_MS", "", "trackinglayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/ViewScrollInterceptor$ScrollChangeListener;", "Landroid/view/ViewTreeObserver$OnScrollChangedListener;", "<init>", "(Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/ViewScrollInterceptor;)V", "debouncer", "Lcom/dynatrace/android/sessionreplay/tracking/utils/Debouncer;", "onScrollChanged", "", "trackinglayer_release"})
    @SourceDebugExtension(value={"SMAP\nViewScrollInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewScrollInterceptor.kt\ncom/dynatrace/android/sessionreplay/tracking/interceptors/impl/ViewScrollInterceptor$ScrollChangeListener\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,75:1\n216#2,2:76\n*S KotlinDebug\n*F\n+ 1 ViewScrollInterceptor.kt\ncom/dynatrace/android/sessionreplay/tracking/interceptors/impl/ViewScrollInterceptor$ScrollChangeListener\n*L\n39#1:76,2\n*E\n"})
    private final class ScrollChangeListener
    implements ViewTreeObserver.OnScrollChangedListener {
        @NotNull
        private final Debouncer debouncer = new Debouncer(null, 1, null);

        public void onScrollChanged() {
            Map $this$forEach$iv = ViewScrollInterceptor.this.interceptedViews;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                ScrollState it;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                View view = (View)entry.getKey();
                ScrollState state = (ScrollState)entry.getValue();
                int scrollX = view.getScrollX();
                int scrollY = view.getScrollY();
                if (state == null) continue;
                boolean bl2 = false;
                int oldScrollX = it.getLastPosition().x;
                int oldScrollY = it.getLastPosition().y;
                if (scrollX == oldScrollX && scrollY == oldScrollY) continue;
                it.setDx(it.getDx() + (scrollX - oldScrollX));
                it.setDy(it.getDy() + (scrollY - oldScrollY));
                it.getLastPosition().x = scrollX;
                it.getLastPosition().y = scrollY;
                this.debouncer.debounce(100L, (Function0<Unit>)((Function0)() -> ScrollChangeListener.onScrollChanged$lambda$2$lambda$1$lambda$0(it, view)));
            }
        }

        private static final Unit onScrollChanged$lambda$2$lambda$1$lambda$0(ScrollState $it, View $view) {
            Function3<View, Integer, Integer, Unit> function3 = $it.getListener();
            Intrinsics.checkNotNull((Object)$view);
            function3.invoke((Object)$view, (Object)$it.getDx(), (Object)$it.getDy());
            $it.setDx(0);
            $it.setDy(0);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\"\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005j\u0002`\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J%\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005j\u0002`\tH\u00c6\u0003J9\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032$\b\u0002\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005j\u0002`\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR-\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005j\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/ViewScrollInterceptor$ScrollState;", "", "lastPosition", "Landroid/graphics/Point;", "listener", "Lkotlin/Function3;", "Landroid/view/View;", "", "", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/OnScrollChangeListenerCompat;", "<init>", "(Landroid/graphics/Point;Lkotlin/jvm/functions/Function3;)V", "getLastPosition", "()Landroid/graphics/Point;", "getListener", "()Lkotlin/jvm/functions/Function3;", "dx", "getDx", "()I", "setDx", "(I)V", "dy", "getDy", "setDy", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "trackinglayer_release"})
    private static final class ScrollState {
        @NotNull
        private final Point lastPosition;
        @NotNull
        private final Function3<View, Integer, Integer, Unit> listener;
        private int dx;
        private int dy;

        public ScrollState(@NotNull Point lastPosition, @NotNull Function3<? super View, ? super Integer, ? super Integer, Unit> listener) {
            Intrinsics.checkNotNullParameter((Object)lastPosition, (String)"lastPosition");
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            this.lastPosition = lastPosition;
            this.listener = listener;
        }

        @NotNull
        public final Point getLastPosition() {
            return this.lastPosition;
        }

        @NotNull
        public final Function3<View, Integer, Integer, Unit> getListener() {
            return this.listener;
        }

        public final int getDx() {
            return this.dx;
        }

        public final void setDx(int n) {
            this.dx = n;
        }

        public final int getDy() {
            return this.dy;
        }

        public final void setDy(int n) {
            this.dy = n;
        }

        @NotNull
        public final Point component1() {
            return this.lastPosition;
        }

        @NotNull
        public final Function3<View, Integer, Integer, Unit> component2() {
            return this.listener;
        }

        @NotNull
        public final ScrollState copy(@NotNull Point lastPosition, @NotNull Function3<? super View, ? super Integer, ? super Integer, Unit> listener) {
            Intrinsics.checkNotNullParameter((Object)lastPosition, (String)"lastPosition");
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            return new ScrollState(lastPosition, listener);
        }

        public static /* synthetic */ ScrollState copy$default(ScrollState scrollState, Point point, Function3 function3, int n, Object object) {
            if ((n & 1) != 0) {
                point = scrollState.lastPosition;
            }
            if ((n & 2) != 0) {
                function3 = scrollState.listener;
            }
            return scrollState.copy(point, function3);
        }

        @NotNull
        public String toString() {
            return "ScrollState(lastPosition=" + this.lastPosition + ", listener=" + this.listener + ')';
        }

        public int hashCode() {
            int result = this.lastPosition.hashCode();
            result = result * 31 + this.listener.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScrollState)) {
                return false;
            }
            ScrollState scrollState = (ScrollState)other;
            if (!Intrinsics.areEqual((Object)this.lastPosition, (Object)scrollState.lastPosition)) {
                return false;
            }
            return Intrinsics.areEqual(this.listener, scrollState.listener);
        }
    }
}

