/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.screenshot;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.PixelCopy;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.WindowMetrics;
import androidx.annotation.RequiresApi;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.helpers.DebugBitmapHelper;
import com.dynatrace.android.sessionreplay.tracking.helpers.DebugOverlay;
import com.dynatrace.android.sessionreplay.tracking.model.UIContainer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2#\u0010\n\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00050\u000bH\u0007J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/screenshot/CustomAreaScreenshotHandler;", "", "<init>", "()V", "takePixelCopyScreenshot", "", "rootContainer", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIContainer;", "rect", "Landroid/graphics/Rect;", "onScreenshot", "Lkotlin/Function1;", "Landroid/graphics/Bitmap;", "Lkotlin/ParameterName;", "name", "bitmap", "takeScreenshot", "calculateIntersection", "customRect", "screenRect", "getScreenRect", "context", "Landroid/content/Context;", "trackinglayer_release"})
public final class CustomAreaScreenshotHandler {
    @RequiresApi(value=26)
    public final void takePixelCopyScreenshot(@NotNull UIContainer rootContainer, @NotNull Rect rect, @NotNull Function1<? super Bitmap, Unit> onScreenshot) {
        Intrinsics.checkNotNullParameter((Object)rootContainer, (String)"rootContainer");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter(onScreenshot, (String)"onScreenshot");
        View rootView = rootContainer.getContainerView();
        Window window = rootContainer.getContainerWindow();
        if (rootView == null || window == null) {
            DTLogger.INSTANCE.error("Can't take screenshot for custom event -> RootView or Window is null");
            onScreenshot.invoke(null);
            return;
        }
        rootView.post(() -> CustomAreaScreenshotHandler.takePixelCopyScreenshot$lambda$1(this, rect, rootView, window, onScreenshot, rootContainer));
    }

    @Nullable
    public final Bitmap takeScreenshot(@NotNull UIContainer rootContainer, @NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rootContainer, (String)"rootContainer");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        View rootView = rootContainer.getContainerView();
        if (rootView == null) {
            DTLogger.INSTANCE.error("Can't take screenshot for custom event -> RootView null");
            return null;
        }
        try {
            Bitmap bitmap = Bitmap.createBitmap((int)rootView.getWidth(), (int)rootView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
            Bitmap bitmap2 = bitmap;
            Canvas canvas = new Canvas(bitmap2);
            rootView.draw(canvas);
            Context context = rootView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            Rect finalRect = this.calculateIntersection(rect, this.getScreenRect(context));
            Bitmap bitmap3 = Bitmap.createBitmap((Bitmap)bitmap2, (int)finalRect.left, (int)finalRect.top, (int)finalRect.width(), (int)finalRect.height());
            Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"createBitmap(...)");
            Bitmap resultBitmap = bitmap3;
            DebugBitmapHelper.INSTANCE.saveBitmap$trackinglayer_release(rootView, resultBitmap);
            DebugOverlay.INSTANCE.showDebugOverlay(rootContainer, resultBitmap);
            DTLogger.INSTANCE.info("Screenshot done!");
            return resultBitmap;
        }
        catch (Exception ex) {
            DTLogger.INSTANCE.error("Error trying to take custom screenshot: " + ex);
            return null;
        }
    }

    private final Rect calculateIntersection(Rect customRect, Rect screenRect) {
        int left = RangesKt.coerceAtLeast((int)customRect.left, (int)screenRect.left);
        int top = RangesKt.coerceAtLeast((int)customRect.top, (int)screenRect.top);
        int right = RangesKt.coerceAtMost((int)customRect.right, (int)screenRect.right);
        int bottom = RangesKt.coerceAtMost((int)customRect.bottom, (int)screenRect.bottom);
        return new Rect(left, top, right, bottom);
    }

    private final Rect getScreenRect(Context context) {
        Object object = context.getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        WindowManager windowManager = (WindowManager)object;
        if (Build.VERSION.SDK_INT <= 29) {
            Display display = windowManager.getDefaultDisplay();
            DisplayMetrics displayMetrics = new DisplayMetrics();
            display.getRealMetrics(displayMetrics);
            return new Rect(0, 0, displayMetrics.widthPixels, displayMetrics.heightPixels);
        }
        WindowMetrics windowMetrics = windowManager.getCurrentWindowMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"getCurrentWindowMetrics(...)");
        WindowMetrics windowMetrics2 = windowMetrics;
        return new Rect(0, 0, windowMetrics2.getBounds().width(), windowMetrics2.getBounds().height());
    }

    private static final void takePixelCopyScreenshot$lambda$1$lambda$0(View $rootView, Bitmap $resultBitmap, UIContainer $rootContainer, Function1 $onScreenshot, int it) {
        DebugBitmapHelper.INSTANCE.saveBitmap$trackinglayer_release($rootView, $resultBitmap);
        DebugOverlay.INSTANCE.showDebugOverlay($rootContainer, $resultBitmap);
        DTLogger.INSTANCE.info("PixelCopy Screenshot done!");
        $onScreenshot.invoke((Object)$resultBitmap);
    }

    private static final void takePixelCopyScreenshot$lambda$1(CustomAreaScreenshotHandler this$0, Rect $rect, View $rootView, Window $window, Function1 $onScreenshot, UIContainer $rootContainer) {
        try {
            Context context = $rootView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            Rect finalRect = this$0.calculateIntersection($rect, this$0.getScreenRect(context));
            Bitmap bitmap = Bitmap.createBitmap((int)finalRect.width(), (int)finalRect.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
            Bitmap resultBitmap = bitmap;
            PixelCopy.request((Window)$window, (Rect)finalRect, (Bitmap)resultBitmap, arg_0 -> CustomAreaScreenshotHandler.takePixelCopyScreenshot$lambda$1$lambda$0($rootView, resultBitmap, $rootContainer, $onScreenshot, arg_0), (Handler)$rootView.getHandler());
        }
        catch (Exception ex) {
            DTLogger.INSTANCE.error("Error trying to take custom screenshot: " + ex);
            $onScreenshot.invoke(null);
        }
    }
}

