/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.trackers;

import android.app.Activity;
import android.graphics.Bitmap;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.extensions.ViewExtensionsKt;
import com.dynatrace.android.sessionreplay.tracking.listeners.UIState;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.model.ViewMetadata;
import com.dynatrace.android.sessionreplay.tracking.observer.TrackingObserver;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandler;
import com.dynatrace.android.sessionreplay.tracking.utils.ActivityUtilsKt;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\"\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/GenericEventTracker;", "", "trackingObserver", "Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;", "uiState", "Lcom/dynatrace/android/sessionreplay/tracking/listeners/UIState;", "screenshotHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;", "<init>", "(Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;Lcom/dynatrace/android/sessionreplay/tracking/listeners/UIState;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;)V", "trackGenericEvent", "", "name", "", "withScreenshot", "", "getActivityUIView", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIView;", "trackEvent", "viewMetadata", "Lcom/dynatrace/android/sessionreplay/tracking/model/ViewMetadata;", "bitmap", "Landroid/graphics/Bitmap;", "trackinglayer_release"})
public final class GenericEventTracker {
    @NotNull
    private final TrackingObserver trackingObserver;
    @NotNull
    private final UIState uiState;
    @NotNull
    private final ScreenshotHandler screenshotHandler;

    public GenericEventTracker(@NotNull TrackingObserver trackingObserver, @NotNull UIState uiState, @NotNull ScreenshotHandler screenshotHandler) {
        Intrinsics.checkNotNullParameter((Object)trackingObserver, (String)"trackingObserver");
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)screenshotHandler, (String)"screenshotHandler");
        this.trackingObserver = trackingObserver;
        this.uiState = uiState;
        this.screenshotHandler = screenshotHandler;
    }

    public final void trackGenericEvent(@NotNull String name, boolean withScreenshot) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        UIView uIView = this.getActivityUIView();
        if (uIView == null) {
            return;
        }
        UIView fullUIView = uIView;
        Object object = fullUIView.getView$trackinglayer_release();
        if (object == null || (object = ViewExtensionsKt.getMetadata(object)) == null) {
            return;
        }
        Object viewMetadata = object;
        if (withScreenshot) {
            this.screenshotHandler.takeScreenshot(fullUIView, (Function1<? super Bitmap, Unit>)((Function1)arg_0 -> GenericEventTracker.trackGenericEvent$lambda$0(this, name, (ViewMetadata)viewMetadata, arg_0)));
        } else {
            this.trackEvent(name, (ViewMetadata)viewMetadata, null);
        }
    }

    public static /* synthetic */ void trackGenericEvent$default(GenericEventTracker genericEventTracker, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        genericEventTracker.trackGenericEvent(string, bl);
    }

    private final UIView getActivityUIView() {
        UIView uIView;
        UIView uIView2 = this.uiState.getCurrentView();
        if ((uIView2 != null ? uIView2.getView$trackinglayer_release() : null) == null) {
            DTLogger.INSTANCE.warning("Generic Event: No activity provided by ActivityLifecycleCallbacks");
            Activity activity = ActivityUtilsKt.getRunningActivityByReflection();
            if (activity != null) {
                Activity it = activity;
                boolean bl = false;
                uIView = new UIView(it.getWindow().getDecorView(), it.getWindow(), null, 4, null);
            } else {
                GenericEventTracker $this$getActivityUIView_u24lambda_u242 = this;
                boolean bl = false;
                DTLogger.INSTANCE.error("Generic Event: Unable to get activity by reflection");
                uIView = null;
            }
        } else {
            uIView = this.uiState.getCurrentView();
        }
        return uIView;
    }

    private final void trackEvent(String name, ViewMetadata viewMetadata, Bitmap bitmap) {
        this.trackingObserver.onGenericEvent(new Date(), name, viewMetadata, false, bitmap);
    }

    private static final Unit trackGenericEvent$lambda$0(GenericEventTracker this$0, String $name, ViewMetadata $viewMetadata, Bitmap bitmap) {
        this$0.trackEvent($name, $viewMetadata, bitmap);
        return Unit.INSTANCE;
    }
}

