/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.utils;

import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.compose.ui.platform.ComposeView;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0002H\u0000\u001a\u0012\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006*\u00020\u0002H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0004*\u00020\u0002H\u0000\u001a\f\u0010\b\u001a\u00020\u0002*\u00020\u0002H\u0000\u00a8\u0006\t"}, d2={"getIdentityHashCode", "", "Landroid/view/View;", "isComposeView", "", "findComposeViews", "", "isVisible", "findDecorView", "trackinglayer_release"})
public final class ViewExtensionKt {
    public static final int getIdentityHashCode(@NotNull View $this$getIdentityHashCode) {
        Intrinsics.checkNotNullParameter((Object)$this$getIdentityHashCode, (String)"<this>");
        return System.identityHashCode($this$getIdentityHashCode);
    }

    public static final boolean isComposeView(@NotNull View $this$isComposeView) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isComposeView, (String)"<this>");
        try {
            bl = $this$isComposeView instanceof ComposeView;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final List<View> findComposeViews(@NotNull View $this$findComposeViews) {
        Intrinsics.checkNotNullParameter((Object)$this$findComposeViews, (String)"<this>");
        List composeViews = new ArrayList();
        Queue queue = new LinkedList();
        queue.add($this$findComposeViews);
        while (!queue.isEmpty()) {
            View currentView = (View)queue.remove();
            if (Intrinsics.areEqual((Object)currentView.getClass().getSimpleName(), (Object)"ComposeView")) {
                Intrinsics.checkNotNull((Object)currentView);
                composeViews.add(currentView);
            }
            if (!(currentView instanceof ViewGroup)) continue;
            int n = ((ViewGroup)currentView).getChildCount();
            int n2 = 0;
            while (n2 < n) {
                int childIndex = n2++;
                boolean bl = false;
                queue.add(((ViewGroup)currentView).getChildAt(childIndex));
            }
        }
        return composeViews;
    }

    public static final boolean isVisible(@NotNull View $this$isVisible) {
        Intrinsics.checkNotNullParameter((Object)$this$isVisible, (String)"<this>");
        return $this$isVisible.getVisibility() == 0 && $this$isVisible.getAlpha() > 0.0f;
    }

    @NotNull
    public static final View findDecorView(@NotNull View $this$findDecorView) {
        View view;
        Intrinsics.checkNotNullParameter((Object)$this$findDecorView, (String)"<this>");
        if (!($this$findDecorView.getParent() instanceof View) || Intrinsics.areEqual((Object)$this$findDecorView.getParent().getClass().getSimpleName(), (Object)"DecorView") || $this$findDecorView.getParent() == null) {
            view = $this$findDecorView;
        } else {
            ViewParent viewParent = $this$findDecorView.getParent();
            Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.View");
            view = ViewExtensionKt.findDecorView((View)viewParent);
        }
        return view;
    }
}

