/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils;

import com.ericsson.research.trap.utils.ChildFirstURLClassLoader;
import com.ericsson.research.trap.utils.PackageScanner;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossVFSPackageScanner
extends PackageScanner {
    Class<?>[] performScan(final String packageName, final ClassLoader c) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>[]>(){

                @Override
                public Class<?>[] run() throws Exception {
                    HashSet result = new HashSet();
                    return JBossVFSPackageScanner.this.recursiveScan(packageName, c, result, new ChildFirstURLClassLoader(new URL[0], c)).toArray(new Class[0]);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new IOException(e);
        }
    }

    HashSet<Class<?>> recursiveScan(String packageName, ClassLoader c, HashSet<Class<?>> result, ChildFirstURLClassLoader cfl) throws IOException {
        try {
            String pkgPath = packageName.replace('.', '/');
            Enumeration<URL> resources = c.getResources(pkgPath);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if (resource == null) {
                    System.err.println("Not found: " + pkgPath);
                    continue;
                }
                VirtualFile file = VFS.getChild((URI)resource.toURI());
                List children = file.getChildren();
                for (VirtualFile child : children) {
                    if (child.isFile()) {
                        try {
                            Class<?> clazz = c.loadClass(packageName.concat(".").concat(child.getName().split("\\.")[0]));
                            result.add(clazz);
                        }
                        catch (Throwable e) {}
                        continue;
                    }
                    if (!child.isDirectory()) continue;
                    this.recursiveScan(packageName + "." + child.getName(), c, result, cfl);
                }
            }
            return result;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }
}

