/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils;

import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JDKLoggerConfig {
    static Set<Logger> savedLoggers = Collections.synchronizedSet(new HashSet());

    public static void initForPrefixes(final Level level, String ... prefixes) {
        ConsoleHandler h = new ConsoleHandler(){

            public void publish(LogRecord record) {
                if (level.intValue() > record.getLevel().intValue()) {
                    return;
                }
                String formatted = this.getFormatter().format(record);
                System.out.print(formatted);
            }
        };
        h.setLevel(level);
        h.setFormatter(new Formatter(){

            public String format(LogRecord record) {
                String ln = record.getLoggerName();
                int length = Math.max(ln.length() - 25, 0);
                String name = ln.substring(length);
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(record.getMillis());
                int hour = c.get(11);
                int minute = c.get(12);
                int second = c.get(13);
                int ms = c.get(14);
                return "[" + String.format("%5.5s", record.getLevel()) + "] " + String.format("%02d:%02d:%02d.%03d", hour, minute, second, ms) + " {" + String.format("%25.25s", name) + "} - " + record.getMessage() + "\n";
            }
        });
        JDKLoggerConfig.initForPrefixes(level, h, prefixes);
    }

    public static void initForPrefixes(Level level, Handler h, String ... prefixes) {
        if (prefixes == null || prefixes.length == 0) {
            JDKLoggerConfig.processLogger("com.ericsson", level, h);
        } else {
            for (String prefix : prefixes) {
                JDKLoggerConfig.processLogger(prefix, level, h);
            }
        }
    }

    private static void processLogger(String string, Level level, Handler handler) {
        Logger logger = Logger.getLogger(string);
        logger.setLevel(level);
        for (Handler h : logger.getHandlers()) {
            logger.removeHandler(h);
        }
        logger.addHandler(handler);
        logger.setUseParentHandlers(false);
        savedLoggers.add(logger);
    }
}

