/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils;

import com.ericsson.research.trap.utils.RunnableFuture;
import java.lang.ref.WeakReference;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class WeakDelay
implements Delayed,
Runnable {
    private final long expiry;
    private final WeakReference<RunnableFuture> task;

    public WeakDelay(RunnableFuture task, long delay) {
        this.task = new WeakReference<RunnableFuture>(task);
        this.expiry = System.currentTimeMillis() + delay;
    }

    public int compareTo(Delayed other) {
        return (int)(this.getDelay(TimeUnit.MILLISECONDS) - other.getDelay(TimeUnit.MILLISECONDS));
    }

    public boolean equals(Object obj) {
        if (obj instanceof WeakDelay) {
            return this.compareTo((Delayed)obj) == 0 && ((WeakDelay)obj).task.equals(this.task);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public long getDelay(TimeUnit unit) {
        long remaining = this.expiry - System.currentTimeMillis();
        return unit.convert(remaining, TimeUnit.MILLISECONDS);
    }

    public void run() {
        RunnableFuture t = (RunnableFuture)this.task.get();
        if (t != null) {
            t.run();
        }
    }
}

