/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils;

import com.ericsson.research.trap.utils.EqualMappedWeakReference;
import com.ericsson.research.trap.utils.EqualWeakReference;
import com.ericsson.research.trap.utils.ReturnedEntry;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakMap<K, V>
implements Map<K, V> {
    ConcurrentSkipListMap<K, EqualMappedWeakReference<V>> values = new ConcurrentSkipListMap();
    ReferenceQueue<V> refQueue = new ReferenceQueue();

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.flushExpiredValues();
        return this.values.containsKey(key);
    }

    private void flushExpiredValues() {
        Reference<V> ref;
        while ((ref = this.refQueue.poll()) != null) {
            this.values.remove(((EqualMappedWeakReference)ref).key);
        }
        return;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(new EqualWeakReference<Object>(value));
    }

    @Override
    public V get(Object key) {
        this.flushExpiredValues();
        EqualWeakReference ref = this.values.get(key);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        this.flushExpiredValues();
        this.values.put(key, new EqualMappedWeakReference<V>(value, key, this.refQueue));
        return value;
    }

    @Override
    public V remove(Object key) {
        this.flushExpiredValues();
        EqualWeakReference ref = this.values.remove(key);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Set<Map.Entry<K, V>> entrySet = m.entrySet();
        Iterator<Map.Entry<K, V>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> o;
            Map.Entry<K, V> e = o = iterator.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Set<K> keySet() {
        this.flushExpiredValues();
        return this.values.keySet();
    }

    @Override
    public Collection<V> values() {
        Collection<EqualMappedWeakReference<V>> vs = this.values.values();
        HashSet rv = new HashSet();
        for (EqualWeakReference equalWeakReference : vs) {
            Object val = equalWeakReference.get();
            if (val == null) continue;
            rv.add(val);
        }
        this.flushExpiredValues();
        return rv;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.flushExpiredValues();
        Set<Map.Entry<K, EqualMappedWeakReference<V>>> entries = this.values.entrySet();
        HashSet<Map.Entry<K, V>> rv = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, EqualMappedWeakReference<V>> entry : entries) {
            Object v = entry.getValue().get();
            if (v == null) continue;
            ReturnedEntry e = new ReturnedEntry(entry.getKey(), entry.getValue().get(), this);
            rv.add(e);
        }
        return rv;
    }
}

