/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.flipper.plugins.fresco.objecthelper;

import android.text.TextUtils;
import com.facebook.drawee.backends.pipeline.info.ImageOriginUtils;
import com.facebook.drawee.backends.pipeline.info.ImagePerfData;
import com.facebook.drawee.generic.RoundingParams;
import com.facebook.flipper.core.FlipperArray;
import com.facebook.flipper.core.FlipperObject;
import com.facebook.flipper.core.FlipperValue;
import com.facebook.flipper.plugins.inspector.InspectorValue;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.debug.FlipperImageTracker;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class FlipperObjectHelper {
    public FlipperObject keyValuePair(String key, @Nullable String value) {
        return new FlipperObject.Builder().put(key, value).build();
    }

    @Nullable
    public FlipperObject toFlipperObject(@Nullable Map<String, String> stringMap) {
        if (stringMap == null) {
            return null;
        }
        FlipperObject.Builder optionsJson = new FlipperObject.Builder();
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            optionsJson.put(entry.getKey(), entry.getValue());
        }
        return optionsJson.build();
    }

    @Nullable
    public FlipperObject toFlipperObject(@Nullable ImageRequest imageRequest) {
        if (imageRequest == null) {
            return null;
        }
        FlipperObject.Builder optionsJson = new FlipperObject.Builder();
        return this.addImageRequestProperties(optionsJson, imageRequest).build();
    }

    @Nullable
    public FlipperObject toFlipperObject(@Nullable FlipperImageTracker.ImageDebugData imageDebugData) {
        if (imageDebugData == null) {
            return null;
        }
        FlipperObject.Builder optionsJson = new FlipperObject.Builder();
        optionsJson.put("imageId", imageDebugData.getUniqueId());
        optionsJson.put("imageRequest", this.toFlipperObject(imageDebugData.getImageRequest()));
        optionsJson.put("requestId", imageDebugData.getRequestIds() != null ? TextUtils.join((CharSequence)", ", (Iterable)imageDebugData.getRequestIds()) : "");
        optionsJson.put("imagePerfData", this.toFlipperObject(imageDebugData.getImagePerfData()));
        return optionsJson.build();
    }

    @Nullable
    public FlipperObject toFlipperObject(@Nullable ImageDecodeOptions options) {
        if (options == null) {
            return null;
        }
        FlipperObject.Builder optionsJson = new FlipperObject.Builder();
        optionsJson.put("minDecodeIntervalMs", Integer.valueOf(options.minDecodeIntervalMs));
        optionsJson.put("decodePreviewFrame", Boolean.valueOf(options.decodePreviewFrame));
        optionsJson.put("useLastFrameForPreview", Boolean.valueOf(options.useLastFrameForPreview));
        optionsJson.put("decodeAllFrames", Boolean.valueOf(options.decodeAllFrames));
        optionsJson.put("forceStaticImage", Boolean.valueOf(options.forceStaticImage));
        optionsJson.put("bitmapConfig", options.bitmapConfig.name());
        optionsJson.put("customImageDecoder", options.customImageDecoder == null ? "" : options.customImageDecoder.toString());
        return optionsJson.build();
    }

    @Nullable
    public FlipperObject toFlipperObject(@Nullable ResizeOptions resizeOptions) {
        if (resizeOptions == null) {
            return null;
        }
        FlipperObject.Builder optionsJson = new FlipperObject.Builder();
        optionsJson.put("width", Integer.valueOf(resizeOptions.width));
        optionsJson.put("height", Integer.valueOf(resizeOptions.height));
        optionsJson.put("maxBitmapSize", Float.valueOf(resizeOptions.maxBitmapSize));
        optionsJson.put("roundUpFraction", Float.valueOf(resizeOptions.roundUpFraction));
        return optionsJson.build();
    }

    @Nullable
    public FlipperObject toFlipperObject(@Nullable RotationOptions rotationOptions) {
        if (rotationOptions == null) {
            return null;
        }
        FlipperObject.Builder optionsJson = new FlipperObject.Builder();
        optionsJson.put("rotationEnabled", Boolean.valueOf(rotationOptions.rotationEnabled()));
        optionsJson.put("canDeferUntilRendered", Boolean.valueOf(rotationOptions.canDeferUntilRendered()));
        optionsJson.put("useImageMetadata", Boolean.valueOf(rotationOptions.useImageMetadata()));
        if (!rotationOptions.useImageMetadata()) {
            optionsJson.put("forcedAngle", Integer.valueOf(rotationOptions.getForcedAngle()));
        }
        return optionsJson.build();
    }

    @Nullable
    public FlipperObject toFlipperObject(@Nullable RoundingParams roundingParams) {
        if (roundingParams == null) {
            return null;
        }
        FlipperObject.Builder optionsJson = new FlipperObject.Builder();
        optionsJson.put("borderWidth", Float.valueOf(roundingParams.getBorderWidth()));
        optionsJson.put("cornersRadii", this.toSonarArray(roundingParams.getCornersRadii()));
        optionsJson.put("padding", Float.valueOf(roundingParams.getPadding()));
        optionsJson.put("roundAsCircle", Boolean.valueOf(roundingParams.getRoundAsCircle()));
        optionsJson.put("roundingMethod", (Object)roundingParams.getRoundingMethod());
        optionsJson.put("borderColor", (FlipperValue)InspectorValue.immutable((InspectorValue.Type)InspectorValue.Type.Color, (Object)roundingParams.getBorderColor()));
        optionsJson.put("overlayColor", (FlipperValue)InspectorValue.immutable((InspectorValue.Type)InspectorValue.Type.Color, (Object)roundingParams.getOverlayColor()));
        return optionsJson.build();
    }

    @Nullable
    public FlipperObject toFlipperObject(@Nullable ImagePerfData imagePerfData) {
        if (imagePerfData == null) {
            return null;
        }
        FlipperObject.Builder objectJson = new FlipperObject.Builder();
        objectJson.put("requestId", imagePerfData.getRequestId());
        objectJson.put("controllerSubmitTimeMs", Long.valueOf(imagePerfData.getControllerSubmitTimeMs()));
        objectJson.put("controllerFinalTimeMs", Long.valueOf(imagePerfData.getControllerFinalImageSetTimeMs()));
        objectJson.put("imageRequestStartTimeMs", Long.valueOf(imagePerfData.getImageRequestStartTimeMs()));
        objectJson.put("imageRequestEndTimeMs", Long.valueOf(imagePerfData.getImageRequestEndTimeMs()));
        objectJson.put("imageOrigin", ImageOriginUtils.toString((int)imagePerfData.getImageOrigin()));
        objectJson.put("isPrefetch", Boolean.valueOf(imagePerfData.isPrefetch()));
        objectJson.put("callerContext", imagePerfData.getCallerContext());
        objectJson.put("imageRequest", this.toFlipperObject(imagePerfData.getImageRequest()));
        objectJson.put("imageInfo", this.toFlipperObject(imagePerfData.getImageInfo()));
        return objectJson.build();
    }

    @Nullable
    public FlipperObject toFlipperObject(ImageInfo imageInfo) {
        if (imageInfo == null) {
            return null;
        }
        FlipperObject.Builder objectJson = new FlipperObject.Builder();
        objectJson.put("imageWidth", Integer.valueOf(imageInfo.getWidth()));
        objectJson.put("imageHeight", Integer.valueOf(imageInfo.getHeight()));
        objectJson.put("qualityInfo", this.toFlipperObject(imageInfo.getQualityInfo()));
        return objectJson.build();
    }

    @Nullable
    public FlipperObject toFlipperObject(QualityInfo qualityInfo) {
        if (qualityInfo == null) {
            return null;
        }
        FlipperObject.Builder objectJson = new FlipperObject.Builder();
        objectJson.put("quality", Integer.valueOf(qualityInfo.getQuality()));
        objectJson.put("isGoodEnoughQuality", Boolean.valueOf(qualityInfo.isOfGoodEnoughQuality()));
        objectJson.put("isFullQuality", Boolean.valueOf(qualityInfo.isOfFullQuality()));
        return objectJson.build();
    }

    public FlipperObject.Builder addImageRequestProperties(FlipperObject.Builder builder, @Nullable ImageRequest request) {
        if (request == null) {
            return builder;
        }
        builder.put("sourceUri", (Object)request.getSourceUri()).put("preferredWidth", Integer.valueOf(request.getPreferredWidth())).put("preferredHeight", Integer.valueOf(request.getPreferredHeight())).put("cacheChoice", (Object)request.getCacheChoice()).put("diskCacheEnabled", Boolean.valueOf(request.isDiskCacheEnabled())).put("localThumbnailPreviewsEnabled", Boolean.valueOf(request.getLocalThumbnailPreviewsEnabled())).put("lowestPermittedRequestLevel", (Object)request.getLowestPermittedRequestLevel()).put("priority", request.getPriority().name()).put("progressiveRenderingEnabled", Boolean.valueOf(request.getProgressiveRenderingEnabled())).put("postprocessor", String.valueOf(request.getPostprocessor())).put("requestListener", String.valueOf(request.getRequestListener())).put("imageDecodeOptions", this.toFlipperObject(request.getImageDecodeOptions())).put("bytesRange", (Object)request.getBytesRange()).put("resizeOptions", this.toFlipperObject(request.getResizeOptions())).put("rotationOptions", this.toFlipperObject(request.getRotationOptions()));
        return builder;
    }

    private FlipperArray toSonarArray(float[] floats) {
        FlipperArray.Builder builder = new FlipperArray.Builder();
        for (float f : floats) {
            builder.put(Float.valueOf(f));
        }
        return builder.build();
    }

    @Nullable
    public abstract FlipperArray fromCallerContext(@Nullable Object var1);
}

