/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.cache;

import android.net.Uri;
import com.facebook.cache.common.CacheKey;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class AnimationFrameCacheKey
implements CacheKey {
    private static final String URI_PREFIX = "anim://";
    private final String mAnimationUriString;
    private final boolean mDeepEquals;

    public AnimationFrameCacheKey(int imageId) {
        this(imageId, false);
    }

    public AnimationFrameCacheKey(int imageId, boolean deepEquals) {
        this.mAnimationUriString = URI_PREFIX + imageId;
        this.mDeepEquals = deepEquals;
    }

    public boolean containsUri(Uri uri) {
        return uri.toString().startsWith(this.mAnimationUriString);
    }

    public String getUriString() {
        return this.mAnimationUriString;
    }

    public boolean isResourceIdForDebugging() {
        return false;
    }

    public boolean equals(@Nullable Object o) {
        if (!this.mDeepEquals) {
            return super.equals(o);
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnimationFrameCacheKey that = (AnimationFrameCacheKey)o;
        return this.mAnimationUriString.equals(that.mAnimationUriString);
    }

    public int hashCode() {
        if (!this.mDeepEquals) {
            return super.hashCode();
        }
        return this.mAnimationUriString.hashCode();
    }
}

