/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.cache.disk;

import android.content.Context;
import com.facebook.cache.common.CacheErrorLogger;
import com.facebook.cache.common.CacheEventListener;
import com.facebook.cache.common.NoOpCacheErrorLogger;
import com.facebook.cache.common.NoOpCacheEventListener;
import com.facebook.cache.disk.DefaultEntryEvictionComparatorSupplier;
import com.facebook.cache.disk.EntryEvictionComparatorSupplier;
import com.facebook.common.disk.DiskTrimmableRegistry;
import com.facebook.common.disk.NoOpDiskTrimmableRegistry;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Supplier;
import com.facebook.common.internal.Suppliers;
import java.io.File;
import javax.annotation.Nullable;

public class DiskCacheConfig {
    private final int mVersion;
    private final String mBaseDirectoryName;
    private final Supplier<File> mBaseDirectoryPathSupplier;
    private final long mDefaultSizeLimit;
    private final long mLowDiskSpaceSizeLimit;
    private final long mMinimumSizeLimit;
    private final EntryEvictionComparatorSupplier mEntryEvictionComparatorSupplier;
    private final CacheErrorLogger mCacheErrorLogger;
    private final CacheEventListener mCacheEventListener;
    private final DiskTrimmableRegistry mDiskTrimmableRegistry;
    private final Context mContext;

    private DiskCacheConfig(Builder builder) {
        this.mVersion = builder.mVersion;
        this.mBaseDirectoryName = (String)Preconditions.checkNotNull((Object)builder.mBaseDirectoryName);
        this.mBaseDirectoryPathSupplier = (Supplier)Preconditions.checkNotNull((Object)builder.mBaseDirectoryPathSupplier);
        this.mDefaultSizeLimit = builder.mMaxCacheSize;
        this.mLowDiskSpaceSizeLimit = builder.mMaxCacheSizeOnLowDiskSpace;
        this.mMinimumSizeLimit = builder.mMaxCacheSizeOnVeryLowDiskSpace;
        this.mEntryEvictionComparatorSupplier = (EntryEvictionComparatorSupplier)Preconditions.checkNotNull((Object)builder.mEntryEvictionComparatorSupplier);
        this.mCacheErrorLogger = builder.mCacheErrorLogger == null ? NoOpCacheErrorLogger.getInstance() : builder.mCacheErrorLogger;
        this.mCacheEventListener = builder.mCacheEventListener == null ? NoOpCacheEventListener.getInstance() : builder.mCacheEventListener;
        this.mDiskTrimmableRegistry = builder.mDiskTrimmableRegistry == null ? NoOpDiskTrimmableRegistry.getInstance() : builder.mDiskTrimmableRegistry;
        this.mContext = builder.mContext;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public String getBaseDirectoryName() {
        return this.mBaseDirectoryName;
    }

    public Supplier<File> getBaseDirectoryPathSupplier() {
        return this.mBaseDirectoryPathSupplier;
    }

    public long getDefaultSizeLimit() {
        return this.mDefaultSizeLimit;
    }

    public long getLowDiskSpaceSizeLimit() {
        return this.mLowDiskSpaceSizeLimit;
    }

    public long getMinimumSizeLimit() {
        return this.mMinimumSizeLimit;
    }

    public EntryEvictionComparatorSupplier getEntryEvictionComparatorSupplier() {
        return this.mEntryEvictionComparatorSupplier;
    }

    public CacheErrorLogger getCacheErrorLogger() {
        return this.mCacheErrorLogger;
    }

    public CacheEventListener getCacheEventListener() {
        return this.mCacheEventListener;
    }

    public DiskTrimmableRegistry getDiskTrimmableRegistry() {
        return this.mDiskTrimmableRegistry;
    }

    public Context getContext() {
        return this.mContext;
    }

    public static Builder newBuilder(@Nullable Context context) {
        return new Builder(context);
    }

    public static class Builder {
        private int mVersion = 1;
        private String mBaseDirectoryName = "image_cache";
        private Supplier<File> mBaseDirectoryPathSupplier;
        private long mMaxCacheSize = 0x2800000L;
        private long mMaxCacheSizeOnLowDiskSpace = 0xA00000L;
        private long mMaxCacheSizeOnVeryLowDiskSpace = 0x200000L;
        private EntryEvictionComparatorSupplier mEntryEvictionComparatorSupplier = new DefaultEntryEvictionComparatorSupplier();
        private CacheErrorLogger mCacheErrorLogger;
        private CacheEventListener mCacheEventListener;
        private DiskTrimmableRegistry mDiskTrimmableRegistry;
        @Nullable
        private final Context mContext;

        private Builder(@Nullable Context context) {
            this.mContext = context;
        }

        public Builder setVersion(int version) {
            this.mVersion = version;
            return this;
        }

        public Builder setBaseDirectoryName(String baseDirectoryName) {
            this.mBaseDirectoryName = baseDirectoryName;
            return this;
        }

        public Builder setBaseDirectoryPath(File baseDirectoryPath) {
            this.mBaseDirectoryPathSupplier = Suppliers.of((Object)baseDirectoryPath);
            return this;
        }

        public Builder setBaseDirectoryPathSupplier(Supplier<File> baseDirectoryPathSupplier) {
            this.mBaseDirectoryPathSupplier = baseDirectoryPathSupplier;
            return this;
        }

        public Builder setMaxCacheSize(long maxCacheSize) {
            this.mMaxCacheSize = maxCacheSize;
            return this;
        }

        public Builder setMaxCacheSizeOnLowDiskSpace(long maxCacheSizeOnLowDiskSpace) {
            this.mMaxCacheSizeOnLowDiskSpace = maxCacheSizeOnLowDiskSpace;
            return this;
        }

        public Builder setMaxCacheSizeOnVeryLowDiskSpace(long maxCacheSizeOnVeryLowDiskSpace) {
            this.mMaxCacheSizeOnVeryLowDiskSpace = maxCacheSizeOnVeryLowDiskSpace;
            return this;
        }

        public Builder setEntryEvictionComparatorSupplier(EntryEvictionComparatorSupplier supplier) {
            this.mEntryEvictionComparatorSupplier = supplier;
            return this;
        }

        public Builder setCacheErrorLogger(CacheErrorLogger cacheErrorLogger) {
            this.mCacheErrorLogger = cacheErrorLogger;
            return this;
        }

        public Builder setCacheEventListener(CacheEventListener cacheEventListener) {
            this.mCacheEventListener = cacheEventListener;
            return this;
        }

        public Builder setDiskTrimmableRegistry(DiskTrimmableRegistry diskTrimmableRegistry) {
            this.mDiskTrimmableRegistry = diskTrimmableRegistry;
            return this;
        }

        public DiskCacheConfig build() {
            Preconditions.checkState((this.mBaseDirectoryPathSupplier != null || this.mContext != null ? 1 : 0) != 0, (Object)"Either a non-null context or a base directory path or supplier must be provided.");
            if (this.mBaseDirectoryPathSupplier == null && this.mContext != null) {
                this.mBaseDirectoryPathSupplier = new Supplier<File>(){

                    public File get() {
                        return Builder.this.mContext.getApplicationContext().getCacheDir();
                    }
                };
            }
            return new DiskCacheConfig(this);
        }
    }
}

