/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.cache.disk;

import android.content.Context;
import android.content.SharedPreferences;
import com.facebook.binaryresource.BinaryResource;
import com.facebook.cache.common.CacheErrorLogger;
import com.facebook.cache.common.CacheEventListener;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.MultiCacheKey;
import com.facebook.cache.common.WriterCallback;
import com.facebook.cache.disk.DiskStorage;
import com.facebook.cache.disk.DiskStorageCacheUtil;
import com.facebook.cache.disk.EntryEvictionComparatorSupplier;
import com.facebook.cache.disk.FileCache;
import com.facebook.cache.disk.SettableCacheEvent;
import com.facebook.common.disk.DiskTrimmable;
import com.facebook.common.disk.DiskTrimmableRegistry;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.common.statfs.StatFsHelper;
import com.facebook.common.time.Clock;
import com.facebook.common.time.SystemClock;
import com.facebook.common.util.SecureHashUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class DiskStorageCache
implements FileCache,
DiskTrimmable {
    private static final Class<?> TAG = DiskStorageCache.class;
    public static final int START_OF_VERSIONING = 1;
    private static final long FUTURE_TIMESTAMP_THRESHOLD_MS = TimeUnit.HOURS.toMillis(2L);
    private static final long FILECACHE_SIZE_UPDATE_PERIOD_MS = TimeUnit.MINUTES.toMillis(30L);
    private static final double TRIMMING_LOWER_BOUND = 0.02;
    private static final long UNINITIALIZED = -1L;
    private static final String SHARED_PREFS_FILENAME_PREFIX = "disk_entries_list";
    private final long mLowDiskSpaceCacheSizeLimit;
    private final long mDefaultCacheSizeLimit;
    private final CountDownLatch mCountDownLatch = new CountDownLatch(1);
    private long mCacheSizeLimit;
    private final CacheEventListener mCacheEventListener;
    private final SharedPreferences mSharedPreferences;
    @GuardedBy(value="mLock")
    @VisibleForTesting
    Map<Integer, String> mIndex = new HashMap<Integer, String>();
    @GuardedBy(value="mLock")
    @VisibleForTesting
    final Set<String> mResourceIndex;
    @GuardedBy(value="mLock")
    private long mCacheSizeLastUpdateTime;
    private final long mCacheSizeLimitMinimum;
    private final StatFsHelper mStatFsHelper;
    private final DiskStorage mStorage;
    private final EntryEvictionComparatorSupplier mEntryEvictionComparatorSupplier;
    private final CacheErrorLogger mCacheErrorLogger;
    private final CacheStats mCacheStats;
    private final Clock mClock;
    private final Object mLock = new Object();

    public DiskStorageCache(DiskStorage diskStorage, EntryEvictionComparatorSupplier entryEvictionComparatorSupplier, Params params, CacheEventListener cacheEventListener, CacheErrorLogger cacheErrorLogger, @Nullable DiskTrimmableRegistry diskTrimmableRegistry, Context context) {
        this.mLowDiskSpaceCacheSizeLimit = params.mLowDiskSpaceCacheSizeLimit;
        this.mDefaultCacheSizeLimit = params.mDefaultCacheSizeLimit;
        this.mCacheSizeLimit = params.mDefaultCacheSizeLimit;
        this.mStatFsHelper = StatFsHelper.getInstance();
        this.mStorage = diskStorage;
        this.mEntryEvictionComparatorSupplier = entryEvictionComparatorSupplier;
        this.mCacheSizeLastUpdateTime = -1L;
        this.mCacheEventListener = cacheEventListener;
        this.mCacheSizeLimitMinimum = params.mCacheSizeLimitMinimum;
        this.mCacheErrorLogger = cacheErrorLogger;
        this.mCacheStats = new CacheStats();
        if (diskTrimmableRegistry != null) {
            diskTrimmableRegistry.registerDiskTrimmable((DiskTrimmable)this);
        }
        this.mClock = SystemClock.get();
        this.mSharedPreferences = DiskStorageCache.initializeSharedPreferences(context, this.mStorage.getStorageName());
        this.mResourceIndex = new HashSet<String>();
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = DiskStorageCache.this.mLock;
                synchronized (object) {
                    DiskStorageCache.this.maybeUpdateFileCacheSize();
                }
                DiskStorageCache.this.mCountDownLatch.countDown();
            }
        });
    }

    @Override
    public DiskStorage.DiskDumpInfo getDumpInfo() throws IOException {
        return this.mStorage.getDumpInfo();
    }

    @Override
    public boolean isEnabled() {
        return this.mStorage.isEnabled();
    }

    @VisibleForTesting
    protected void awaitIndex() {
        try {
            this.mCountDownLatch.await();
        }
        catch (InterruptedException e) {
            FLog.e(TAG, (String)"Memory Index is not ready yet. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryResource getResource(CacheKey key) {
        String resourceId = null;
        SettableCacheEvent cacheEvent = new SettableCacheEvent().setCacheKey(key);
        Integer hashKey = key.hashCode();
        try {
            Object object = this.mLock;
            synchronized (object) {
                BinaryResource resource = null;
                if (this.mIndex.containsKey(hashKey)) {
                    resourceId = this.mIndex.get(hashKey);
                    cacheEvent.setResourceId(resourceId);
                    resource = this.mStorage.getResource(resourceId, key);
                } else {
                    List<String> resourceIds = DiskStorageCache.getResourceIds(key);
                    for (int i = 0; i < resourceIds.size(); ++i) {
                        resourceId = resourceIds.get(i);
                        if (!this.mResourceIndex.contains(resourceId)) continue;
                        cacheEvent.setResourceId(resourceId);
                        resource = this.mStorage.getResource(resourceId, key);
                        if (resource != null) break;
                    }
                }
                if (resource == null) {
                    this.mCacheEventListener.onMiss(cacheEvent);
                    this.removeKeyFromIndex(hashKey);
                } else {
                    this.mCacheEventListener.onHit(cacheEvent);
                    this.addKeyToIndex(hashKey, resourceId);
                }
                return resource;
            }
        }
        catch (IOException ioe) {
            this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.GENERIC_IO, TAG, "getResource", ioe);
            cacheEvent.setException(ioe);
            this.mCacheEventListener.onReadException(cacheEvent);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean probe(CacheKey key) {
        String resourceId = null;
        try {
            Object object = this.mLock;
            synchronized (object) {
                boolean retval = false;
                Integer hashKey = key.hashCode();
                if (this.mIndex.containsKey(hashKey)) {
                    resourceId = this.mIndex.get(hashKey);
                    retval = this.mStorage.touch(resourceId, key);
                } else {
                    List<String> resourceIds = DiskStorageCache.getResourceIds(key);
                    for (int i = 0; !(i >= resourceIds.size() || this.mResourceIndex.contains(resourceId = resourceIds.get(i)) && (retval = this.mStorage.touch(resourceId, key))); ++i) {
                    }
                }
                if (retval) {
                    this.addKeyToIndex(hashKey, resourceId);
                }
                return retval;
            }
        }
        catch (IOException e) {
            this.mCacheEventListener.onReadException(new SettableCacheEvent().setCacheKey(key).setResourceId(resourceId).setException(e));
            return false;
        }
    }

    private DiskStorage.Inserter startInsert(String resourceId, CacheKey key) throws IOException {
        this.maybeEvictFilesInCacheDir();
        return this.mStorage.insert(resourceId, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryResource endInsert(DiskStorage.Inserter inserter, CacheKey key, String resourceId) throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            BinaryResource resource = inserter.commit(key);
            this.addKeyToIndex(key.hashCode(), resourceId);
            this.mCacheStats.increment(resource.size(), 1L);
            return resource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryResource insert(CacheKey key, WriterCallback callback) throws IOException {
        BinaryResource binaryResource;
        block9: {
            String resourceId;
            SettableCacheEvent cacheEvent = new SettableCacheEvent().setCacheKey(key);
            this.mCacheEventListener.onWriteAttempt(cacheEvent);
            Object object = this.mLock;
            synchronized (object) {
                Integer hashKey = key.hashCode();
                resourceId = this.mIndex.containsKey(hashKey) ? this.mIndex.get(hashKey) : DiskStorageCache.getFirstResourceId(key);
            }
            cacheEvent.setResourceId(resourceId);
            DiskStorage.Inserter inserter = this.startInsert(resourceId, key);
            try {
                inserter.writeData(callback, key);
                BinaryResource resource = this.endInsert(inserter, key, resourceId);
                cacheEvent.setItemSize(resource.size()).setCacheSize(this.mCacheStats.getSize());
                this.mCacheEventListener.onWriteSuccess(cacheEvent);
                binaryResource = resource;
                if (inserter.cleanUp()) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (!inserter.cleanUp()) {
                        FLog.e(TAG, (String)"Failed to delete temp file");
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    cacheEvent.setException(ioe);
                    this.mCacheEventListener.onWriteException(cacheEvent);
                    FLog.e(TAG, (String)"Failed inserting a file into the cache", (Throwable)ioe);
                    throw ioe;
                }
            }
            FLog.e(TAG, (String)"Failed to delete temp file");
        }
        return binaryResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(CacheKey key) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                String resourceId = null;
                Integer hashKey = key.hashCode();
                if (this.mIndex.containsKey(hashKey)) {
                    resourceId = this.mIndex.get(hashKey);
                    this.mStorage.remove(resourceId);
                } else {
                    List<String> resourceIds = DiskStorageCache.getResourceIds(key);
                    for (int i = 0; i < resourceIds.size(); ++i) {
                        resourceId = resourceIds.get(i);
                        this.mStorage.remove(resourceId);
                    }
                }
                this.removeKeyFromIndex(hashKey);
            }
            catch (IOException e) {
                this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.DELETE_FILE, TAG, "delete: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long clearOldEntries(long cacheExpirationMs) {
        long oldestRemainingEntryAgeMs = 0L;
        Object object = this.mLock;
        synchronized (object) {
            try {
                long now = this.mClock.now();
                Collection<DiskStorage.Entry> allEntries = this.mStorage.getEntries();
                long cacheSizeBeforeClearance = this.mCacheStats.getSize();
                int itemsRemovedCount = 0;
                long itemsRemovedSize = 0L;
                for (DiskStorage.Entry entry : allEntries) {
                    long entryAgeMs = Math.max(1L, Math.abs(now - entry.getTimestamp()));
                    if (entryAgeMs >= cacheExpirationMs) {
                        long entryRemovedSize = this.mStorage.remove(entry);
                        this.removeValueFromIndex(entry.getId());
                        if (entryRemovedSize <= 0L) continue;
                        ++itemsRemovedCount;
                        this.mCacheEventListener.onEviction(new SettableCacheEvent().setResourceId(entry.getId()).setEvictionReason(CacheEventListener.EvictionReason.CONTENT_STALE).setItemSize(entryRemovedSize).setCacheSize(cacheSizeBeforeClearance - (itemsRemovedSize += entryRemovedSize)));
                        continue;
                    }
                    oldestRemainingEntryAgeMs = Math.max(oldestRemainingEntryAgeMs, entryAgeMs);
                }
                this.mStorage.purgeUnexpectedResources();
                if (itemsRemovedCount > 0) {
                    this.maybeUpdateFileCacheSize();
                    this.mCacheStats.increment(-itemsRemovedSize, -itemsRemovedCount);
                }
            }
            catch (IOException ioe) {
                this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.EVICTION, TAG, "clearOldEntries: " + ioe.getMessage(), ioe);
            }
        }
        return oldestRemainingEntryAgeMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeEvictFilesInCacheDir() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            boolean calculatedRightNow = this.maybeUpdateFileCacheSize();
            this.updateFileCacheSizeLimit();
            long cacheSize = this.mCacheStats.getSize();
            if (cacheSize > this.mCacheSizeLimit && !calculatedRightNow) {
                this.mCacheStats.reset();
                this.maybeUpdateFileCacheSize();
            }
            if (cacheSize > this.mCacheSizeLimit) {
                this.evictAboveSize(this.mCacheSizeLimit * 9L / 10L, CacheEventListener.EvictionReason.CACHE_FULL);
            }
        }
    }

    @GuardedBy(value="mLock")
    private void evictAboveSize(long desiredSize, CacheEventListener.EvictionReason reason) throws IOException {
        Collection<DiskStorage.Entry> entries;
        try {
            entries = this.getSortedEntries(this.mStorage.getEntries());
        }
        catch (IOException ioe) {
            this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.EVICTION, TAG, "evictAboveSize: " + ioe.getMessage(), ioe);
            throw ioe;
        }
        long cacheSizeBeforeClearance = this.mCacheStats.getSize();
        long deleteSize = cacheSizeBeforeClearance - desiredSize;
        int itemCount = 0;
        long sumItemSizes = 0L;
        for (DiskStorage.Entry entry : entries) {
            if (sumItemSizes > deleteSize) break;
            long deletedSize = this.mStorage.remove(entry);
            this.removeValueFromIndex(entry.getId());
            if (deletedSize <= 0L) continue;
            ++itemCount;
            this.mCacheEventListener.onEviction(new SettableCacheEvent().setResourceId(entry.getId()).setEvictionReason(reason).setItemSize(deletedSize).setCacheSize(cacheSizeBeforeClearance - (sumItemSizes += deletedSize)).setCacheLimit(desiredSize));
        }
        this.mCacheStats.increment(-sumItemSizes, -itemCount);
        this.mStorage.purgeUnexpectedResources();
    }

    private Collection<DiskStorage.Entry> getSortedEntries(Collection<DiskStorage.Entry> allEntries) {
        long threshold = this.mClock.now() + FUTURE_TIMESTAMP_THRESHOLD_MS;
        ArrayList<DiskStorage.Entry> sortedList = new ArrayList<DiskStorage.Entry>(allEntries.size());
        ArrayList<DiskStorage.Entry> listToSort = new ArrayList<DiskStorage.Entry>(allEntries.size());
        for (DiskStorage.Entry entry : allEntries) {
            if (entry.getTimestamp() > threshold) {
                sortedList.add(entry);
                continue;
            }
            listToSort.add(entry);
        }
        Collections.sort(listToSort, this.mEntryEvictionComparatorSupplier.get());
        sortedList.addAll(listToSort);
        return sortedList;
    }

    @GuardedBy(value="mLock")
    private void updateFileCacheSizeLimit() {
        boolean isAvailableSpaceLowerThanHighLimit = this.mStatFsHelper.testLowDiskSpace(StatFsHelper.StorageType.INTERNAL, this.mDefaultCacheSizeLimit - this.mCacheStats.getSize());
        this.mCacheSizeLimit = isAvailableSpaceLowerThanHighLimit ? this.mLowDiskSpaceCacheSizeLimit : this.mDefaultCacheSizeLimit;
    }

    @Override
    public long getSize() {
        return this.mCacheStats.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mStorage.clearAll();
                this.mResourceIndex.clear();
                this.mIndex.clear();
            }
            catch (IOException ioe) {
                this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.EVICTION, TAG, "clearAll: " + ioe.getMessage(), ioe);
            }
            DiskStorageCacheUtil.clearDiskEntries(this.mSharedPreferences);
            this.mCacheStats.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasKeySync(CacheKey key) {
        Object object = this.mLock;
        synchronized (object) {
            int hashKey = key.hashCode();
            if (this.mIndex.containsKey(hashKey)) {
                return true;
            }
            String resourceId = null;
            List<String> resourceIds = DiskStorageCache.getResourceIds(key);
            for (int i = 0; i < resourceIds.size(); ++i) {
                resourceId = resourceIds.get(i);
                if (!this.mResourceIndex.contains(resourceId)) continue;
                this.mIndex.put(hashKey, resourceId);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasKey(CacheKey key) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.hasKeySync(key)) {
                return true;
            }
            try {
                String resourceId = null;
                boolean retval = false;
                List<String> resourceIds = DiskStorageCache.getResourceIds(key);
                for (int i = 0; i < resourceIds.size() && !(retval = this.mStorage.contains(resourceId = resourceIds.get(i), key)); ++i) {
                }
                if (retval) {
                    this.addKeyToIndex(key.hashCode(), resourceId);
                }
                return retval;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToMinimum() {
        Object object = this.mLock;
        synchronized (object) {
            this.maybeUpdateFileCacheSize();
            long cacheSize = this.mCacheStats.getSize();
            if (this.mCacheSizeLimitMinimum <= 0L || cacheSize <= 0L || cacheSize < this.mCacheSizeLimitMinimum) {
                return;
            }
            double trimRatio = 1.0 - (double)this.mCacheSizeLimitMinimum / (double)cacheSize;
            if (trimRatio > 0.02) {
                this.trimBy(trimRatio);
            }
        }
    }

    public void trimToNothing() {
        this.clearAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimBy(double trimRatio) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mCacheStats.reset();
                this.maybeUpdateFileCacheSize();
                long cacheSize = this.mCacheStats.getSize();
                long newMaxBytesInFiles = cacheSize - (long)(trimRatio * (double)cacheSize);
                this.evictAboveSize(newMaxBytesInFiles, CacheEventListener.EvictionReason.CACHE_MANAGER_TRIMMED);
            }
            catch (IOException ioe) {
                this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.EVICTION, TAG, "trimBy: " + ioe.getMessage(), ioe);
            }
        }
    }

    @GuardedBy(value="mLock")
    private boolean maybeUpdateFileCacheSize() {
        boolean result = false;
        long now = this.mClock.now();
        if (!this.mCacheStats.isInitialized() || this.mCacheSizeLastUpdateTime == -1L || now - this.mCacheSizeLastUpdateTime > FILECACHE_SIZE_UPDATE_PERIOD_MS) {
            this.maybeUpdateFileCacheSizeAndIndex();
            this.mCacheSizeLastUpdateTime = now;
            result = true;
        }
        return result;
    }

    @GuardedBy(value="mLock")
    private void maybeUpdateFileCacheSizeAndIndex() {
        long size = 0L;
        int count = 0;
        boolean foundFutureTimestamp = false;
        int numFutureFiles = 0;
        int sizeFutureFiles = 0;
        long maxTimeDelta = -1L;
        long now = this.mClock.now();
        long timeThreshold = now + FUTURE_TIMESTAMP_THRESHOLD_MS;
        HashSet<String> tempResourceIndex = new HashSet<String>();
        try {
            Collection<DiskStorage.Entry> entries = this.mStorage.getEntries();
            for (DiskStorage.Entry entry : entries) {
                ++count;
                size += entry.getSize();
                if (entry.getTimestamp() > timeThreshold) {
                    foundFutureTimestamp = true;
                    ++numFutureFiles;
                    sizeFutureFiles = (int)((long)sizeFutureFiles + entry.getSize());
                    maxTimeDelta = Math.max(entry.getTimestamp() - now, maxTimeDelta);
                    continue;
                }
                tempResourceIndex.add(entry.getId());
            }
            if (foundFutureTimestamp) {
                this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.READ_INVALID_ENTRY, TAG, "Future timestamp found in " + numFutureFiles + " files , with a total size of " + sizeFutureFiles + " bytes, and a maximum time delta of " + maxTimeDelta + "ms", null);
            }
            if (this.mCacheStats.getCount() != (long)count || this.mCacheStats.getSize() != size) {
                this.mResourceIndex.clear();
                this.mResourceIndex.addAll(tempResourceIndex);
                this.mIndex = DiskStorageCacheUtil.readStoredIndex(this.mSharedPreferences, this.mResourceIndex);
                this.mCacheStats.set(size, count);
            }
        }
        catch (IOException ioe) {
            this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.GENERIC_IO, TAG, "calcFileCacheSize: " + ioe.getMessage(), ioe);
        }
    }

    private static List<String> getResourceIds(CacheKey key) {
        try {
            ArrayList<String> ids;
            if (key instanceof MultiCacheKey) {
                List<CacheKey> keys = ((MultiCacheKey)key).getCacheKeys();
                ids = new ArrayList(keys.size());
                for (int i = 0; i < keys.size(); ++i) {
                    ids.add(DiskStorageCache.secureHashKey(keys.get(i)));
                }
            } else {
                ids = new ArrayList<String>(1);
                ids.add(DiskStorageCache.secureHashKey(key));
            }
            return ids;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static String getFirstResourceId(CacheKey key) {
        try {
            if (key instanceof MultiCacheKey) {
                List<CacheKey> keys = ((MultiCacheKey)key).getCacheKeys();
                return DiskStorageCache.secureHashKey(keys.get(0));
            }
            return DiskStorageCache.secureHashKey(key);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String secureHashKey(CacheKey key) throws UnsupportedEncodingException {
        return SecureHashUtil.makeSHA1HashBase64((byte[])key.toString().getBytes("UTF-8"));
    }

    private static SharedPreferences initializeSharedPreferences(Context context, String directoryName) {
        Context applicationContext = context.getApplicationContext();
        return applicationContext.getSharedPreferences(SHARED_PREFS_FILENAME_PREFIX + directoryName, 0);
    }

    @GuardedBy(value="mLock")
    private void addKeyToIndex(Integer hashKey, String resourceId) {
        this.mIndex.put(hashKey, resourceId);
        this.mResourceIndex.add(resourceId);
        DiskStorageCacheUtil.addDiskCacheEntry(hashKey, resourceId, this.mSharedPreferences);
    }

    @GuardedBy(value="mLock")
    private void removeKeyFromIndex(Integer hashKey) {
        String resourceId = this.mIndex.remove(hashKey);
        if (resourceId != null) {
            this.mResourceIndex.remove(resourceId);
            DiskStorageCacheUtil.deleteDiskCacheEntry(hashKey, this.mSharedPreferences);
        }
    }

    @GuardedBy(value="mLock")
    private void removeValueFromIndex(String resourceId) {
        Integer hashKey = DiskStorageCache.removeKeyByValue(this.mIndex, resourceId);
        this.removeKeyFromIndex(hashKey);
    }

    private static Integer removeKeyByValue(Map<Integer, String> index, String value) {
        for (Map.Entry<Integer, String> entry : index.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return 0;
    }

    public static class Params {
        public final long mCacheSizeLimitMinimum;
        public final long mLowDiskSpaceCacheSizeLimit;
        public final long mDefaultCacheSizeLimit;

        public Params(long cacheSizeLimitMinimum, long lowDiskSpaceCacheSizeLimit, long defaultCacheSizeLimit) {
            this.mCacheSizeLimitMinimum = cacheSizeLimitMinimum;
            this.mLowDiskSpaceCacheSizeLimit = lowDiskSpaceCacheSizeLimit;
            this.mDefaultCacheSizeLimit = defaultCacheSizeLimit;
        }
    }

    @VisibleForTesting
    static class CacheStats {
        private boolean mInitialized = false;
        private long mSize = -1L;
        private long mCount = -1L;

        CacheStats() {
        }

        public synchronized boolean isInitialized() {
            return this.mInitialized;
        }

        public synchronized void reset() {
            this.mInitialized = false;
            this.mCount = -1L;
            this.mSize = -1L;
        }

        public synchronized void set(long size, long count) {
            this.mCount = count;
            this.mSize = size;
            this.mInitialized = true;
        }

        public synchronized void increment(long sizeIncrement, long countIncrement) {
            if (this.mInitialized) {
                this.mSize += sizeIncrement;
                this.mCount += countIncrement;
            }
        }

        public synchronized long getSize() {
            return this.mSize;
        }

        public synchronized long getCount() {
            return this.mCount;
        }
    }
}

