/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.cache.disk;

import com.facebook.cache.common.CacheEvent;
import com.facebook.cache.common.CacheEventListener;
import com.facebook.cache.common.CacheKey;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.infer.annotation.ReturnsOwnership;
import java.io.IOException;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class SettableCacheEvent
implements CacheEvent {
    private static final Object RECYCLER_LOCK = new Object();
    private static final int MAX_RECYCLED = 5;
    @Nullable
    private static SettableCacheEvent sFirstRecycledEvent;
    private static int sRecycledCount;
    @Nullable
    private CacheKey mCacheKey;
    @Nullable
    private String mResourceId;
    private long mItemSize;
    private long mCacheLimit;
    private long mCacheSize;
    @Nullable
    private IOException mException;
    @Nullable
    private CacheEventListener.EvictionReason mEvictionReason;
    @Nullable
    private SettableCacheEvent mNextRecycledEvent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReturnsOwnership
    public static SettableCacheEvent obtain() {
        Object object = RECYCLER_LOCK;
        synchronized (object) {
            if (sFirstRecycledEvent != null) {
                SettableCacheEvent eventToReuse = sFirstRecycledEvent;
                sFirstRecycledEvent = eventToReuse.mNextRecycledEvent;
                eventToReuse.mNextRecycledEvent = null;
                --sRecycledCount;
                return eventToReuse;
            }
        }
        return new SettableCacheEvent();
    }

    private SettableCacheEvent() {
    }

    @Override
    @Nullable
    public CacheKey getCacheKey() {
        return this.mCacheKey;
    }

    public SettableCacheEvent setCacheKey(CacheKey cacheKey) {
        this.mCacheKey = cacheKey;
        return this;
    }

    @Override
    @Nullable
    public String getResourceId() {
        return this.mResourceId;
    }

    public SettableCacheEvent setResourceId(String resourceId) {
        this.mResourceId = resourceId;
        return this;
    }

    @Override
    public long getItemSize() {
        return this.mItemSize;
    }

    public SettableCacheEvent setItemSize(long itemSize) {
        this.mItemSize = itemSize;
        return this;
    }

    @Override
    public long getCacheSize() {
        return this.mCacheSize;
    }

    public SettableCacheEvent setCacheSize(long cacheSize) {
        this.mCacheSize = cacheSize;
        return this;
    }

    @Override
    public long getCacheLimit() {
        return this.mCacheLimit;
    }

    public SettableCacheEvent setCacheLimit(long cacheLimit) {
        this.mCacheLimit = cacheLimit;
        return this;
    }

    @Override
    @Nullable
    public IOException getException() {
        return this.mException;
    }

    public SettableCacheEvent setException(IOException exception) {
        this.mException = exception;
        return this;
    }

    @Override
    @Nullable
    public CacheEventListener.EvictionReason getEvictionReason() {
        return this.mEvictionReason;
    }

    public SettableCacheEvent setEvictionReason(CacheEventListener.EvictionReason evictionReason) {
        this.mEvictionReason = evictionReason;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Object object = RECYCLER_LOCK;
        synchronized (object) {
            if (sRecycledCount < 5) {
                this.reset();
                ++sRecycledCount;
                if (sFirstRecycledEvent != null) {
                    this.mNextRecycledEvent = sFirstRecycledEvent;
                }
                sFirstRecycledEvent = this;
            }
        }
    }

    private void reset() {
        this.mCacheKey = null;
        this.mResourceId = null;
        this.mItemSize = 0L;
        this.mCacheLimit = 0L;
        this.mCacheSize = 0L;
        this.mException = null;
        this.mEvictionReason = null;
    }
}

