/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.AbstractSingleArrayBlock;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.util.function.BiConsumer;

public class SingleArrayBlockWriter
extends AbstractSingleArrayBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleArrayBlockWriter.class).instanceSize();
    private final BlockBuilder blockBuilder;
    private final long initialBlockBuilderSize;
    private int positionsWritten;

    public SingleArrayBlockWriter(BlockBuilder blockBuilder, int start) {
        super(start);
        this.blockBuilder = blockBuilder;
        this.initialBlockBuilderSize = blockBuilder.getSizeInBytes();
    }

    @Override
    protected Block getBlock() {
        return this.blockBuilder;
    }

    @Override
    public long getSizeInBytes() {
        return this.blockBuilder.getSizeInBytes() - this.initialBlockBuilderSize;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.blockBuilder.getRetainedSizeInBytes();
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.blockBuilder, this.blockBuilder.getRetainedSizeInBytes());
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public BlockBuilder writeByte(int value) {
        this.blockBuilder.writeByte(value);
        return this;
    }

    @Override
    public BlockBuilder writeShort(int value) {
        this.blockBuilder.writeShort(value);
        return this;
    }

    @Override
    public BlockBuilder writeInt(int value) {
        this.blockBuilder.writeInt(value);
        return this;
    }

    @Override
    public BlockBuilder writeLong(long value) {
        this.blockBuilder.writeLong(value);
        return this;
    }

    @Override
    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        this.blockBuilder.writeBytes(source, sourceIndex, length);
        return this;
    }

    @Override
    public BlockBuilder appendStructure(Block block) {
        this.blockBuilder.appendStructure(block);
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder appendStructureInternal(Block block, int position) {
        this.blockBuilder.appendStructureInternal(block, position);
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder beginBlockEntry() {
        return this.blockBuilder.beginBlockEntry();
    }

    @Override
    public BlockBuilder appendNull() {
        this.blockBuilder.appendNull();
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        this.blockBuilder.closeEntry();
        this.entryAdded();
        return this;
    }

    private void entryAdded() {
        ++this.positionsWritten;
    }

    @Override
    public BlockBuilder readPositionFrom(SliceInput input) {
        this.blockBuilder.readPositionFrom(input);
        this.entryAdded();
        return this;
    }

    @Override
    public int getPositionCount() {
        return this.positionsWritten;
    }

    @Override
    public Block build() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.format("SingleArrayBlockWriter{positionCount=%d}", this.getPositionCount());
    }
}

