/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec;

import com.facebook.swift.codec.DelegateCodec;
import com.facebook.swift.codec.InternalThriftCodec;
import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.internal.ThriftCodecFactory;
import com.facebook.swift.codec.internal.builtin.BooleanArrayThriftCodec;
import com.facebook.swift.codec.internal.builtin.BooleanThriftCodec;
import com.facebook.swift.codec.internal.builtin.ByteBufferThriftCodec;
import com.facebook.swift.codec.internal.builtin.ByteThriftCodec;
import com.facebook.swift.codec.internal.builtin.DoubleArrayThriftCodec;
import com.facebook.swift.codec.internal.builtin.DoubleThriftCodec;
import com.facebook.swift.codec.internal.builtin.IntArrayThriftCodec;
import com.facebook.swift.codec.internal.builtin.IntegerThriftCodec;
import com.facebook.swift.codec.internal.builtin.LongArrayThriftCodec;
import com.facebook.swift.codec.internal.builtin.LongThriftCodec;
import com.facebook.swift.codec.internal.builtin.ShortArrayThriftCodec;
import com.facebook.swift.codec.internal.builtin.ShortThriftCodec;
import com.facebook.swift.codec.internal.builtin.StringThriftCodec;
import com.facebook.swift.codec.internal.builtin.VoidThriftCodec;
import com.facebook.swift.codec.internal.compiler.CompilerThriftCodecFactory;
import com.facebook.swift.codec.metadata.ThriftCatalog;
import com.facebook.swift.codec.metadata.ThriftType;
import com.facebook.swift.codec.metadata.ThriftTypeReference;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@ThreadSafe
public class ThriftCodecManager {
    private final ThriftCatalog catalog;
    private final LoadingCache<ThriftType, ThriftCodec<?>> typeCodecs;
    private final ThreadLocal<Deque<ThriftType>> stack = new ThreadLocal<Deque<ThriftType>>(){

        @Override
        protected Deque<ThriftType> initialValue() {
            return new ArrayDeque<ThriftType>();
        }
    };
    private final ThreadLocal<Deque<ThriftType>> deferredTypesWorkList = new ThreadLocal<Deque<ThriftType>>(){

        @Override
        protected Deque<ThriftType> initialValue() {
            return new ArrayDeque<ThriftType>();
        }
    };

    public ThriftCodecManager(ThriftCodec<?> ... codecs) {
        this((ThriftCodecFactory)new CompilerThriftCodecFactory(ThriftCodecManager.class.getClassLoader()), (Set<ThriftCodec<?>>)ImmutableSet.copyOf((Object[])codecs));
    }

    public ThriftCodecManager(ClassLoader parent, ThriftCodec<?> ... codecs) {
        this((ThriftCodecFactory)new CompilerThriftCodecFactory(parent), (Set<ThriftCodec<?>>)ImmutableSet.copyOf((Object[])codecs));
    }

    public ThriftCodecManager(ThriftCodecFactory factory, ThriftCodec<?> ... codecs) {
        this(factory, new ThriftCatalog(), (Set<ThriftCodec<?>>)ImmutableSet.copyOf((Object[])codecs));
    }

    public ThriftCodecManager(ThriftCodecFactory factory, Set<ThriftCodec<?>> codecs) {
        this(factory, new ThriftCatalog(), codecs);
    }

    @Inject
    public ThriftCodecManager(final ThriftCodecFactory factory, final ThriftCatalog catalog, @InternalThriftCodec Set<ThriftCodec<?>> codecs) {
        Preconditions.checkNotNull((Object)factory, (Object)"factory is null");
        Preconditions.checkNotNull((Object)catalog, (Object)"catalog is null");
        this.catalog = catalog;
        this.typeCodecs = CacheBuilder.newBuilder().build(new CacheLoader<ThriftType, ThriftCodec<?>>(){

            /*
             * Exception decompiling
             */
            public ThriftCodec<?> load(ThriftType type) throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        this.addBuiltinCodec(new BooleanThriftCodec());
        this.addBuiltinCodec(new ByteThriftCodec());
        this.addBuiltinCodec(new ShortThriftCodec());
        this.addBuiltinCodec(new IntegerThriftCodec());
        this.addBuiltinCodec(new LongThriftCodec());
        this.addBuiltinCodec(new DoubleThriftCodec());
        this.addBuiltinCodec(new ByteBufferThriftCodec());
        this.addBuiltinCodec(new StringThriftCodec());
        this.addBuiltinCodec(new VoidThriftCodec());
        this.addBuiltinCodec(new BooleanArrayThriftCodec());
        this.addBuiltinCodec(new ShortArrayThriftCodec());
        this.addBuiltinCodec(new IntArrayThriftCodec());
        this.addBuiltinCodec(new LongArrayThriftCodec());
        this.addBuiltinCodec(new DoubleArrayThriftCodec());
        for (ThriftCodec<?> codec : codecs) {
            this.addCodec(codec);
        }
    }

    public ThriftCodec<?> getElementCodec(ThriftTypeReference thriftTypeReference) throws Exception {
        return this.getCodec(thriftTypeReference.get());
    }

    public ThriftCodec<?> getCodec(Type javaType) {
        ThriftType thriftType = this.catalog.getThriftType(javaType);
        Preconditions.checkArgument((thriftType != null ? 1 : 0) != 0, (String)"Unsupported java type %s", (Object[])new Object[]{javaType});
        return this.getCodec(thriftType);
    }

    public <T> ThriftCodec<T> getCodec(Class<T> javaType) {
        ThriftType thriftType = this.catalog.getThriftType(javaType);
        Preconditions.checkArgument((thriftType != null ? 1 : 0) != 0, (String)"Unsupported java type %s", (Object[])new Object[]{javaType.getName()});
        return this.getCodec(thriftType);
    }

    public <T> ThriftCodec<T> getCodec(TypeToken<T> type) {
        return this.getCodec(type.getType());
    }

    public ThriftCodec<?> getCodec(ThriftType type) {
        if (this.stack.get().contains(type)) {
            return new DelegateCodec(this, type.getJavaType());
        }
        try {
            ThriftCodec thriftCodec = (ThriftCodec)this.typeCodecs.get((Object)type);
            while (!this.deferredTypesWorkList.get().isEmpty()) {
                this.getCodec(this.deferredTypesWorkList.get().pop());
            }
            return thriftCodec;
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public ThriftCodec<?> getCachedCodecIfPresent(Type javaType) {
        ThriftType thriftType = this.catalog.getThriftType(javaType);
        Preconditions.checkArgument((thriftType != null ? 1 : 0) != 0, (String)"Unsupported java type %s", (Object[])new Object[]{javaType});
        return this.getCachedCodecIfPresent(thriftType);
    }

    public <T> ThriftCodec<T> getCachedCodecIfPresent(Class<T> javaType) {
        ThriftType thriftType = this.catalog.getThriftType(javaType);
        Preconditions.checkArgument((thriftType != null ? 1 : 0) != 0, (String)"Unsupported java type %s", (Object[])new Object[]{javaType.getName()});
        return this.getCachedCodecIfPresent(thriftType);
    }

    public <T> ThriftCodec<T> getCachedCodecIfPresent(TypeToken<T> type) {
        return this.getCachedCodecIfPresent(type.getType());
    }

    public ThriftCodec<?> getCachedCodecIfPresent(ThriftType type) {
        ThriftCodec thriftCodec = (ThriftCodec)this.typeCodecs.getIfPresent((Object)type);
        return thriftCodec;
    }

    public void addCodec(ThriftCodec<?> codec) {
        this.catalog.addThriftType(codec.getType());
        this.typeCodecs.put((Object)codec.getType(), codec);
    }

    private void addBuiltinCodec(ThriftCodec<?> codec) {
        this.typeCodecs.put((Object)codec.getType(), codec);
    }

    public ThriftCatalog getCatalog() {
        return this.catalog;
    }

    public <T> T read(Class<T> type, TProtocol protocol) throws Exception {
        return this.getCodec(type).read(protocol);
    }

    public Object read(ThriftType type, TProtocol protocol) throws Exception {
        ThriftCodec<?> codec = this.getCodec(type);
        return codec.read(protocol);
    }

    public <T> T read(byte[] serializedStruct, Class<T> clazz, TProtocolFactory protocolFactory) {
        Preconditions.checkNotNull((Object)serializedStruct, (Object)"ttype is null");
        Preconditions.checkNotNull(clazz, (Object)"clazz is null");
        try {
            ByteArrayInputStream istream = new ByteArrayInputStream(serializedStruct);
            TIOStreamTransport resultIOStream = new TIOStreamTransport((InputStream)istream);
            TProtocol resultProtocolBuffer = protocolFactory.getProtocol((TTransport)resultIOStream);
            return this.read(clazz, resultProtocolBuffer);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public <T> void write(Class<T> type, T value, TProtocol protocol) throws Exception {
        this.getCodec(type).write(value, protocol);
    }

    public <T> void write(T ttype, ByteArrayOutputStream oStream, TProtocolFactory protocolFactory) {
        Preconditions.checkNotNull(ttype, (Object)"ttype is null");
        Preconditions.checkNotNull((Object)protocolFactory, (Object)"protocolFactory is null");
        try {
            TIOStreamTransport resultIOStream = new TIOStreamTransport((OutputStream)oStream);
            TProtocol resultProtocolBuffer = protocolFactory.getProtocol((TTransport)resultIOStream);
            this.write(ttype.getClass(), ttype, resultProtocolBuffer);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void write(ThriftType type, Object value, TProtocol protocol) throws Exception {
        ThriftCodec<?> codec = this.getCodec(type);
        codec.write(value, protocol);
    }

    static /* synthetic */ ThreadLocal access$000(ThriftCodecManager x0) {
        return x0.stack;
    }
}

