/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal.builtin;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.internal.TProtocolReader;
import com.facebook.swift.codec.internal.TProtocolWriter;
import com.facebook.swift.codec.metadata.ThriftType;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.thrift.protocol.TProtocol;

@Immutable
public class ListThriftCodec<T>
implements ThriftCodec<List<T>> {
    private final ThriftCodec<T> elementCodec;
    private final ThriftType type;

    public ListThriftCodec(ThriftType type, ThriftCodec<T> elementCodec) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull(elementCodec, (Object)"elementCodec is null");
        this.type = type;
        this.elementCodec = elementCodec;
    }

    @Override
    public ThriftType getType() {
        return this.type;
    }

    @Override
    public List<T> read(TProtocol protocol) throws Exception {
        Preconditions.checkNotNull((Object)protocol, (Object)"protocol is null");
        return new TProtocolReader(protocol).readList(this.elementCodec);
    }

    @Override
    public void write(List<T> value, TProtocol protocol) throws Exception {
        Preconditions.checkNotNull(value, (Object)"value is null");
        Preconditions.checkNotNull((Object)protocol, (Object)"protocol is null");
        new TProtocolWriter(protocol).writeList(this.elementCodec, value);
    }
}

