/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ThriftDocumentation;
import com.facebook.swift.codec.ThriftOrder;
import com.facebook.swift.codec.ThriftProtocolType;
import com.facebook.swift.codec.ThriftStruct;
import com.facebook.swift.codec.ThriftUnion;
import com.facebook.swift.codec.internal.coercion.DefaultJavaCoercions;
import com.facebook.swift.codec.internal.coercion.FromThrift;
import com.facebook.swift.codec.internal.coercion.ToThrift;
import com.facebook.swift.codec.metadata.DefaultThriftTypeReference;
import com.facebook.swift.codec.metadata.FieldMetadata;
import com.facebook.swift.codec.metadata.MetadataErrors;
import com.facebook.swift.codec.metadata.RecursiveThriftTypeReference;
import com.facebook.swift.codec.metadata.ReflectionHelper;
import com.facebook.swift.codec.metadata.ThriftEnumMetadata;
import com.facebook.swift.codec.metadata.ThriftEnumMetadataBuilder;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.facebook.swift.codec.metadata.ThriftStructMetadataBuilder;
import com.facebook.swift.codec.metadata.ThriftType;
import com.facebook.swift.codec.metadata.ThriftTypeReference;
import com.facebook.swift.codec.metadata.ThriftUnionMetadataBuilder;
import com.facebook.swift.codec.metadata.TypeCoercion;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ThriftCatalog {
    private final MetadataErrors.Monitor monitor;
    private final ConcurrentMap<Type, ThriftStructMetadata> structs = new ConcurrentHashMap<Type, ThriftStructMetadata>();
    private final ConcurrentMap<Class<?>, ThriftEnumMetadata<?>> enums = new ConcurrentHashMap();
    private final ConcurrentMap<Type, TypeCoercion> coercions = new ConcurrentHashMap<Type, TypeCoercion>();
    private final ConcurrentMap<Class<?>, ThriftType> manualTypes = new ConcurrentHashMap();
    private final ConcurrentMap<Type, ThriftType> typeCache = new ConcurrentHashMap<Type, ThriftType>();
    private final ThreadLocal<Deque<Type>> stack = new ThreadLocal<Deque<Type>>(){

        @Override
        protected Deque<Type> initialValue() {
            return new ArrayDeque<Type>();
        }
    };
    private final ThreadLocal<Deque<Type>> deferredTypesWorkList = new ThreadLocal<Deque<Type>>(){

        @Override
        protected Deque<Type> initialValue() {
            return new ArrayDeque<Type>();
        }
    };

    public ThriftCatalog() {
        this(MetadataErrors.NULL_MONITOR);
    }

    @VisibleForTesting
    public ThriftCatalog(MetadataErrors.Monitor monitor) {
        this.monitor = monitor;
        this.addDefaultCoercions(DefaultJavaCoercions.class);
    }

    @VisibleForTesting
    MetadataErrors.Monitor getMonitor() {
        return this.monitor;
    }

    public void addThriftType(ThriftType thriftType) {
        this.manualTypes.put(TypeToken.of((Type)thriftType.getJavaType()).getRawType(), thriftType);
    }

    public void addDefaultCoercions(Class<?> coercionsClass) {
        Preconditions.checkNotNull(coercionsClass, (Object)"coercionsClass is null");
        HashMap<ThriftType, Method> toThriftCoercions = new HashMap<ThriftType, Method>();
        HashMap<ThriftType, Method> fromThriftCoercions = new HashMap<ThriftType, Method>();
        for (Method method : coercionsClass.getDeclaredMethods()) {
            Method oldValue;
            ThriftType coercedType;
            ThriftType thriftType;
            if (method.isAnnotationPresent(ToThrift.class)) {
                this.verifyCoercionMethod(method);
                thriftType = this.getThriftType(method.getGenericReturnType());
                coercedType = thriftType.coerceTo(method.getGenericParameterTypes()[0]);
                oldValue = toThriftCoercions.put(coercedType, method);
                Preconditions.checkArgument((oldValue == null ? 1 : 0) != 0, (String)"Coercion class two @ToThrift methods (%s and %s) for type %s", (Object[])new Object[]{coercionsClass.getName(), method, oldValue, coercedType});
                continue;
            }
            if (!method.isAnnotationPresent(FromThrift.class)) continue;
            this.verifyCoercionMethod(method);
            thriftType = this.getThriftType(method.getGenericParameterTypes()[0]);
            coercedType = thriftType.coerceTo(method.getGenericReturnType());
            oldValue = fromThriftCoercions.put(coercedType, method);
            Preconditions.checkArgument((oldValue == null ? 1 : 0) != 0, (String)"Coercion class two @FromThrift methods (%s and %s) for type %s", (Object[])new Object[]{coercionsClass.getName(), method, oldValue, coercedType});
        }
        Sets.SetView difference = Sets.symmetricDifference(toThriftCoercions.keySet(), fromThriftCoercions.keySet());
        Preconditions.checkArgument((boolean)difference.isEmpty(), (String)"Coercion class %s does not have matched @ToThrift and @FromThrift methods for types %s", (Object[])new Object[]{coercionsClass.getName(), difference});
        HashMap<Type, TypeCoercion> coercions = new HashMap<Type, TypeCoercion>();
        for (Map.Entry entry : toThriftCoercions.entrySet()) {
            ThriftType type = (ThriftType)entry.getKey();
            Method toThriftMethod = (Method)entry.getValue();
            Method fromThriftMethod = (Method)fromThriftCoercions.get(type);
            Preconditions.checkState((fromThriftMethod != null ? 1 : 0) != 0, (String)"Coercion class %s does not have matched @ToThrift and @FromThrift methods for type %s", (Object[])new Object[]{coercionsClass.getName(), type});
            TypeCoercion coercion = new TypeCoercion(type, toThriftMethod, fromThriftMethod);
            coercions.put(type.getJavaType(), coercion);
        }
        this.coercions.putAll(coercions);
    }

    private void verifyCoercionMethod(Method method) {
        Preconditions.checkArgument((boolean)Modifier.isStatic(method.getModifiers()), (String)"Method %s is not static", (Object[])new Object[]{method.toGenericString()});
        Preconditions.checkArgument((method.getParameterTypes().length == 1 ? 1 : 0) != 0, (String)"Method %s must have exactly one parameter", (Object[])new Object[]{method.toGenericString()});
        Preconditions.checkArgument((method.getReturnType() != Void.TYPE ? 1 : 0) != 0, (String)"Method %s must have a return value", (Object[])new Object[]{method.toGenericString()});
    }

    public TypeCoercion getDefaultCoercion(Type type) {
        return (TypeCoercion)this.coercions.get(type);
    }

    public ThriftType getThriftType(Type javaType) throws IllegalArgumentException {
        ThriftType thriftType = this.getThriftTypeFromCache(javaType);
        if (thriftType == null) {
            thriftType = this.buildThriftType(javaType);
        }
        return thriftType;
    }

    public ThriftType getThriftTypeFromCache(Type javaType) {
        return (ThriftType)this.typeCache.get(javaType);
    }

    private ThriftType buildThriftType(Type javaType) {
        ThriftType thriftType = this.buildThriftTypeInternal(javaType);
        this.typeCache.putIfAbsent(javaType, thriftType);
        if (this.stack.get().isEmpty()) {
            Deque<Type> unresolvedJavaTypes = this.deferredTypesWorkList.get();
            while (!unresolvedJavaTypes.isEmpty()) {
                Type unresolvedJavaType = unresolvedJavaTypes.pop();
                if (this.typeCache.containsKey(unresolvedJavaType)) continue;
                ThriftType resolvedThriftType = this.buildThriftTypeInternal(unresolvedJavaType);
                this.typeCache.putIfAbsent(unresolvedJavaType, resolvedThriftType);
            }
        }
        return thriftType;
    }

    private ThriftType buildThriftTypeInternal(Type javaType) throws IllegalArgumentException {
        Class rawType = TypeToken.of((Type)javaType).getRawType();
        ThriftType manualType = (ThriftType)this.manualTypes.get(rawType);
        if (manualType != null) {
            return manualType;
        }
        if (Boolean.TYPE == rawType) {
            return ThriftType.BOOL;
        }
        if (Byte.TYPE == rawType) {
            return ThriftType.BYTE;
        }
        if (Short.TYPE == rawType) {
            return ThriftType.I16;
        }
        if (Integer.TYPE == rawType) {
            return ThriftType.I32;
        }
        if (Long.TYPE == rawType) {
            return ThriftType.I64;
        }
        if (Double.TYPE == rawType) {
            return ThriftType.DOUBLE;
        }
        if (String.class == rawType) {
            return ThriftType.STRING;
        }
        if (ByteBuffer.class.isAssignableFrom(rawType)) {
            return ThriftType.BINARY;
        }
        if (Enum.class.isAssignableFrom(rawType)) {
            ThriftEnumMetadata<?> thriftEnumMetadata = this.getThriftEnumMetadata(rawType);
            return ThriftType.enumType(thriftEnumMetadata);
        }
        if (rawType.isArray()) {
            Class<?> elementType = rawType.getComponentType();
            if (elementType == Byte.TYPE) {
                return ((TypeCoercion)this.coercions.get(javaType)).getThriftType();
            }
            return ThriftType.array(this.getCollectionElementThriftTypeReference(elementType));
        }
        if (Map.class.isAssignableFrom(rawType)) {
            Type mapKeyType = ReflectionHelper.getMapKeyType(javaType);
            Type mapValueType = ReflectionHelper.getMapValueType(javaType);
            return ThriftType.map(this.getMapKeyThriftTypeReference(mapKeyType), this.getMapValueThriftTypeReference(mapValueType));
        }
        if (Set.class.isAssignableFrom(rawType)) {
            Type elementType = ReflectionHelper.getIterableType(javaType);
            return ThriftType.set(this.getCollectionElementThriftTypeReference(elementType));
        }
        if (Iterable.class.isAssignableFrom(rawType)) {
            Type elementType = ReflectionHelper.getIterableType(javaType);
            return ThriftType.list(this.getCollectionElementThriftTypeReference(elementType));
        }
        if (Void.TYPE.isAssignableFrom(rawType) || Void.class.isAssignableFrom(rawType)) {
            return ThriftType.VOID;
        }
        if (ThriftCatalog.isStructType(rawType)) {
            ThriftStructMetadata structMetadata = this.getThriftStructMetadata(javaType);
            return ThriftType.struct(structMetadata);
        }
        if (ListenableFuture.class.isAssignableFrom(rawType)) {
            Type returnType = ReflectionHelper.getFutureReturnType(javaType);
            return this.getThriftType(returnType);
        }
        TypeCoercion coercion = (TypeCoercion)this.coercions.get(javaType);
        if (coercion != null) {
            return coercion.getThriftType();
        }
        throw new IllegalArgumentException("Type can not be coerced to a Thrift type: " + javaType);
    }

    public ThriftTypeReference getFieldThriftTypeReference(FieldMetadata fieldMetadata) {
        Boolean isRecursive = fieldMetadata.isRecursiveReference();
        if (isRecursive == null) {
            throw new IllegalStateException("Field normalization should have set a non-null value for isRecursiveReference");
        }
        return this.getThriftTypeReference(fieldMetadata.getJavaType(), isRecursive != false ? Recursiveness.FORCED : Recursiveness.NOT_ALLOWED);
    }

    public ThriftTypeReference getCollectionElementThriftTypeReference(Type javaType) {
        if (ThriftCatalog.isStructType(javaType)) {
            return this.getThriftTypeReference(javaType, Recursiveness.FORCED);
        }
        return this.getThriftTypeReference(javaType, Recursiveness.NOT_ALLOWED);
    }

    public ThriftTypeReference getMapKeyThriftTypeReference(Type javaType) {
        if (ThriftCatalog.isStructType(javaType)) {
            return this.getThriftTypeReference(javaType, Recursiveness.FORCED);
        }
        return this.getThriftTypeReference(javaType, Recursiveness.NOT_ALLOWED);
    }

    public ThriftTypeReference getMapValueThriftTypeReference(Type javaType) {
        if (ThriftCatalog.isStructType(javaType)) {
            return this.getThriftTypeReference(javaType, Recursiveness.FORCED);
        }
        return this.getThriftTypeReference(javaType, Recursiveness.NOT_ALLOWED);
    }

    private ThriftTypeReference getThriftTypeReference(Type javaType, Recursiveness recursiveness) {
        ThriftType thriftType = this.getThriftTypeFromCache(javaType);
        if (thriftType == null) {
            if (recursiveness == Recursiveness.FORCED || recursiveness == Recursiveness.ALLOWED && this.stack.get().contains(javaType)) {
                this.deferredTypesWorkList.get().add(javaType);
                return new RecursiveThriftTypeReference(this, javaType);
            }
            thriftType = this.buildThriftType(javaType);
            this.typeCache.putIfAbsent(javaType, thriftType);
        }
        return new DefaultThriftTypeReference(thriftType);
    }

    public boolean isSupportedStructFieldType(Type javaType) {
        return this.getThriftProtocolType(javaType) != ThriftProtocolType.UNKNOWN;
    }

    public ThriftProtocolType getThriftProtocolType(Type javaType) {
        Type elementType;
        Class rawType = TypeToken.of((Type)javaType).getRawType();
        if (Boolean.TYPE == rawType) {
            return ThriftProtocolType.BOOL;
        }
        if (Byte.TYPE == rawType) {
            return ThriftProtocolType.BYTE;
        }
        if (Short.TYPE == rawType) {
            return ThriftProtocolType.I16;
        }
        if (Integer.TYPE == rawType) {
            return ThriftProtocolType.I32;
        }
        if (Long.TYPE == rawType) {
            return ThriftProtocolType.I64;
        }
        if (Double.TYPE == rawType) {
            return ThriftProtocolType.DOUBLE;
        }
        if (String.class == rawType) {
            return ThriftProtocolType.STRING;
        }
        if (ByteBuffer.class.isAssignableFrom(rawType)) {
            return ThriftProtocolType.BINARY;
        }
        if (Enum.class.isAssignableFrom(rawType)) {
            return ThriftProtocolType.ENUM;
        }
        if (rawType.isArray() && this.isSupportedArrayComponentType((Class<?>)(elementType = rawType.getComponentType()))) {
            return ThriftProtocolType.LIST;
        }
        if (Map.class.isAssignableFrom(rawType)) {
            Type mapKeyType = ReflectionHelper.getMapKeyType(javaType);
            Type mapValueType = ReflectionHelper.getMapValueType(javaType);
            if (this.isSupportedStructFieldType(mapKeyType) && this.isSupportedStructFieldType(mapValueType)) {
                return ThriftProtocolType.MAP;
            }
        }
        if (Set.class.isAssignableFrom(rawType) && this.isSupportedStructFieldType(elementType = ReflectionHelper.getIterableType(javaType))) {
            return ThriftProtocolType.SET;
        }
        if (Iterable.class.isAssignableFrom(rawType) && this.isSupportedStructFieldType(elementType = ReflectionHelper.getIterableType(javaType))) {
            return ThriftProtocolType.LIST;
        }
        if (ThriftCatalog.isStructType(rawType)) {
            return ThriftProtocolType.STRUCT;
        }
        TypeCoercion coercion = (TypeCoercion)this.coercions.get(javaType);
        if (coercion != null) {
            return coercion.getThriftType().getProtocolType();
        }
        return ThriftProtocolType.UNKNOWN;
    }

    public static boolean isStructType(Type javaType) {
        Class rawType = TypeToken.of((Type)javaType).getRawType();
        if (rawType.isAnnotationPresent(ThriftStruct.class)) {
            return true;
        }
        return rawType.isAnnotationPresent(ThriftUnion.class);
    }

    public boolean isSupportedArrayComponentType(Class<?> componentType) {
        return Boolean.TYPE == componentType || Byte.TYPE == componentType || Short.TYPE == componentType || Integer.TYPE == componentType || Long.TYPE == componentType || Double.TYPE == componentType;
    }

    public <T extends Enum<T>> ThriftEnumMetadata<?> getThriftEnumMetadata(Class<?> enumClass) {
        ThriftEnumMetadata<?> current;
        ThriftEnumMetadata<?> enumMetadata = (ThriftEnumMetadata<?>)this.enums.get(enumClass);
        if (enumMetadata == null && (current = this.enums.putIfAbsent(enumClass, enumMetadata = new ThriftEnumMetadataBuilder(enumClass).build())) != null) {
            enumMetadata = current;
        }
        return enumMetadata;
    }

    public <T> ThriftStructMetadata getThriftStructMetadata(Type structType) {
        ThriftStructMetadata structMetadata = (ThriftStructMetadata)this.structs.get(structType);
        Class structClass = TypeToken.of((Type)structType).getRawType();
        if (structMetadata == null) {
            if (structClass.isAnnotationPresent(ThriftStruct.class)) {
                structMetadata = this.extractThriftStructMetadata(structType);
            } else if (structClass.isAnnotationPresent(ThriftUnion.class)) {
                structMetadata = this.extractThriftUnionMetadata(structType);
            } else {
                throw new IllegalStateException("getThriftStructMetadata called on a class that has no @ThriftStruct or @ThriftUnion annotation");
            }
            ThriftStructMetadata current = this.structs.putIfAbsent(structType, structMetadata);
            if (current != null) {
                structMetadata = current;
            }
        }
        return structMetadata;
    }

    private static Class<?> getSwiftMetaClassOf(Class<?> cls) throws ClassNotFoundException {
        ClassLoader loader = cls.getClassLoader();
        if (loader == null) {
            throw new ClassNotFoundException("null class loader");
        }
        return loader.loadClass(cls.getName() + "$swift_meta");
    }

    public static ImmutableList<String> getThriftDocumentation(Class<?> objectClass) {
        ThriftDocumentation documentation = objectClass.getAnnotation(ThriftDocumentation.class);
        if (documentation == null) {
            try {
                Class<?> swiftDocsClass = ThriftCatalog.getSwiftMetaClassOf(objectClass);
                documentation = swiftDocsClass.getAnnotation(ThriftDocumentation.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return documentation == null ? ImmutableList.of() : ImmutableList.copyOf((Object[])documentation.value());
    }

    public static ImmutableList<String> getThriftDocumentation(Method method) {
        ThriftDocumentation documentation = method.getAnnotation(ThriftDocumentation.class);
        if (documentation == null) {
            try {
                Class<?> swiftDocsClass = ThriftCatalog.getSwiftMetaClassOf(method.getDeclaringClass());
                documentation = swiftDocsClass.getDeclaredMethod(method.getName(), new Class[0]).getAnnotation(ThriftDocumentation.class);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return documentation == null ? ImmutableList.of() : ImmutableList.copyOf((Object[])documentation.value());
    }

    public static ImmutableList<String> getThriftDocumentation(Field field) {
        ThriftDocumentation documentation = field.getAnnotation(ThriftDocumentation.class);
        if (documentation == null) {
            try {
                Class<?> swiftDocsClass = ThriftCatalog.getSwiftMetaClassOf(field.getDeclaringClass());
                documentation = swiftDocsClass.getDeclaredField(field.getName()).getAnnotation(ThriftDocumentation.class);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return documentation == null ? ImmutableList.of() : ImmutableList.copyOf((Object[])documentation.value());
    }

    public static <T extends Enum<T>> ImmutableList<String> getThriftDocumentation(Enum<T> enumConstant) {
        try {
            Field f = enumConstant.getDeclaringClass().getField(enumConstant.name());
            return ThriftCatalog.getThriftDocumentation(f);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return ImmutableList.of();
        }
    }

    public static Integer getMethodOrder(Method method) {
        ThriftOrder order = method.getAnnotation(ThriftOrder.class);
        if (order == null) {
            try {
                Class<?> swiftDocsClass = ThriftCatalog.getSwiftMetaClassOf(method.getDeclaringClass());
                order = swiftDocsClass.getDeclaredMethod(method.getName(), new Class[0]).getAnnotation(ThriftOrder.class);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return order == null ? null : Integer.valueOf(order.value());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThriftStructMetadata extractThriftStructMetadata(Type structType) {
        Type top;
        ThriftStructMetadata thriftStructMetadata;
        Preconditions.checkNotNull((Object)structType, (Object)"structType is null");
        Deque<Type> stack = this.stack.get();
        if (stack.contains(structType)) {
            String path = Joiner.on((String)"->").join(Iterables.transform((Iterable)Iterables.concat(stack, (Iterable)ImmutableList.of((Object)structType)), (Function)new Function<Type, Object>(){

                public Object apply(Type input) {
                    return TypeToken.of((Type)input).getRawType().getName();
                }
            }));
            throw new IllegalArgumentException("Circular references must be qualified with 'isRecursive' on a @ThriftField annotation in the cycle: " + path);
        }
        stack.push(structType);
        try {
            ThriftStructMetadata structMetadata;
            ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(this, structType);
            thriftStructMetadata = structMetadata = builder.build();
            top = stack.pop();
        }
        catch (Throwable throwable) {
            Type top2 = stack.pop();
            Preconditions.checkState((boolean)structType.equals(top2), (String)"ThriftCatalog circularity detection stack is corrupt: expected %s, but got %s", (Object[])new Object[]{structType, top2});
            throw throwable;
        }
        Preconditions.checkState((boolean)structType.equals(top), (String)"ThriftCatalog circularity detection stack is corrupt: expected %s, but got %s", (Object[])new Object[]{structType, top});
        return thriftStructMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThriftStructMetadata extractThriftUnionMetadata(Type unionType) {
        Type top;
        ThriftStructMetadata thriftStructMetadata;
        Preconditions.checkNotNull((Object)unionType, (Object)"unionType is null");
        Deque<Type> stack = this.stack.get();
        if (stack.contains(unionType)) {
            String path = Joiner.on((String)"->").join(Iterables.transform((Iterable)Iterables.concat(stack, (Iterable)ImmutableList.of((Object)unionType)), (Function)new Function<Type, Object>(){

                public Object apply(Type input) {
                    return TypeToken.of((Type)input).getRawType().getName();
                }
            }));
            throw new IllegalArgumentException("Circular references must be qualified with 'isRecursive' on a @ThriftField annotation in the cycle: " + path);
        }
        stack.push(unionType);
        try {
            ThriftStructMetadata unionMetadata;
            ThriftUnionMetadataBuilder builder = new ThriftUnionMetadataBuilder(this, unionType);
            thriftStructMetadata = unionMetadata = builder.build();
            top = stack.pop();
        }
        catch (Throwable throwable) {
            Type top2 = stack.pop();
            Preconditions.checkState((boolean)unionType.equals(top2), (String)"ThriftCatalog circularity detection stack is corrupt: expected %s, but got %s", (Object[])new Object[]{unionType, top2});
            throw throwable;
        }
        Preconditions.checkState((boolean)unionType.equals(top), (String)"ThriftCatalog circularity detection stack is corrupt: expected %s, but got %s", (Object[])new Object[]{unionType, top});
        return thriftStructMetadata;
    }

    static enum Recursiveness {
        NOT_ALLOWED,
        ALLOWED,
        FORCED;

    }
}

