/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.metadata.FieldKind;
import com.facebook.swift.codec.metadata.ThriftConstructorInjection;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftMethodInjection;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftStructMetadata {
    private final String structName;
    private final Map<String, String> idlAnnotations;
    private final MetadataType metadataType;
    private final Optional<ThriftMethodInjection> builderMethod;
    private final ImmutableList<String> documentation;
    private final SortedMap<Short, ThriftFieldMetadata> fields;
    private final Optional<ThriftConstructorInjection> constructorInjection;
    private final List<ThriftMethodInjection> methodInjections;
    private final Type structType;
    private final Type builderType;

    public ThriftStructMetadata(String structName, Map<String, String> idlAnnotations, Type structType, Type builderType, MetadataType metadataType, Optional<ThriftMethodInjection> builderMethod, List<String> documentation, List<ThriftFieldMetadata> fields, Optional<ThriftConstructorInjection> constructorInjection, List<ThriftMethodInjection> methodInjections) {
        this.builderType = builderType;
        this.builderMethod = (Optional)Preconditions.checkNotNull(builderMethod, (Object)"builderMethod is null");
        this.structName = (String)Preconditions.checkNotNull((Object)structName, (Object)"structName is null");
        this.idlAnnotations = (Map)Preconditions.checkNotNull(idlAnnotations, (Object)"idlAnnotations is null");
        this.metadataType = (MetadataType)((Object)Preconditions.checkNotNull((Object)((Object)metadataType), (Object)"metadataType is null"));
        this.structType = (Type)Preconditions.checkNotNull((Object)structType, (Object)"structType is null");
        this.constructorInjection = (Optional)Preconditions.checkNotNull(constructorInjection, (Object)"constructorInjection is null");
        this.documentation = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(documentation, (Object)"documentation is null")));
        this.fields = ImmutableSortedMap.copyOf((Map)Maps.uniqueIndex((Iterable)((Iterable)Preconditions.checkNotNull(fields, (Object)"fields is null")), (Function)new Function<ThriftFieldMetadata, Short>(){

            public Short apply(ThriftFieldMetadata input) {
                return input.getId();
            }
        }));
        this.methodInjections = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(methodInjections, (Object)"methodInjections is null")));
    }

    public String getStructName() {
        return this.structName;
    }

    public Type getStructType() {
        return this.structType;
    }

    public Class<?> getStructClass() {
        return TypeToken.of((Type)this.structType).getRawType();
    }

    public Type getBuilderType() {
        return this.builderType;
    }

    public Class<?> getBuilderClass() {
        return this.builderType == null ? null : TypeToken.of((Type)this.builderType).getRawType();
    }

    public MetadataType getMetadataType() {
        return this.metadataType;
    }

    public Optional<ThriftMethodInjection> getBuilderMethod() {
        return this.builderMethod;
    }

    public Map<String, String> getIdlAnnotations() {
        return this.idlAnnotations;
    }

    public ThriftFieldMetadata getField(int id) {
        return (ThriftFieldMetadata)this.fields.get((short)id);
    }

    public ImmutableList<String> getDocumentation() {
        return this.documentation;
    }

    public Collection<ThriftFieldMetadata> getFields(FieldKind type) {
        return Collections2.filter(this.getFields(), ThriftFieldMetadata.isTypePredicate(type));
    }

    public Collection<ThriftFieldMetadata> getFields() {
        return this.fields.values();
    }

    public Optional<ThriftConstructorInjection> getConstructorInjection() {
        return this.constructorInjection;
    }

    public List<ThriftMethodInjection> getMethodInjections() {
        return this.methodInjections;
    }

    public boolean isException() {
        return Exception.class.isAssignableFrom(this.getStructClass());
    }

    public boolean isUnion() {
        return !this.isException() && this.getMetadataType() == MetadataType.UNION;
    }

    public boolean isStruct() {
        return !this.isException() && this.getMetadataType() == MetadataType.STRUCT;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ThriftStructMetadata");
        sb.append("{structName='").append(this.structName).append('\'');
        sb.append(", structType=").append(this.structType);
        sb.append(", builderType=").append(this.builderType);
        sb.append(", builderMethod=").append(this.builderMethod);
        sb.append(", fields=").append(this.fields);
        sb.append(", constructorInjection=").append(this.constructorInjection);
        sb.append(", methodInjections=").append(this.methodInjections);
        sb.append('}');
        return sb.toString();
    }

    public static enum MetadataType {
        STRUCT,
        UNION;

    }
}

