/*
 * Decompiled with CFR 0.152.
 */
package com.libaml.android.view.chip;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.libaml.android.view.chip.ChipEditorActionListener;
import com.libaml.android.view.chip.ChipOnFocusChangeListener;
import com.libaml.android.view.chip.ChipTextWatcher;
import com.libaml.android.view.chip.R;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=14)
public class ChipLayout
extends ViewGroup
implements View.OnClickListener {
    public static int MAX_CHARACTER_COUNT = 20;
    private int mGravity = (ChipLayout.isIcs() ? 0x800003 : 3) | 0x30;
    private final List<List<View>> mLines = new ArrayList<List<View>>();
    private final List<Integer> mLineHeights = new ArrayList<Integer>();
    private final List<Integer> mLineMargins = new ArrayList<Integer>();
    String autoCompleteTextViewTag = "chip_autoCompleteTextView";
    String imageButtonTag = "chip_imageButton";
    private final float textSize;
    private final float chipTextPadding;
    private final float chipPadding;
    private final float chipPaddingLeft;
    private final float chipPaddingRight;
    private final float chipPaddingTop;
    private final float chipPaddingBottom;
    private final float chipTextPaddingLeft;
    private final float chipTextPaddingRight;
    private final float chipTextPaddingTop;
    private final float chipTextPaddingBottom;
    private final ChipLayout chipLayout;
    private final Context context;
    private final boolean showDeleteButton;
    private final int labelPosition;
    private final int threshold;
    private int textColor;
    private int chipColor;
    private int hintColor;
    private String hintText;
    private final Drawable deleteIcon;
    private final Drawable chipLayoutDrawable;
    private Drawable chipDrawable;
    private Bitmap deleteIcon_ = null;
    private final List<TextWatcher> listTextWatcher = new ArrayList<TextWatcher>();
    private ArrayAdapter adapter;
    private AdapterView.OnItemClickListener onItemClickListener;
    private View.OnClickListener onClickListener;
    private View.OnFocusChangeListener onFocusChangeListener;
    private ChipItemChangeListener chipItemChangeListener;
    private int dropDownWidth = 300;
    private TextWatcher focusedTextWatcher;

    public ChipLayout(Context context) {
        this(context, null);
    }

    public ChipLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChipLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a_ = context.getTheme().obtainStyledAttributes(attrs, R.styleable.chip_layout, defStyle, 0);
        this.textColor = a_.getColor(R.styleable.chip_layout_textColor_, Color.parseColor((String)"#000000"));
        this.hintColor = a_.getColor(R.styleable.chip_layout_hintColor_, Color.parseColor((String)"#80000000"));
        this.chipColor = a_.getColor(R.styleable.chip_layout_chipColor_, Color.parseColor((String)"#00FFFFFF"));
        this.chipDrawable = a_.getDrawable(R.styleable.chip_layout_chipDrawable_);
        this.deleteIcon = a_.getDrawable(R.styleable.chip_layout_deleteIcon_);
        this.showDeleteButton = a_.getBoolean(R.styleable.chip_layout_showDeleteButton_, true);
        this.labelPosition = a_.getInt(R.styleable.chip_layout_labelPosition_, 0);
        this.chipLayoutDrawable = a_.getDrawable(R.styleable.chip_layout_chipLayoutDrawable_);
        this.textSize = a_.getDimension(R.styleable.chip_layout_textSize_, 0.0f);
        this.hintText = a_.getString(R.styleable.chip_layout_hint_);
        this.chipTextPadding = a_.getDimension(R.styleable.chip_layout_chipTextPadding_, 0.0f);
        this.chipTextPaddingLeft = a_.getDimension(R.styleable.chip_layout_chipTextPaddingLeft_, 0.0f);
        this.chipTextPaddingRight = a_.getDimension(R.styleable.chip_layout_chipTextPaddingRight_, 0.0f);
        this.chipTextPaddingTop = a_.getDimension(R.styleable.chip_layout_chipTextPaddingTop_, 0.0f);
        this.chipTextPaddingBottom = a_.getDimension(R.styleable.chip_layout_chipTextPaddingBottom_, 0.0f);
        this.chipPadding = a_.getDimension(R.styleable.chip_layout_chipPadding_, 0.0f);
        this.chipPaddingLeft = a_.getDimension(R.styleable.chip_layout_chipPaddingLeft_, 0.0f);
        this.chipPaddingRight = a_.getDimension(R.styleable.chip_layout_chipPaddingRight_, 0.0f);
        this.chipPaddingTop = a_.getDimension(R.styleable.chip_layout_chipPaddingTop_, 0.0f);
        this.chipPaddingBottom = a_.getDimension(R.styleable.chip_layout_chipPaddingBottom_, 0.0f);
        this.threshold = a_.getInt(R.styleable.chip_layout_threshold_, 2);
        if (this.deleteIcon != null) {
            this.deleteIcon_ = ((BitmapDrawable)this.deleteIcon).getBitmap();
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.chipLayout, defStyle, 0);
        try {
            int index = a.getInt(R.styleable.chipLayout_android_gravity, -1);
            if (index > 0) {
                this.setGravity(index);
            }
        }
        finally {
            a.recycle();
        }
        this.context = context;
        this.chipLayout = this;
        if (this.chipLayoutDrawable != null) {
            this.setLayoutBackground(this.chipLayoutDrawable);
        }
        this.createNewChipLayout(null);
        this.setOnClickListener();
    }

    public void setOnChipItemChangeListener(ChipItemChangeListener l) {
        this.chipItemChangeListener = l;
    }

    public ChipItemChangeListener getOnChipItemChangeListener() {
        return this.chipItemChangeListener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec) - this.getPaddingLeft() - this.getPaddingRight();
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int modeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int modeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int width = 0;
        int height = this.getPaddingTop() + this.getPaddingBottom();
        int lineWidth = 0;
        int lineHeight = 0;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            boolean lastChild;
            View child = this.getChildAt(i);
            boolean bl = lastChild = i == childCount - 1;
            if (child.getVisibility() == 8) {
                if (!lastChild) continue;
                width = Math.max(width, lineWidth);
                height += lineHeight;
                continue;
            }
            this.measureChildWithMargins(child, widthMeasureSpec, lineWidth, heightMeasureSpec, height);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childWidthMode = Integer.MIN_VALUE;
            int childWidthSize = sizeWidth;
            int childHeightMode = Integer.MIN_VALUE;
            int childHeightSize = sizeHeight;
            if (lp.width == -1) {
                childWidthMode = 0x40000000;
                childWidthSize -= lp.leftMargin + lp.rightMargin;
            } else if (lp.width >= 0) {
                childWidthMode = 0x40000000;
                childWidthSize = lp.width;
            }
            if (lp.height >= 0) {
                childHeightMode = 0x40000000;
                childHeightSize = lp.height;
            } else if (modeHeight == 0) {
                childHeightMode = 0;
                childHeightSize = 0;
            }
            child.measure(View.MeasureSpec.makeMeasureSpec((int)childWidthSize, (int)childWidthMode), View.MeasureSpec.makeMeasureSpec((int)childHeightSize, (int)childHeightMode));
            int childWidth = child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            if (lineWidth + childWidth > sizeWidth) {
                width = Math.max(width, lineWidth);
                lineWidth = childWidth;
                height += lineHeight;
                lineHeight = child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            } else {
                lineWidth += childWidth;
                lineHeight = Math.max(lineHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            }
            if (!lastChild) continue;
            width = Math.max(width, lineWidth);
            height += lineHeight;
        }
        this.setMeasuredDimension(modeWidth == 0x40000000 ? sizeWidth : (width += this.getPaddingLeft() + this.getPaddingRight()), modeHeight == 0x40000000 ? sizeHeight : height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        float horizontalGravityFactor;
        this.mLines.clear();
        this.mLineHeights.clear();
        this.mLineMargins.clear();
        int width = this.getWidth();
        int height = this.getHeight();
        int linesSum = this.getPaddingTop();
        int lineWidth = 0;
        int lineHeight = 0;
        List<Object> lineViews = new ArrayList<ViewGroup>();
        switch (this.mGravity & 7) {
            default: {
                horizontalGravityFactor = 0.0f;
                break;
            }
            case 1: {
                horizontalGravityFactor = 0.5f;
                break;
            }
            case 5: {
                horizontalGravityFactor = 1.0f;
            }
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            ViewGroup child = (ViewGroup)this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childWidth = child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            int childHeight = child.getMeasuredHeight() + lp.bottomMargin + lp.topMargin;
            if (lineWidth + childWidth > width) {
                this.mLineHeights.add(lineHeight);
                this.mLines.add(lineViews);
                this.mLineMargins.add((int)((float)(width - lineWidth) * horizontalGravityFactor) + this.getPaddingLeft());
                linesSum += lineHeight;
                lineHeight = 0;
                lineWidth = 0;
                lineViews = new ArrayList();
            }
            lineWidth += childWidth;
            lineHeight = Math.max(lineHeight, childHeight);
            lineViews.add(child);
        }
        this.mLineHeights.add(lineHeight);
        this.mLines.add(lineViews);
        this.mLineMargins.add((int)((float)(width - lineWidth) * horizontalGravityFactor) + this.getPaddingLeft());
        linesSum += lineHeight;
        int verticalGravityMargin = 0;
        switch (this.mGravity & 0x70) {
            default: {
                break;
            }
            case 16: {
                verticalGravityMargin = (height - linesSum) / 2;
                break;
            }
            case 80: {
                verticalGravityMargin = height - linesSum;
            }
        }
        int numLines = this.mLines.size();
        int top = this.getPaddingTop();
        for (int i = 0; i < numLines; ++i) {
            lineHeight = this.mLineHeights.get(i);
            lineViews = this.mLines.get(i);
            int left = this.mLineMargins.get(i);
            int children = lineViews.size();
            for (int j = 0; j < children; ++j) {
                View child = (View)lineViews.get(j);
                if (child.getVisibility() == 8) continue;
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.height == -1) {
                    int childWidthMode = Integer.MIN_VALUE;
                    int childWidthSize = lineWidth;
                    if (lp.width == -1) {
                        childWidthMode = 0x40000000;
                    } else if (lp.width >= 0) {
                        childWidthMode = 0x40000000;
                        childWidthSize = lp.width;
                    }
                    child.measure(View.MeasureSpec.makeMeasureSpec((int)childWidthSize, (int)childWidthMode), View.MeasureSpec.makeMeasureSpec((int)(lineHeight - lp.topMargin - lp.bottomMargin), (int)0x40000000));
                }
                int childWidth = child.getMeasuredWidth();
                int childHeight = child.getMeasuredHeight();
                int gravityMargin = 0;
                if (Gravity.isVertical((int)lp.gravity)) {
                    switch (lp.gravity) {
                        default: {
                            break;
                        }
                        case 16: 
                        case 17: {
                            gravityMargin = (lineHeight - childHeight - lp.topMargin - lp.bottomMargin) / 2;
                            break;
                        }
                        case 80: {
                            gravityMargin = lineHeight - childHeight - lp.topMargin - lp.bottomMargin;
                        }
                    }
                }
                child.layout(left + lp.leftMargin, top + lp.topMargin + gravityMargin + verticalGravityMargin, left + childWidth + lp.leftMargin, top + childHeight + lp.topMargin + gravityMargin + verticalGravityMargin);
                left += childWidth + lp.leftMargin + lp.rightMargin;
            }
            top += lineHeight;
        }
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return super.checkLayoutParams(p) && p instanceof LayoutParams;
    }

    @TargetApi(value=14)
    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 0x800007) == 0) {
                gravity |= ChipLayout.isIcs() ? 0x800003 : 3;
            }
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    public int getGravity() {
        return this.mGravity;
    }

    private static boolean isIcs() {
        return Build.VERSION.SDK_INT >= 14;
    }

    private AutoCompleteTextView createAutoCompleteTextView(Context context) {
        LayoutParams lparamsTextView = new LayoutParams(-2, -2);
        lparamsTextView.setMargins(0, 0, 10, 0);
        lparamsTextView.gravity = 17;
        AutoCompleteTextView autoCompleteTextView = new AutoCompleteTextView(context);
        autoCompleteTextView.setBackgroundColor(Color.parseColor((String)"#00FFFFFF"));
        autoCompleteTextView.setLayoutParams((ViewGroup.LayoutParams)lparamsTextView);
        autoCompleteTextView.setHint((CharSequence)" ");
        autoCompleteTextView.setPadding(10, 0, 10, 10);
        autoCompleteTextView.setSingleLine(true);
        autoCompleteTextView.setTextColor(this.textColor);
        autoCompleteTextView.setHintTextColor(this.hintColor);
        autoCompleteTextView.setCursorVisible(true);
        autoCompleteTextView.setThreshold(this.threshold);
        return autoCompleteTextView;
    }

    private ImageButton createImageButton(Context context) {
        LayoutParams lparamsImageButton = new LayoutParams(-2, -1);
        lparamsImageButton.gravity = 17;
        lparamsImageButton.setMargins(0, 0, 0, 0);
        ImageButton imageButton = new ImageButton(context);
        imageButton.setBackgroundColor(Color.parseColor((String)"#00FFFFFF"));
        if (this.deleteIcon != null) {
            imageButton.setImageBitmap(this.deleteIcon_);
        } else {
            imageButton.setImageResource(17301610);
        }
        imageButton.setLayoutParams((ViewGroup.LayoutParams)lparamsImageButton);
        imageButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                View chip = (View)view.getParent();
                int pos = ChipLayout.this.chipLayout.indexOfChild(chip);
                ChipLayout.this.removeChipAt(pos);
            }
        });
        imageButton.setVisibility(8);
        return imageButton;
    }

    private LinearLayout createLinearLayout(Context context) {
        LayoutParams lparamsLayout = new LayoutParams(-2, -2);
        lparamsLayout.setMargins((int)this.chipPadding + (int)this.chipPaddingLeft + 2, (int)this.chipPadding + (int)this.chipPaddingTop + 2, (int)this.chipPadding + (int)this.chipPaddingRight + 2, (int)this.chipPadding + (int)this.chipPaddingBottom + 2);
        lparamsLayout.gravity = 17;
        LinearLayout layout = new LinearLayout(context);
        layout.setPadding((int)this.chipTextPadding + (int)this.chipTextPaddingLeft, (int)this.chipTextPadding + (int)this.chipTextPaddingTop, (int)this.chipTextPadding + (int)this.chipTextPaddingRight, (int)this.chipTextPadding + (int)this.chipTextPaddingBottom);
        layout.setOrientation(0);
        layout.setLayoutParams((ViewGroup.LayoutParams)lparamsLayout);
        layout.setFocusable(true);
        return layout;
    }

    private ViewGroup createChips(Context context, String val, boolean setText) {
        LinearLayout layout = this.createLinearLayout(context);
        final AutoCompleteTextView autoCompleteTextView = this.createAutoCompleteTextView(context);
        autoCompleteTextView.setTag((Object)this.autoCompleteTextViewTag);
        if (this.getChildCount() < 1 && this.hintText != null) {
            autoCompleteTextView.setHint((CharSequence)this.hintText);
        }
        ImageButton imageButton = this.createImageButton(context);
        imageButton.setTag((Object)this.imageButtonTag);
        if (this.labelPosition == 0) {
            layout.addView((View)autoCompleteTextView);
            layout.addView((View)imageButton);
        } else {
            layout.addView((View)imageButton);
            layout.addView((View)autoCompleteTextView);
        }
        Drawable newDrawable = null;
        if (this.chipDrawable != null) {
            newDrawable = this.chipDrawable.getConstantState().newDrawable();
        }
        ChipTextWatcher textWatcher = new ChipTextWatcher((ViewGroup)layout, context, this, this.textColor, this.chipColor, newDrawable, this.showDeleteButton, this.labelPosition, this.listTextWatcher, setText);
        this.focusedTextWatcher = textWatcher;
        if (this.textSize > 0.0f) {
            autoCompleteTextView.setTextSize(this.textSize);
            textWatcher.setTextSize(this.textSize);
        }
        autoCompleteTextView.addTextChangedListener((TextWatcher)textWatcher);
        for (TextWatcher tw : this.listTextWatcher) {
            autoCompleteTextView.addTextChangedListener(tw);
        }
        ChipOnFocusChangeListener focusChangeListener = new ChipOnFocusChangeListener(this, (EditText)autoCompleteTextView, this.chipDrawable, this.chipLayoutDrawable, this.onFocusChangeListener);
        autoCompleteTextView.setOnFocusChangeListener((View.OnFocusChangeListener)focusChangeListener);
        autoCompleteTextView.requestFocus();
        autoCompleteTextView.setOnEditorActionListener((TextView.OnEditorActionListener)new ChipEditorActionListener((EditText)autoCompleteTextView));
        autoCompleteTextView.setAdapter((ListAdapter)this.adapter);
        int density = context.getResources().getDisplayMetrics().densityDpi;
        switch (density) {
            case 120: {
                break;
            }
            case 160: {
                break;
            }
            case 240: {
                this.dropDownWidth = 280;
                break;
            }
            case 320: {
                this.dropDownWidth = 300;
                break;
            }
            case 480: {
                this.dropDownWidth = 320;
                break;
            }
            case 560: {
                this.dropDownWidth = 360;
            }
        }
        if (this.chipLayout.getWidth() < 1) {
            ViewTreeObserver vto = this.getViewTreeObserver();
            vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (Build.VERSION.SDK_INT < 16) {
                        ChipLayout.this.chipLayout.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        ChipLayout.this.chipLayout.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                    if (ChipLayout.this.chipLayout.getWidth() < ChipLayout.this.dropDownWidth) {
                        autoCompleteTextView.setDropDownWidth(ChipLayout.this.dropDownWidth);
                    } else {
                        autoCompleteTextView.setDropDownWidth(ChipLayout.this.chipLayout.getWidth());
                    }
                }
            });
        } else if (this.chipLayout.getWidth() < this.dropDownWidth) {
            autoCompleteTextView.setDropDownWidth(this.dropDownWidth);
        } else {
            autoCompleteTextView.setDropDownWidth(this.chipLayout.getWidth());
        }
        autoCompleteTextView.setDropDownVerticalOffset(3);
        autoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
                autoCompleteTextView.setText((CharSequence)(autoCompleteTextView.getText().toString() + ","));
                if (ChipLayout.this.onItemClickListener != null) {
                    ChipLayout.this.onItemClickListener.onItemClick(arg0, arg1, arg2, arg3);
                }
            }
        });
        if (val != null) {
            autoCompleteTextView.setText((CharSequence)val);
        }
        return layout;
    }

    void createNewChipLayout(String val) {
        this.addView((View)this.createChips(this.context, val, false));
    }

    void createNewChipLayout(String val, boolean setText) {
        this.addView((View)this.createChips(this.context, val, setText));
    }

    void chipCreated(ViewGroup vg) {
        AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)vg.getChildAt(this.labelPosition);
        int pos = this.chipLayout.indexOfChild((View)vg);
        if (this.chipItemChangeListener != null) {
            if (autoCompleteTextView.getText() != null && autoCompleteTextView.getText().toString().length() > 0) {
                this.chipItemChangeListener.onChipAdded(pos, autoCompleteTextView.getText().toString());
            } else {
                this.chipItemChangeListener.onChipAdded(pos, "");
            }
        }
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener f) {
        this.onFocusChangeListener = f;
        if (this.getChildCount() > 0) {
            AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)((ViewGroup)this.getChildAt(this.getChildCount() - 1)).getChildAt(this.labelPosition);
            ChipOnFocusChangeListener focusChangeListener = new ChipOnFocusChangeListener(this, (EditText)autoCompleteTextView, this.chipDrawable, this.chipLayoutDrawable, this.onFocusChangeListener);
            autoCompleteTextView.setOnFocusChangeListener((View.OnFocusChangeListener)focusChangeListener);
        }
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.onClickListener = l;
    }

    private void setOnClickListener() {
        super.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View view) {
        this.onLayoutClick();
        if (this.onClickListener != null) {
            this.onClickListener.onClick(view);
        }
    }

    private void onLayoutClick() {
        int totalChips = this.getChildCount() - 1;
        if (totalChips < 0) {
            this.createNewChipLayout(null);
        } else {
            AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)((ViewGroup)this.getChildAt(totalChips)).getChildAt(this.labelPosition);
            if (autoCompleteTextView.isFocusable()) {
                autoCompleteTextView.requestFocus();
                InputMethodManager inputMethodManager = (InputMethodManager)this.context.getSystemService("input_method");
                inputMethodManager.toggleSoftInputFromWindow(autoCompleteTextView.getApplicationWindowToken(), 2, 0);
            } else {
                this.createNewChipLayout(null);
            }
        }
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener l) {
        this.onItemClickListener = l;
    }

    public AdapterView.OnItemClickListener getOnItemClickListener() {
        return this.onItemClickListener;
    }

    public void addLayoutTextChangedListener(TextWatcher textWatcher) {
        this.listTextWatcher.add(textWatcher);
        if (this.getChildCount() > 0) {
            AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)((ViewGroup)this.getChildAt(this.getChildCount() - 1)).getChildAt(this.labelPosition);
            autoCompleteTextView.addTextChangedListener(textWatcher);
        }
    }

    public void removeLayoutTextChangedListener(TextWatcher textWatcher) {
        this.listTextWatcher.remove(textWatcher);
        if (this.getChildCount() > 0) {
            AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)((ViewGroup)this.getChildAt(this.getChildCount() - 1)).getChildAt(this.labelPosition);
            autoCompleteTextView.removeTextChangedListener(textWatcher);
        }
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        for (int i = 0; i < this.getChildCount(); ++i) {
            AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)((ViewGroup)this.getChildAt(i)).getChildAt(this.labelPosition);
            autoCompleteTextView.setTextColor(textColor);
            ((ChipTextWatcher)this.focusedTextWatcher).setTextColor(textColor);
        }
    }

    public void setHintColor(int hintColor) {
        this.hintColor = hintColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setChipColor(int bgColor) {
        this.chipColor = bgColor;
        this.chipDrawable = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)((ViewGroup)this.getChildAt(i)).getChildAt(this.labelPosition);
            if (!autoCompleteTextView.isFocusable()) {
                View v = this.getChildAt(i);
                v.setBackgroundColor(this.chipColor);
                continue;
            }
            ((ChipTextWatcher)this.focusedTextWatcher).setChipColor(this.chipColor);
            ((ChipTextWatcher)this.focusedTextWatcher).setChipDrawable(null);
        }
    }

    public int getChipColor() {
        return this.chipColor;
    }

    public void highlightChipAt(int pos, int bgColor, int textColor) {
        View v = this.getChildAt(pos);
        v.setBackgroundColor(bgColor);
        AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)((ViewGroup)v).getChildAt(this.labelPosition);
        autoCompleteTextView.setTextColor(textColor);
    }

    public void highlightChipAt(int pos, Drawable bgDrawable, int textColor) {
        View v = this.getChildAt(pos);
        if (Build.VERSION.SDK_INT >= 16) {
            v.setBackground(bgDrawable);
        } else {
            v.setBackgroundDrawable(bgDrawable);
        }
        AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)((ViewGroup)v).getChildAt(this.labelPosition);
        autoCompleteTextView.setTextColor(textColor);
    }

    public void setChipDrawable(Drawable bgDrawable) {
        this.chipDrawable = bgDrawable;
        for (int i = 0; i < this.getChildCount(); ++i) {
            AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)((ViewGroup)this.getChildAt(i)).getChildAt(this.labelPosition);
            if (!autoCompleteTextView.isFocusable()) {
                View v = this.getChildAt(i);
                if (Build.VERSION.SDK_INT >= 16) {
                    v.setBackground(this.chipDrawable);
                    continue;
                }
                v.setBackgroundDrawable(this.chipDrawable);
                continue;
            }
            ((ChipTextWatcher)this.focusedTextWatcher).setChipDrawable(this.chipDrawable);
        }
    }

    public Drawable getChipDrawable() {
        return this.chipDrawable;
    }

    public void setHint(String hint) {
        this.hintText = hint;
        if (this.getChildCount() == 1) {
            AutoCompleteTextView textView = (AutoCompleteTextView)this.getChildAt(0).findViewWithTag((Object)this.autoCompleteTextViewTag);
            textView.setHint((CharSequence)this.hintText);
        }
    }

    public String getHint() {
        return this.hintText;
    }

    @TargetApi(value=16)
    public void setText(List<String> vals) {
        this.removeAllViews();
        for (String str : vals) {
            this.createNewChipLayout(str + ",", true);
        }
    }

    public List<String> getText() {
        ArrayList<String> textList = new ArrayList<String>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)((ViewGroup)this.getChildAt(i)).getChildAt(this.labelPosition);
            if (autoCompleteTextView.getText() == null || autoCompleteTextView.getText().toString().length() <= 0) continue;
            textList.add(autoCompleteTextView.getText().toString());
        }
        return textList;
    }

    public void removeChipAt(int pos) {
        AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)((ViewGroup)this.getChildAt(pos)).getChildAt(this.labelPosition);
        this.removeViewAt(pos);
        if (this.chipItemChangeListener != null) {
            if (autoCompleteTextView.getText() != null && autoCompleteTextView.getText().toString().length() > 0) {
                this.chipItemChangeListener.onChipRemoved(pos, autoCompleteTextView.getText().toString());
            } else {
                this.chipItemChangeListener.onChipRemoved(pos, "");
            }
        }
        this.setHint(this.hintText);
    }

    public void removeAllChips() {
        this.removeAllViews();
        this.createNewChipLayout(null);
    }

    @TargetApi(value=16)
    public void setLayoutBackground(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(drawable2);
        } else {
            this.setBackgroundDrawable(drawable2);
        }
    }

    public void setAdapter(ArrayAdapter adapter) {
        this.adapter = adapter;
        if (this.getChildCount() > 0) {
            AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)((ViewGroup)this.getChildAt(this.getChildCount() - 1)).getChildAt(this.labelPosition);
            autoCompleteTextView.setAdapter((ListAdapter)adapter);
        }
    }

    public ArrayAdapter getAdapter() {
        return this.adapter;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int gravity = -1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.chipLayout_Layout);
            try {
                this.gravity = a.getInt(R.styleable.chipLayout_Layout_android_layout_gravity, -1);
            }
            finally {
                a.recycle();
            }
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    public static interface ChipItemChangeListener {
        public void onChipAdded(int var1, String var2);

        public void onChipRemoved(int var1, String var2);
    }
}

