/*
 * Decompiled with CFR 0.152.
 */
package com.libaml.android.view.chip;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.EditText;
import com.libaml.android.view.chip.ChipLayout;
import java.lang.reflect.Method;

public class ChipOnFocusChangeListener
implements View.OnFocusChangeListener {
    private ChipLayout chipLayout;
    private EditText editText;
    private Drawable editTextDrawable;
    private Drawable chipLayoutDrawable;
    private View.OnFocusChangeListener focusChangeListener;

    public ChipOnFocusChangeListener(ChipLayout chipLayout, EditText editText, Drawable editTextDrawable, Drawable chipLayoutDrawable, View.OnFocusChangeListener focusChangeListener) {
        this.chipLayout = chipLayout;
        this.editText = editText;
        this.editTextDrawable = editTextDrawable;
        this.chipLayoutDrawable = chipLayoutDrawable;
        this.focusChangeListener = focusChangeListener;
    }

    public void onFocusChange(View view, final boolean b) {
        if (this.focusChangeListener != null) {
            this.focusChangeListener.onFocusChange(view, b);
        }
        if (this.chipLayout.getWidth() < 1) {
            ViewTreeObserver vto = this.chipLayout.getViewTreeObserver();
            vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (Build.VERSION.SDK_INT < 16) {
                        ChipOnFocusChangeListener.this.chipLayout.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        ChipOnFocusChangeListener.this.chipLayout.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                    ChipOnFocusChangeListener.this.changeBackground(b);
                }
            });
        } else {
            this.changeBackground(b);
        }
    }

    void changeBackground(boolean b) {
        try {
            if (this.chipLayoutDrawable != null && this.chipLayoutDrawable instanceof StateListDrawable) {
                StateListDrawable stateListDrawable = (StateListDrawable)this.chipLayoutDrawable;
                Method getStateDrawable = StateListDrawable.class.getMethod("getStateDrawable", Integer.TYPE);
                int stateEnabled = 1;
                int statePressed = 1;
                for (int i = 0; i < 4; ++i) {
                    try {
                        Drawable drawable2 = (Drawable)getStateDrawable.invoke((Object)stateListDrawable, i);
                        if (drawable2 == null) continue;
                        if (stateListDrawable.getCurrent() == drawable2.getCurrent()) {
                            stateEnabled = i;
                            continue;
                        }
                        statePressed = i;
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (b) {
                    Drawable drawable3 = (Drawable)getStateDrawable.invoke((Object)stateListDrawable, statePressed);
                    if (Build.VERSION.SDK_INT >= 16) {
                        this.chipLayout.setBackground(drawable3);
                    } else {
                        this.chipLayout.setBackgroundDrawable(drawable3);
                    }
                    this.chipLayout.requestFocus();
                } else {
                    Drawable drawable4 = (Drawable)getStateDrawable.invoke((Object)stateListDrawable, stateEnabled);
                    if (Build.VERSION.SDK_INT >= 16) {
                        this.chipLayout.setBackground(drawable4);
                    } else {
                        this.chipLayout.setBackgroundDrawable(drawable4);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

