/*
 * Decompiled with CFR 0.152.
 */
package com.libaml.android.view.chip;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.text.style.ImageSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.TextView;
import com.libaml.android.view.chip.ChipLayout;
import java.util.List;

public class ChipTextWatcher
implements TextWatcher {
    private ViewGroup chip;
    private Context context;
    private ChipLayout chipLayout;
    private int textColor;
    private int chipColor;
    private Drawable chipDrawable;
    private boolean showDeleteButton;
    private boolean setText;
    private int labelPosition;
    private float textSize = 0.0f;
    private List<TextWatcher> listTextWatcher;

    public ChipTextWatcher(ViewGroup chip, Context context, ChipLayout chipLayout, int textColor, int chipColor, Drawable chipDrawable, boolean showDeleteButton, int labelPosition, List<TextWatcher> listTextWatcher, boolean setText) {
        this.chip = chip;
        this.chipLayout = chipLayout;
        this.context = context;
        this.textColor = textColor;
        this.chipColor = chipColor;
        this.chipDrawable = chipDrawable;
        this.showDeleteButton = showDeleteButton;
        this.labelPosition = labelPosition;
        this.listTextWatcher = listTextWatcher;
        this.setText = setText;
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
    }

    @TargetApi(value=16)
    public void afterTextChanged(Editable editable) {
        String text = editable.toString();
        if (text != null && text.length() > 0 && text.charAt(text.length() - 1) == ',') {
            EditText editText = (EditText)this.chip.getChildAt(this.labelPosition);
            String val = text.substring(0, text.length() - 1);
            if (val.length() > ChipLayout.MAX_CHARACTER_COUNT) {
                editText.setText((CharSequence)this.textToChip(val, true));
            } else {
                editText.setInputType(524288);
                editText.setText((CharSequence)val);
            }
            editText.setClickable(false);
            editText.setCursorVisible(false);
            editText.setFocusable(false);
            editText.setFocusableInTouchMode(false);
            editText.setHint((CharSequence)"");
            ((AutoCompleteTextView)editText).setAdapter(null);
            ((AutoCompleteTextView)editText).setOnItemClickListener(null);
            if (this.chipDrawable != null) {
                int currentVersion = Build.VERSION.SDK_INT;
                if (currentVersion >= 16) {
                    this.chip.setBackground(this.chipDrawable);
                } else {
                    this.chip.setBackgroundDrawable(this.chipDrawable);
                }
            } else {
                this.chip.setBackgroundColor(this.chipColor);
            }
            if (this.showDeleteButton) {
                int buttonPosition = 1;
                if (this.labelPosition == 1) {
                    buttonPosition = 0;
                }
                ImageButton close = (ImageButton)this.chip.getChildAt(buttonPosition);
                close.setVisibility(0);
            }
            if (!this.setText) {
                this.chipLayout.createNewChipLayout(null);
            }
            this.chipLayout.chipCreated(this.chip);
        }
    }

    private SpannableStringBuilder textToChip(String val, boolean trim) {
        SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)val);
        try {
            TextView textView = this.createAutoCompleteTextView(this.context);
            if (trim) {
                textView.setText((CharSequence)(val.substring(0, ChipLayout.MAX_CHARACTER_COUNT) + ".."));
            } else {
                textView.setText((CharSequence)val);
            }
            int spec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            textView.measure(spec, spec);
            textView.layout(0, 0, textView.getMeasuredWidth(), textView.getMeasuredHeight());
            Bitmap b = Bitmap.createBitmap((int)textView.getWidth(), (int)textView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(b);
            canvas.translate((float)(-textView.getScrollX()), (float)(-textView.getScrollY()));
            textView.draw(canvas);
            textView.setDrawingCacheEnabled(true);
            Bitmap cacheBmp = textView.getDrawingCache();
            Bitmap viewBmp = cacheBmp.copy(Bitmap.Config.ARGB_8888, true);
            textView.destroyDrawingCache();
            BitmapDrawable bmpDrawable = new BitmapDrawable(this.context.getResources(), viewBmp);
            bmpDrawable.setBounds(0, 0, bmpDrawable.getIntrinsicWidth(), bmpDrawable.getIntrinsicHeight());
            ssb.setSpan((Object)new ImageSpan((Drawable)bmpDrawable), 0, val.length(), 33);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ssb;
    }

    private TextView createAutoCompleteTextView(Context context) {
        ChipLayout.LayoutParams lparamsTextView = new ChipLayout.LayoutParams(-2, -2);
        lparamsTextView.setMargins(0, 0, 0, 0);
        AutoCompleteTextView textView = new AutoCompleteTextView(context);
        textView.setPadding(0, 0, 0, 0);
        textView.setBackgroundColor(Color.parseColor((String)"#00FFFFFF"));
        textView.setLayoutParams((ViewGroup.LayoutParams)lparamsTextView);
        textView.setSingleLine(true);
        textView.setTextColor(this.textColor);
        if (this.textSize > 0.0f) {
            textView.setTextSize(this.textSize);
        }
        return textView;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public void setChipColor(int chipColor) {
        this.chipColor = chipColor;
    }

    public void setChipDrawable(Drawable chipDrawable) {
        this.chipDrawable = chipDrawable;
    }
}

