/*
 * Decompiled with CFR 0.152.
 */
package top.niunaijun.blackreflection;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import top.niunaijun.blackreflection.BlackReflectionInfo;
import top.niunaijun.blackreflection.BlackReflectionInterfaceInfo;
import top.niunaijun.blackreflection.annotation.BClass;
import top.niunaijun.blackreflection.annotation.BClassName;
import top.niunaijun.blackreflection.annotation.BConstructor;
import top.niunaijun.blackreflection.annotation.BField;
import top.niunaijun.blackreflection.annotation.BMethod;
import top.niunaijun.blackreflection.annotation.BStaticField;
import top.niunaijun.blackreflection.annotation.BStaticMethod;
import top.niunaijun.blackreflection.proxy.BlackReflectionInterfaceProxy;
import top.niunaijun.blackreflection.proxy.BlackReflectionProxy;

@AutoService(value=Processor.class)
public class BlackReflectionProcessor
extends AbstractProcessor {
    private Map<String, BlackReflectionProxy> mBlackReflectionProxies;
    private Map<String, BlackReflectionInterfaceProxy> mBlackReflectionInterfaceProxies;
    private Map<String, String> mRealMaps = new HashMap<String, String>();
    private Messager mMessager;
    private Elements mElementUtils;
    private Filer mFiler;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.mMessager = processingEnv.getMessager();
        this.mElementUtils = processingEnv.getElementUtils();
        this.mFiler = processingEnv.getFiler();
        this.mBlackReflectionProxies = new Hashtable<String, BlackReflectionProxy>();
        this.mBlackReflectionInterfaceProxies = new Hashtable<String, BlackReflectionInterfaceProxy>();
        this.mRealMaps = new Hashtable<String, String>();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> supportTypes = new LinkedHashSet<String>();
        supportTypes.add(BClass.class.getCanonicalName());
        supportTypes.add(BClassName.class.getCanonicalName());
        supportTypes.add(BField.class.getCanonicalName());
        supportTypes.add(BStaticField.class.getCanonicalName());
        supportTypes.add(BMethod.class.getCanonicalName());
        supportTypes.add(BStaticMethod.class.getCanonicalName());
        supportTypes.add(BConstructor.class.getCanonicalName());
        return supportTypes;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        BClassName annotation;
        this.mBlackReflectionProxies.clear();
        this.mBlackReflectionInterfaceProxies.clear();
        this.mRealMaps.clear();
        for (Element element : roundEnv.getElementsAnnotatedWith(BClassName.class)) {
            annotation = element.getAnnotation(BClassName.class);
            this.doProcess(element, annotation.value());
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(BClass.class)) {
            annotation = element.getAnnotation(BClass.class);
            String aClass = BlackReflectionProcessor.getClass((BClass)annotation).toString();
            this.doProcess(element, aClass);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(BStaticMethod.class)) {
            this.doInterfaceProcess(element, true, false);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(BMethod.class)) {
            this.doInterfaceProcess(element, false, false);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(BStaticField.class)) {
            this.doInterfaceProcess(element, true, true);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(BField.class)) {
            this.doInterfaceProcess(element, false, true);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(BConstructor.class)) {
            this.doInterfaceProcess(element, true, false);
        }
        for (BlackReflectionInterfaceProxy blackReflectionInterfaceProxy : this.mBlackReflectionInterfaceProxies.values()) {
            try {
                blackReflectionInterfaceProxy.setRealMap(this.mRealMaps);
                blackReflectionInterfaceProxy.generateInterfaceCode().writeTo(this.mFiler);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (BlackReflectionProxy blackReflectionProxy : this.mBlackReflectionProxies.values()) {
            try {
                blackReflectionProxy.generateJavaCode().writeTo(this.mFiler);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private void doInterfaceProcess(Element element, boolean isStatic, boolean isField) {
        String className = element.getEnclosingElement().asType().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        String packageName = this.mElementUtils.getPackageOf(executableElement).getQualifiedName().toString();
        BlackReflectionInterfaceInfo interfaceInfo = new BlackReflectionInterfaceInfo();
        interfaceInfo.setExecutableElement(executableElement);
        interfaceInfo.setField(isField);
        BlackReflectionInterfaceProxy reflectionInterfaceProxy = this.getReflectionInterfaceProxy(packageName, className + (isStatic ? "Static" : "Context"), className);
        reflectionInterfaceProxy.add(interfaceInfo);
    }

    private void doProcess(Element element, String realClassName) {
        String packageName = this.mElementUtils.getPackageOf(element).getQualifiedName().toString();
        String className = element.asType().toString();
        BlackReflectionInfo info = new BlackReflectionInfo();
        info.setRealClass(realClassName);
        info.setClassName(className);
        this.getReflectionProxy(packageName, className, info);
        this.getReflectionInterfaceProxy(packageName, className + "Context", className);
        this.getReflectionInterfaceProxy(packageName, className + "Static", className);
        this.mRealMaps.put(className, realClassName);
    }

    private static TypeMirror getClass(BClass annotation) {
        try {
            annotation.value();
        }
        catch (MirroredTypeException mte) {
            return mte.getTypeMirror();
        }
        return null;
    }

    public BlackReflectionProxy getReflectionProxy(String packageName, String className, BlackReflectionInfo info) {
        BlackReflectionProxy blackReflectionProxy = this.mBlackReflectionProxies.get(className);
        if (blackReflectionProxy == null) {
            blackReflectionProxy = new BlackReflectionProxy(packageName, info);
            this.mBlackReflectionProxies.put(className, blackReflectionProxy);
        }
        return blackReflectionProxy;
    }

    public BlackReflectionInterfaceProxy getReflectionInterfaceProxy(String packageName, String className, String origClassName) {
        BlackReflectionInterfaceProxy blackReflectionProxy = this.mBlackReflectionInterfaceProxies.get(className);
        if (blackReflectionProxy == null) {
            blackReflectionProxy = new BlackReflectionInterfaceProxy(packageName, className, origClassName);
            this.mBlackReflectionInterfaceProxies.put(className, blackReflectionProxy);
        }
        return blackReflectionProxy;
    }
}

