/*
 * Decompiled with CFR 0.152.
 */
package top.niunaijun.blackreflection.proxy;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import top.niunaijun.blackreflection.BlackReflectionInfo;
import top.niunaijun.blackreflection.utils.ClassUtils;

public class BlackReflectionProxy {
    private static final ClassName BR = ClassName.get((String)"top.niunaijun.blackreflection", (String)"BlackReflection", (String[])new String[0]);
    private final BlackReflectionInfo mReflection;
    private final ClassName mContextInterface;
    private final ClassName mStaticInterface;
    private final String mPackageName;

    public BlackReflectionProxy(String packageName, BlackReflectionInfo reflection) {
        this.mReflection = reflection;
        this.mPackageName = packageName;
        String finalClass = this.mReflection.getClassName().replace(packageName + ".", "").replace(".", "");
        this.mContextInterface = ClassName.get((String)ClassUtils.getPackage(finalClass), (String)ClassUtils.getName(finalClass + "Context"), (String[])new String[0]);
        this.mStaticInterface = ClassName.get((String)ClassUtils.getPackage(finalClass), (String)ClassUtils.getName(finalClass + "Static"), (String[])new String[0]);
    }

    public JavaFile generateJavaCode() {
        String finalClass = "BR" + this.mReflection.getClassName().replace(this.mPackageName + ".", "").replace(".", "");
        TypeSpec reflection = TypeSpec.classBuilder((String)finalClass).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(this.generaNotCallerMethod(true)).addMethod(this.generaNotCallerMethod(false)).addMethod(this.generaCallerMethod(true)).addMethod(this.generaCallerMethod(false)).addMethod(this.generaIsLoadMethod()).build();
        return JavaFile.builder((String)this.mPackageName, (TypeSpec)reflection).build();
    }

    private MethodSpec generaNotCallerMethod(boolean withException) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)("get" + (withException ? "WithException" : ""))).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.mStaticInterface);
        String statement = "return $T.create($T.class, null, $L)";
        builder.addStatement(statement, new Object[]{BR, this.mStaticInterface, withException});
        return builder.build();
    }

    private MethodSpec generaCallerMethod(boolean withException) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)("get" + (withException ? "WithException" : ""))).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter((TypeName)ClassName.get((String)"java.lang", (String)"Object", (String[])new String[0]), "caller", new Modifier[]{Modifier.FINAL}).returns((TypeName)this.mContextInterface);
        String statement = "return $T.create($T.class, caller, $L)";
        builder.addStatement(statement, new Object[]{BR, this.mContextInterface, withException});
        return builder.build();
    }

    private MethodSpec generaIsLoadMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getRealClass").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ClassName.get(Class.class));
        String statement = "return top.niunaijun.blackreflection.utils.ClassUtil.classReady($T.class)";
        builder.addStatement(statement, new Object[]{this.mContextInterface});
        return builder.build();
    }
}

