/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base.dragswipe;

import android.graphics.Canvas;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.chad.library.R;
import com.chad.library.adapter.base.module.BaseDraggableModule;

public class DragAndSwipeCallback
extends ItemTouchHelper.Callback {
    private BaseDraggableModule mDraggableModule;
    private float mMoveThreshold = 0.1f;
    private float mSwipeThreshold = 0.7f;
    private int mDragMoveFlags = 15;
    private int mSwipeMoveFlags = 32;

    public DragAndSwipeCallback(BaseDraggableModule draggableModule) {
        this.mDraggableModule = draggableModule;
    }

    public boolean isLongPressDragEnabled() {
        if (this.mDraggableModule != null) {
            return this.mDraggableModule.isDragEnabled() && !this.mDraggableModule.hasToggleView();
        }
        return false;
    }

    public boolean isItemViewSwipeEnabled() {
        if (this.mDraggableModule != null) {
            return this.mDraggableModule.isSwipeEnabled();
        }
        return false;
    }

    public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
        if (actionState == 2 && !this.isViewCreateByAdapter(viewHolder)) {
            if (this.mDraggableModule != null) {
                this.mDraggableModule.onItemDragStart(viewHolder);
            }
            viewHolder.itemView.setTag(R.id.BaseQuickAdapter_dragging_support, (Object)true);
        } else if (actionState == 1 && !this.isViewCreateByAdapter(viewHolder)) {
            if (this.mDraggableModule != null) {
                this.mDraggableModule.onItemSwipeStart(viewHolder);
            }
            viewHolder.itemView.setTag(R.id.BaseQuickAdapter_swiping_support, (Object)true);
        }
        super.onSelectedChanged(viewHolder, actionState);
    }

    public void clearView(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
        super.clearView(recyclerView, viewHolder);
        if (this.isViewCreateByAdapter(viewHolder)) {
            return;
        }
        if (viewHolder.itemView.getTag(R.id.BaseQuickAdapter_dragging_support) != null && ((Boolean)viewHolder.itemView.getTag(R.id.BaseQuickAdapter_dragging_support)).booleanValue()) {
            if (this.mDraggableModule != null) {
                this.mDraggableModule.onItemDragEnd(viewHolder);
            }
            viewHolder.itemView.setTag(R.id.BaseQuickAdapter_dragging_support, (Object)false);
        }
        if (viewHolder.itemView.getTag(R.id.BaseQuickAdapter_swiping_support) != null && ((Boolean)viewHolder.itemView.getTag(R.id.BaseQuickAdapter_swiping_support)).booleanValue()) {
            if (this.mDraggableModule != null) {
                this.mDraggableModule.onItemSwipeClear(viewHolder);
            }
            viewHolder.itemView.setTag(R.id.BaseQuickAdapter_swiping_support, (Object)false);
        }
    }

    public int getMovementFlags(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
        if (this.isViewCreateByAdapter(viewHolder)) {
            return DragAndSwipeCallback.makeMovementFlags((int)0, (int)0);
        }
        return DragAndSwipeCallback.makeMovementFlags((int)this.mDragMoveFlags, (int)this.mSwipeMoveFlags);
    }

    public boolean onMove(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder source, @NonNull RecyclerView.ViewHolder target) {
        return source.getItemViewType() == target.getItemViewType();
    }

    public void onMoved(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder source, int fromPos, @NonNull RecyclerView.ViewHolder target, int toPos, int x, int y) {
        super.onMoved(recyclerView, source, fromPos, target, toPos, x, y);
        if (this.mDraggableModule != null) {
            this.mDraggableModule.onItemDragMoving(source, target);
        }
    }

    public void onSwiped(@NonNull RecyclerView.ViewHolder viewHolder, int direction) {
        if (!this.isViewCreateByAdapter(viewHolder) && this.mDraggableModule != null) {
            this.mDraggableModule.onItemSwiped(viewHolder);
        }
    }

    public float getMoveThreshold(@NonNull RecyclerView.ViewHolder viewHolder) {
        return this.mMoveThreshold;
    }

    public float getSwipeThreshold(@NonNull RecyclerView.ViewHolder viewHolder) {
        return this.mSwipeThreshold;
    }

    public void setSwipeThreshold(float swipeThreshold) {
        this.mSwipeThreshold = swipeThreshold;
    }

    public void setMoveThreshold(float moveThreshold) {
        this.mMoveThreshold = moveThreshold;
    }

    public void setDragMoveFlags(int dragMoveFlags) {
        this.mDragMoveFlags = dragMoveFlags;
    }

    public void setSwipeMoveFlags(int swipeMoveFlags) {
        this.mSwipeMoveFlags = swipeMoveFlags;
    }

    public void onChildDrawOver(@NonNull Canvas c, @NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        super.onChildDrawOver(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        if (actionState == 1 && !this.isViewCreateByAdapter(viewHolder)) {
            View itemView = viewHolder.itemView;
            c.save();
            if (dX > 0.0f) {
                c.clipRect((float)itemView.getLeft(), (float)itemView.getTop(), (float)itemView.getLeft() + dX, (float)itemView.getBottom());
                c.translate((float)itemView.getLeft(), (float)itemView.getTop());
            } else {
                c.clipRect((float)itemView.getRight() + dX, (float)itemView.getTop(), (float)itemView.getRight(), (float)itemView.getBottom());
                c.translate((float)itemView.getRight() + dX, (float)itemView.getTop());
            }
            if (this.mDraggableModule != null) {
                this.mDraggableModule.onItemSwiping(c, viewHolder, dX, dY, isCurrentlyActive);
            }
            c.restore();
        }
    }

    private boolean isViewCreateByAdapter(@NonNull RecyclerView.ViewHolder viewHolder) {
        int type = viewHolder.getItemViewType();
        return type == 0x10000111 || type == 0x10000222 || type == 0x10000333 || type == 0x10000555;
    }
}

