/*
 * Decompiled with CFR 0.152.
 */
package com.xiasuhuei321.loadingdialog.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;

public class LVCircularRing
extends View {
    public final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private float mWidth = 0.0f;
    private float mPadding = 0.0f;
    private float startAngle = 0.0f;
    private Paint mPaint;
    private int color = Color.argb((int)100, (int)255, (int)255, (int)255);
    private Paint mPaint2;
    ValueAnimator valueAnimator;

    public LVCircularRing(Context context) {
        this(context, null);
    }

    public LVCircularRing(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LVCircularRing(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initPaint();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = this.getMeasuredWidth() > this.getHeight() ? (float)this.getMeasuredHeight() : (float)this.getMeasuredWidth();
        this.mPadding = 5.0f;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint2.setColor(this.color);
        canvas.drawCircle(this.mWidth / 2.0f, this.mWidth / 2.0f, this.mWidth / 2.0f - this.mPadding, this.mPaint2);
        this.mPaint.setColor(-1);
        RectF rectF = new RectF(this.mPadding, this.mPadding, this.mWidth - this.mPadding, this.mWidth - this.mPadding);
        canvas.drawArc(rectF, this.startAngle, 100.0f, false, this.mPaint);
    }

    private void initPaint() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.color);
        this.mPaint.setStrokeWidth(8.0f);
        this.mPaint2 = new Paint();
        this.mPaint2.setAntiAlias(true);
        this.mPaint2.setStyle(Paint.Style.STROKE);
        this.mPaint2.setStrokeWidth(8.0f);
        this.mPaint2.setColor(this.color);
    }

    public void startAnim() {
        this.stopAnim();
        this.startViewAnim(0.0f, 1.0f, 1000L);
    }

    public void stopAnim() {
        if (this.valueAnimator != null) {
            this.clearAnimation();
            this.valueAnimator.setRepeatCount(1);
            this.valueAnimator.cancel();
            this.valueAnimator.end();
        }
    }

    private ValueAnimator startViewAnim(float startF, float endF, long time) {
        this.valueAnimator = ValueAnimator.ofFloat((float[])new float[]{startF, endF});
        this.valueAnimator.setDuration(time);
        this.valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.valueAnimator.setRepeatCount(-1);
        this.valueAnimator.setRepeatMode(1);
        this.valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float value = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                LVCircularRing.this.startAngle = 360.0f * value;
                LVCircularRing.this.invalidate();
            }
        });
        this.valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
            }
        });
        if (!this.valueAnimator.isRunning()) {
            this.valueAnimator.start();
        }
        return this.valueAnimator;
    }

    public void setColor(@ColorInt int color) {
        this.color = color;
        this.mPaint.setColor(color);
        this.mPaint2.setColor(color);
    }
}

