/*
 * Decompiled with CFR 0.152.
 */
package com.xiasuhuei321.loadingdialog.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.xiasuhuei321.loadingdialog.view.SizeUtils;

public class LoadCircleView
extends View {
    public final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private float mPadding = 0.0f;
    private RectF rectF;
    private Context mContext;
    private Paint mPaint;
    private int mWidth = 0;
    private int currentLineIndex = 0;

    public LoadCircleView(Context context) {
        this(context, null);
    }

    public LoadCircleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LoadCircleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init();
    }

    public void init() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(8.0f);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.mWidth = widthSpecMode != Integer.MIN_VALUE && heightSpecMode != Integer.MIN_VALUE ? (widthSpecSize >= heightSpecSize ? widthSpecSize : heightSpecSize) : (widthSpecMode == Integer.MIN_VALUE && heightSpecMode != Integer.MIN_VALUE ? heightSpecSize : (widthSpecMode != Integer.MIN_VALUE ? widthSpecSize : SizeUtils.dip2px(this.mContext, 50.0f)));
        this.setMeasuredDimension(this.mWidth, this.mWidth);
        this.mPadding = 8.0f;
    }

    protected void onDraw(Canvas canvas) {
        int center = this.mWidth >> 1;
        int radius = (this.mWidth >> 1) - 8;
        if (this.currentLineIndex >= 12) {
            this.currentLineIndex = 0;
        }
        for (int i = 0; i < 12; ++i) {
            if (i < this.currentLineIndex + 4 && i >= this.currentLineIndex) {
                this.mPaint.setColor(-7829368);
            } else if (this.currentLineIndex > 8 && i < this.currentLineIndex + 4 - 12) {
                this.mPaint.setColor(-7829368);
            } else {
                this.mPaint.setColor(-1);
            }
            canvas.drawLine((float)center, (float)((double)center + 0.5 * (double)radius), (float)center, (float)(2 * radius), this.mPaint);
            canvas.rotate(30.0f, (float)center, (float)center);
        }
        ++this.currentLineIndex;
        this.postInvalidateDelayed(50L);
    }
}

