/*
 * Decompiled with CFR 0.152.
 */
package com.xiasuhuei321.loadingdialog.view;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.ColorInt;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xiasuhuei321.loadingdialog.R;
import com.xiasuhuei321.loadingdialog.manager.StyleManager;
import com.xiasuhuei321.loadingdialog.view.FinishDrawListener;
import com.xiasuhuei321.loadingdialog.view.LVCircularRing;
import com.xiasuhuei321.loadingdialog.view.LoadCircleView;
import com.xiasuhuei321.loadingdialog.view.RightDiaView;
import com.xiasuhuei321.loadingdialog.view.WrongDiaView;
import java.util.ArrayList;
import java.util.List;

public class LoadingDialog
implements FinishDrawListener {
    public final String TAG = "LoadingDialog";
    public static final int STYLE_RING = 0;
    public static final int STYLE_LINE = 1;
    private Context mContext;
    private LVCircularRing mLoadingView;
    private Dialog mLoadingDialog;
    private LinearLayout layout;
    private TextView loadingText;
    private RightDiaView mSuccessView;
    private WrongDiaView mFailedView;
    private String loadSuccessStr;
    private String loadFailedStr;
    private List<View> viewList;
    private boolean interceptBack = true;
    private boolean openSuccessAnim = true;
    private boolean openFailedAnim = true;
    private int speed = 1;
    private long time = 1000L;
    private int loadStyle = 0;
    private static StyleManager s = StyleManager.getDefault();
    private LoadCircleView mCircleLoadView;
    private OnFinshListener o;
    private DismissListener d;
    @SuppressLint(value={"HandlerLeak"})
    private Handler h = new Handler(){

        public void handleMessage(Message msg) {
            LoadingDialog.this.close();
            if (LoadingDialog.this.o != null) {
                LoadingDialog.this.o.onFinish();
            }
        }
    };

    public LoadingDialog(Context context) {
        this.mContext = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.loading_dialog_view, null);
        this.initView(view);
        this.mLoadingDialog = new Dialog(context, R.style.loading_dialog){

            public void onBackPressed() {
                if (LoadingDialog.this.interceptBack) {
                    return;
                }
                LoadingDialog.this.close();
            }
        };
        this.mLoadingDialog.setCancelable(!this.interceptBack);
        this.mLoadingDialog.setContentView((View)this.layout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.mLoadingDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                LoadingDialog.this.mContext = null;
                if (LoadingDialog.this.d != null) {
                    LoadingDialog.this.d.dimiss();
                }
            }
        });
        this.initStyle();
    }

    private void initView(View view) {
        this.layout = (LinearLayout)view.findViewById(R.id.dialog_view);
        this.mLoadingView = (LVCircularRing)view.findViewById(R.id.lv_circularring);
        this.loadingText = (TextView)view.findViewById(R.id.loading_text);
        this.mSuccessView = (RightDiaView)view.findViewById(R.id.rdv_right);
        this.mFailedView = (WrongDiaView)view.findViewById(R.id.wv_wrong);
        this.mCircleLoadView = (LoadCircleView)view.findViewById(R.id.lcv_circleload);
        this.initData();
    }

    private void initData() {
        this.viewList = new ArrayList<View>();
        this.viewList.add(this.mLoadingView);
        this.viewList.add(this.mSuccessView);
        this.viewList.add(this.mFailedView);
        this.viewList.add(this.mCircleLoadView);
        this.mSuccessView.setOnDrawFinishListener(this);
        this.mFailedView.setOnDrawFinishListener(this);
    }

    @Override
    public void dispatchFinishEvent(View v) {
        if (v instanceof WrongDiaView) {
            this.h.sendEmptyMessageDelayed(2, this.time);
        } else {
            this.h.sendEmptyMessageDelayed(1, this.time);
        }
    }

    private void hideAll() {
        for (View v : this.viewList) {
            if (v.getVisibility() == 8) continue;
            v.setVisibility(8);
        }
    }

    private void setParams(int size) {
        if (size < 0) {
            return;
        }
        ViewGroup.LayoutParams successParams = this.mSuccessView.getLayoutParams();
        successParams.height = size;
        successParams.width = size;
        this.mSuccessView.setLayoutParams(successParams);
        ViewGroup.LayoutParams failedParams = this.mFailedView.getLayoutParams();
        failedParams.height = size;
        failedParams.width = size;
        this.mFailedView.setLayoutParams(failedParams);
        ViewGroup.LayoutParams loadingParams = this.mLoadingView.getLayoutParams();
        loadingParams.height = size;
        loadingParams.width = size;
    }

    private void initStyle() {
        if (s != null) {
            this.setInterceptBack(s.isInterceptBack());
            this.setRepeatCount(s.getRepeatTime());
            this.setParams(s.getContentSize());
            this.setTextSize(s.getTextSize());
            this.setShowTime(s.getShowTime());
            if (!s.isOpenAnim()) {
                this.closeFailedAnim();
                this.closeSuccessAnim();
            }
            this.setLoadingText(s.getLoadText());
            this.setSuccessText(s.getSuccessText());
            this.setFailedText(s.getFailedText());
            this.setLoadStyle(s.getLoadStyle());
        }
    }

    public void show() {
        this.hideAll();
        if (this.loadStyle == 0) {
            this.mLoadingView.setVisibility(0);
            this.mCircleLoadView.setVisibility(8);
            this.mLoadingDialog.show();
            this.mLoadingView.startAnim();
            Log.i((String)"show", (String)"style_ring");
        } else if (this.loadStyle == 1) {
            this.mCircleLoadView.setVisibility(0);
            this.mLoadingView.setVisibility(8);
            this.mLoadingDialog.show();
            Log.i((String)"show", (String)"style_line");
        }
    }

    public LoadingDialog setLoadStyle(int style2) {
        if (style2 >= 3) {
            throw new IllegalArgumentException("Your style is wrong: style = " + style2);
        }
        this.loadStyle = style2;
        return this;
    }

    public void close() {
        this.h.removeCallbacksAndMessages(null);
        if (this.mLoadingDialog != null) {
            this.mLoadingView.stopAnim();
            this.mLoadingDialog.dismiss();
        }
    }

    public LoadingDialog setLoadingText(String msg) {
        if (msg != null) {
            this.loadingText.setVisibility(0);
            this.loadingText.setText((CharSequence)msg);
        } else {
            this.loadingText.setVisibility(8);
        }
        return this;
    }

    public LoadingDialog setSuccessText(String msg) {
        this.loadSuccessStr = msg;
        return this;
    }

    public LoadingDialog setFailedText(String msg) {
        this.loadFailedStr = msg;
        return this;
    }

    public void loadSuccess() {
        this.mLoadingView.stopAnim();
        this.hideAll();
        this.mSuccessView.setDrawDynamic(this.openSuccessAnim);
        this.mSuccessView.setVisibility(0);
        if (this.loadSuccessStr == null) {
            this.loadingText.setVisibility(8);
        } else {
            this.loadingText.setVisibility(0);
            this.loadingText.setText((CharSequence)this.loadSuccessStr);
        }
    }

    public void loadFailed() {
        this.mLoadingView.stopAnim();
        this.hideAll();
        this.mFailedView.setDrawDynamic(this.openFailedAnim);
        this.mFailedView.setVisibility(0);
        if (this.loadFailedStr == null) {
            this.loadingText.setVisibility(8);
        } else {
            this.loadingText.setVisibility(0);
            this.loadingText.setText((CharSequence)this.loadFailedStr);
        }
    }

    public LoadingDialog closeSuccessAnim() {
        this.openSuccessAnim = false;
        return this;
    }

    public LoadingDialog closeFailedAnim() {
        this.openFailedAnim = false;
        return this;
    }

    public LoadingDialog setInterceptBack(boolean interceptBack) {
        this.interceptBack = interceptBack;
        this.mLoadingDialog.setCancelable(!interceptBack);
        return this;
    }

    public boolean getInterceptBack() {
        return this.interceptBack;
    }

    public LoadingDialog setLoadSpeed(Speed speed) {
        if (speed == Speed.SPEED_ONE) {
            this.speed = 1;
            this.mSuccessView.setSpeed(1);
            this.mFailedView.setSpeed(1);
        } else {
            this.speed = 2;
            this.mSuccessView.setSpeed(2);
            this.mFailedView.setSpeed(2);
        }
        return this;
    }

    public int getSpeed() {
        return this.speed;
    }

    private LoadingDialog setDrawColor(@ColorInt int color) {
        this.mFailedView.setDrawColor(color);
        this.mSuccessView.setDrawColor(color);
        this.loadingText.setTextColor(color);
        this.mLoadingView.setColor(color);
        return this;
    }

    public LoadingDialog setSize(int size) {
        if (size <= 50) {
            return this;
        }
        this.setParams(size);
        return this;
    }

    public LoadingDialog setRepeatCount(int count) {
        this.mFailedView.setRepeatTime(count);
        this.mSuccessView.setRepeatTime(count);
        return this;
    }

    public LoadingDialog setShowTime(long time) {
        if (time < 0L) {
            return this;
        }
        this.time = time;
        return this;
    }

    public LoadingDialog setTextSize(float size) {
        if (size < 0.0f) {
            return this;
        }
        this.loadingText.setTextSize(2, size);
        return this;
    }

    public static void initStyle(StyleManager style2) {
        if (style2 != null) {
            s = style2;
        }
    }

    public void setOnFinishListener(OnFinshListener o) {
        this.o = o;
    }

    public LoadingDialog setDimissListener(DismissListener d) {
        this.d = d;
        return this;
    }

    public static interface DismissListener {
        public void dimiss();
    }

    public static interface OnFinshListener {
        public void onFinish();
    }

    public static enum Speed {
        SPEED_ONE,
        SPEED_TWO;

    }
}

