/*
 * Decompiled with CFR 0.152.
 */
package com.xiasuhuei321.loadingdialog.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.xiasuhuei321.loadingdialog.view.FinishDrawListener;
import com.xiasuhuei321.loadingdialog.view.SizeUtils;

public class RightDiaView
extends View {
    private final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private FinishDrawListener listener;
    private Context mContext;
    private int mWidth = 0;
    private float mPadding = 0.0f;
    private Paint mPaint;
    private RectF rectF;
    private int line1_x;
    private int line1_y;
    private int line2_x;
    private int line2_y;
    private int times = 0;
    private boolean drawEveryTime = true;
    private int speed = 1;
    int progress = 0;
    private int count = 0;

    public RightDiaView(Context context) {
        this(context, null);
    }

    public RightDiaView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RightDiaView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.mWidth = widthSpecMode != Integer.MIN_VALUE && heightSpecMode != Integer.MIN_VALUE ? (widthSpecSize >= heightSpecSize ? widthSpecSize : heightSpecSize) : (widthSpecMode == Integer.MIN_VALUE && heightSpecMode != Integer.MIN_VALUE ? heightSpecSize : (widthSpecMode != Integer.MIN_VALUE ? widthSpecSize : SizeUtils.dip2px(this.mContext, 80.0f)));
        this.setMeasuredDimension(this.mWidth, this.mWidth);
        this.mPadding = 8.0f;
        this.rectF = new RectF(this.mPadding, this.mPadding, (float)this.mWidth - this.mPadding, (float)this.mWidth - this.mPadding);
    }

    private void init(Context context) {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(-1);
        this.mPaint.setStrokeWidth(8.0f);
        this.mContext = context;
    }

    protected void onDraw(Canvas canvas) {
        if (this.drawEveryTime) {
            this.drawDynamic(canvas);
        } else {
            this.drawStatic(canvas);
            if (this.listener != null) {
                this.listener.dispatchFinishEvent(this);
            }
        }
    }

    private void drawDynamic(Canvas canvas) {
        if (this.progress < 100) {
            this.progress += this.speed;
        }
        canvas.drawArc(this.rectF, 235.0f, (float)(360 * this.progress / 100), false, this.mPaint);
        int center = this.mWidth / 2;
        int center1 = center - this.mWidth / 5;
        int radius = this.mWidth / 2 - 8;
        if (this.progress == 100) {
            if (this.line1_x < radius / 3) {
                this.line1_x += this.speed;
                this.line1_y += this.speed;
            }
            canvas.drawLine((float)center1, (float)center, (float)(center1 + this.line1_x), (float)(center + this.line1_y), this.mPaint);
            if (this.line1_x >= radius / 3 && this.line2_x == 0 && this.line2_y == 0) {
                this.line2_x = this.line1_x;
                this.line2_y = this.line1_y;
                this.line1_x += this.speed;
                this.line1_y += this.speed;
            }
            if (this.line1_x >= radius / 3 && this.line2_x <= radius && this.line2_y <= center - radius / 3) {
                this.line2_x += this.speed;
                this.line2_y -= this.speed;
            }
            canvas.drawLine((float)(center1 + this.line1_x - 1), (float)(center + this.line1_y - 4), (float)(center1 + this.line2_x), (float)(center + this.line2_y), this.mPaint);
        }
        if (this.line2_x > radius && this.progress >= 100 && this.line1_x != radius / 3) {
            if (this.count == 0 && this.times == 0 && this.listener != null) {
                this.listener.dispatchFinishEvent(this);
                ++this.count;
            }
            --this.times;
            if (this.times >= 0) {
                this.reDraw();
                this.invalidate();
            } else {
                return;
            }
        }
        this.invalidate();
    }

    private void drawStatic(Canvas canvas) {
        canvas.drawArc(this.rectF, 0.0f, 360.0f, false, this.mPaint);
        int center = this.mWidth / 2;
        int center1 = center - this.mWidth / 5;
        int radius = this.mWidth / 2 - 8;
        canvas.drawLine((float)center1, (float)center, (float)(center1 + radius / 3), (float)(center + radius / 3), this.mPaint);
        canvas.drawLine((float)(center1 + radius / 3 - 1), (float)(center + radius / 3 - 4), (float)(center1 + radius), (float)(center - radius / 3), this.mPaint);
    }

    private void reDraw() {
        this.line1_x = 0;
        this.line2_x = 0;
        this.line1_y = 0;
        this.line2_y = 0;
        this.progress = 0;
    }

    protected void setRepeatTime(int times) {
        if (this.drawEveryTime) {
            this.times = times;
        }
    }

    protected void setDrawDynamic(boolean drawEveryTime) {
        this.drawEveryTime = drawEveryTime;
    }

    protected void setSpeed(int speed) {
        if (speed <= 0 && speed >= 3) {
            throw new IllegalArgumentException("support speed >0 & < 3, the speed you set is: " + speed);
        }
        this.speed = speed;
    }

    protected void setDrawColor(int color) {
        this.mPaint.setColor(color);
    }

    public void setOnDrawFinishListener(FinishDrawListener f) {
        this.listener = f;
    }
}

