/*
 * Decompiled with CFR 0.152.
 */
package com.hyperai.hyperlpr3;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.hyperai.hyperlpr3.api.APIDefine;
import com.hyperai.hyperlpr3.bean.HyperLPRParameter;
import com.hyperai.hyperlpr3.bean.Plate;
import com.hyperai.hyperlpr3.core.HyperLPRCore;
import com.hyperai.hyperlpr3.settings.TypeDefine;
import com.hyperai.hyperlpr3.utils.SDKUtils;

public class HyperLPR3
extends TypeDefine
implements APIDefine {
    private final String TAG = "HyperLPR3-SDK";
    private final HyperLPRCore mCore = new HyperLPRCore();
    private boolean isInitSuccess = false;

    private HyperLPR3() {
    }

    public static final HyperLPR3 getInstance() {
        return LazyHolder.INSTANCE;
    }

    public void release() {
        this.mCore.release();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    @Override
    public void init(Context context, HyperLPRParameter parameter) {
        if (!this.isInitSuccess) {
            String mResourceFolderPath = context.getExternalFilesDir(null).getAbsolutePath() + "/";
            SDKUtils.copyFilesFromAssets(context, "r2_mobile", mResourceFolderPath);
            Log.i((String)"HyperLPR3-SDK", (String)("resource: " + mResourceFolderPath));
            if (parameter.getModelPath() == null || "".equals(parameter.getModelPath())) {
                parameter.setModelPath(mResourceFolderPath);
            }
            this.mCore.createRecognizerContext(parameter);
            this.isInitSuccess = true;
        }
    }

    @Override
    public Plate[] plateRecognition(byte[] buf, int height, int width, int rotation, int format) {
        if (!this.isInitSuccess) {
            Log.e((String)"HyperLPR3-SDK", (String)"HyperLPR3 is uninitialized.");
            return new Plate[0];
        }
        return this.mCore.plateRecognitionFromBuffer(buf, height, width, rotation, format);
    }

    @Override
    public Plate[] plateRecognition(Bitmap image, int rotation, int format) {
        if (!this.isInitSuccess) {
            Log.e((String)"HyperLPR3-SDK", (String)"HyperLPR3 is uninitialized.");
            return new Plate[0];
        }
        int mWidth = image.getWidth();
        int mHeight = image.getHeight();
        int[] data = new int[image.getWidth() * image.getHeight()];
        image.getPixels(data, 0, mWidth, 0, 0, mWidth, mHeight);
        return this.mCore.plateRecognitionFromImage(data, mHeight, mWidth, rotation, format);
    }

    private static class LazyHolder {
        private static final HyperLPR3 INSTANCE = new HyperLPR3();

        private LazyHolder() {
        }
    }
}

