/*
 * Decompiled with CFR 0.152.
 */
package com.hyperai.hyperlpr3.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SDKUtils {
    public static void copyFilesFromAssets(Context context, String oldPath, String newPath) {
        try {
            String[] fileNames = context.getAssets().list(oldPath);
            if (fileNames.length > 0) {
                File file = new File(newPath);
                if (!file.mkdir()) {
                    Log.d((String)"mkdir", (String)"can't make folder");
                }
                for (String fileName : fileNames) {
                    SDKUtils.copyFilesFromAssets(context, oldPath + "/" + fileName, newPath + "/" + fileName);
                }
            } else {
                int byteCount;
                InputStream is = context.getAssets().open(oldPath);
                FileOutputStream fos = new FileOutputStream(new File(newPath));
                byte[] buffer = new byte[1024];
                while ((byteCount = is.read(buffer)) != -1) {
                    fos.write(buffer, 0, byteCount);
                }
                fos.flush();
                is.close();
                fos.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void mkdirsFeaturesAssets(Context context, String path, String images, String features) {
        try {
            File file = new File(path);
            File imagePath = new File(path + images);
            File featurePath = new File(path + features);
            if (!file.mkdir()) {
                Log.d((String)"mkdir", (String)("can't make folder: " + file));
            }
            if (!imagePath.mkdir()) {
                Log.d((String)"mkdir", (String)("can't make folder: " + imagePath));
            }
            if (!featurePath.mkdir()) {
                Log.d((String)"mkdir", (String)("can't make folder: " + featurePath));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String saveBitmap(String savePath, String name, Bitmap bitmap) throws IOException {
        File f = new File(savePath, name + ".png");
        if (f.exists()) {
            f.delete();
        }
        FileOutputStream out = new FileOutputStream(f);
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out);
        out.flush();
        out.close();
        return f.getAbsolutePath();
    }

    public static boolean cropperBitmap(Bitmap bitmap, int[] rePoints, String sdcardPath, String name) {
        int newWidth = 160;
        int newHeight = 192;
        float scaleWidth = (float)newWidth / (float)bitmap.getWidth();
        float scaleHeight = (float)newHeight / (float)bitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        matrix.setScale(-1.0f, 1.0f);
        int px = Math.max(0, rePoints[0]);
        int py = Math.max(0, rePoints[1]);
        int w = rePoints[2] - px;
        int h = rePoints[3] - py;
        int pw = bitmap.getWidth() - w > 0 ? w - 1 : bitmap.getWidth() - 1;
        int ph = bitmap.getHeight() - h > 0 ? h - 1 : bitmap.getHeight() - 1;
        try {
            Bitmap crop = Bitmap.createBitmap((Bitmap)bitmap, (int)px, (int)py, (int)pw, (int)ph, (Matrix)matrix, (boolean)true);
            SDKUtils.saveBitmap(sdcardPath, name, crop);
        }
        catch (Exception err) {
            Log.d((String)"crop", (String)"ext");
            return false;
        }
        return true;
    }

    public static Bitmap getImageFromAssetsFile(Context context, String fileName) {
        Bitmap image = null;
        AssetManager am = context.getResources().getAssets();
        try {
            InputStream is = am.open(fileName);
            image = BitmapFactory.decodeStream((InputStream)is);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }
}

