/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.column;

import com.raizlabs.android.dbflow.processor.SQLiteHelper;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/raizlabs/android/dbflow/processor/definition/column/DefinitionUtils;", "", "()V", "getCreationStatement", "Lcom/squareup/javapoet/CodeBlock$Builder;", "elementTypeName", "Lcom/squareup/javapoet/TypeName;", "wrapperTypeName", "columnName", "", "getLoadFromCursorMethodString", "dbflow-processor"})
public final class DefinitionUtils {
    public static final DefinitionUtils INSTANCE;

    @NotNull
    public final CodeBlock.Builder getCreationStatement(@Nullable TypeName elementTypeName, @Nullable TypeName wrapperTypeName, @NotNull String columnName) {
        Intrinsics.checkParameterIsNotNull((Object)columnName, (String)"columnName");
        String statement = null;
        TypeName typeName = wrapperTypeName;
        if (typeName == null) {
            typeName = elementTypeName;
        }
        if (SQLiteHelper.Companion.containsType(typeName)) {
            statement = SQLiteHelper.Companion.get(elementTypeName).toString();
        }
        CodeBlock.Builder builder = CodeBlock.builder().add("$L $L", new Object[]{QueryBuilder.quote((String)columnName), statement});
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"CodeBlock.builder().add(\u2026e(columnName), statement)");
        return builder;
    }

    @NotNull
    public final String getLoadFromCursorMethodString(@Nullable TypeName elementTypeName, @Nullable TypeName wrapperTypeName) {
        String method = "";
        TypeName typeName = wrapperTypeName;
        if (typeName == null) {
            typeName = elementTypeName;
        }
        if (SQLiteHelper.Companion.containsMethod(typeName)) {
            method = SQLiteHelper.Companion.getMethod(elementTypeName);
        }
        return method;
    }

    private DefinitionUtils() {
        INSTANCE = this;
    }

    static {
        new DefinitionUtils();
    }
}

