/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.list;

import android.database.Cursor;
import com.raizlabs.android.dbflow.list.IFlowCursorIterator;
import com.raizlabs.android.dbflow.structure.Model;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;

public class FlowCursorIterator<TModel extends Model>
implements ListIterator<TModel> {
    private final IFlowCursorIterator<TModel> cursorList;
    private int reverseIndex;
    private int startingCount;

    public FlowCursorIterator(IFlowCursorIterator<TModel> cursorList) {
        this(cursorList, 0);
    }

    public FlowCursorIterator(IFlowCursorIterator<TModel> cursorList, int startingLocation) {
        this.cursorList = cursorList;
        Cursor cursor = cursorList.cursor();
        if (cursor != null) {
            cursor.moveToPosition(startingLocation - 1);
            this.reverseIndex = this.startingCount = cursor.getCount();
            this.reverseIndex -= startingLocation;
            if (this.reverseIndex < 0) {
                this.reverseIndex = 0;
            }
        }
    }

    @Override
    public void add(TModel object) {
        throw new UnsupportedOperationException("Cursor Iterator: Cannot add a model in the iterator");
    }

    @Override
    public boolean hasNext() {
        this.checkSizes();
        return this.reverseIndex > 0;
    }

    @Override
    public boolean hasPrevious() {
        this.checkSizes();
        return this.reverseIndex < this.cursorList.getCount();
    }

    @Override
    public TModel next() {
        this.checkSizes();
        TModel item = this.cursorList.getItem(this.cursorList.getCount() - this.reverseIndex);
        --this.reverseIndex;
        return item;
    }

    @Override
    public int nextIndex() {
        return this.reverseIndex + 1;
    }

    @Override
    public TModel previous() {
        this.checkSizes();
        TModel item = this.cursorList.getItem(this.cursorList.getCount() - this.reverseIndex);
        ++this.reverseIndex;
        return item;
    }

    @Override
    public int previousIndex() {
        return this.reverseIndex;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cursor Iterator: cannot remove from an active Iterator ");
    }

    @Override
    public void set(TModel object) {
        throw new UnsupportedOperationException("Cursor Iterator: cannot set on an active Iterator ");
    }

    private void checkSizes() {
        if (this.startingCount != this.cursorList.getCount()) {
            throw new ConcurrentModificationException("Cannot change Cursor data during iteration.");
        }
    }
}

