/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.list;

import android.database.Cursor;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.list.FlowCursorIterator;
import com.raizlabs.android.dbflow.list.IFlowCursorIterator;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.queriable.ModelQueriable;
import com.raizlabs.android.dbflow.structure.InstanceAdapter;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.cache.ModelCache;
import com.raizlabs.android.dbflow.structure.cache.ModelLruCache;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FlowCursorList<TModel extends Model>
implements Iterable<TModel>,
Closeable,
IFlowCursorIterator<TModel> {
    public static final int DEFAULT_CACHE_SIZE = 50;
    public static final int MIN_CACHE_SIZE = 20;
    @Nullable
    private Cursor cursor;
    private Class<TModel> table;
    private ModelCache<TModel, ?> modelCache;
    private boolean cacheModels;
    private ModelQueriable<TModel> modelQueriable;
    private int cacheSize;
    private InstanceAdapter<TModel, TModel> modelAdapter;
    private final Set<OnCursorRefreshListener<TModel>> cursorRefreshListenerSet = new HashSet<OnCursorRefreshListener<TModel>>();

    private FlowCursorList(Builder<TModel> builder) {
        this.table = ((Builder)builder).modelClass;
        this.modelQueriable = ((Builder)builder).modelQueriable;
        if (((Builder)builder).modelQueriable == null) {
            this.cursor = ((Builder)builder).cursor;
            if (this.cursor == null) {
                this.modelQueriable = SQLite.select(new IProperty[0]).from(this.table);
                this.cursor = this.modelQueriable.query();
            }
        } else {
            this.cursor = ((Builder)builder).modelQueriable.query();
        }
        this.cacheModels = ((Builder)builder).cacheModels;
        if (this.cacheModels) {
            this.cacheSize = ((Builder)builder).cacheSize;
            this.modelCache = ((Builder)builder).modelCache;
        }
        this.modelAdapter = FlowManager.getInstanceAdapter(((Builder)builder).modelClass);
        this.setCacheModels(this.cacheModels);
    }

    @Deprecated
    public FlowCursorList(ModelQueriable<TModel> modelQueriable) {
        this(true, modelQueriable);
    }

    @Deprecated
    public FlowCursorList(int cacheSize, ModelQueriable<TModel> modelQueriable) {
        this(false, modelQueriable);
        this.setCacheModels(true, cacheSize);
    }

    @Deprecated
    public FlowCursorList(boolean cacheModels, ModelQueriable<TModel> modelQueriable) {
        this.modelQueriable = modelQueriable;
        this.cursor = this.modelQueriable.query();
        this.table = modelQueriable.getTable();
        this.modelAdapter = FlowManager.getInstanceAdapter(this.table);
        this.cacheModels = cacheModels;
        this.setCacheModels(cacheModels);
    }

    @Override
    public Iterator<TModel> iterator() {
        return new FlowCursorIterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnCursorRefreshListener(OnCursorRefreshListener<TModel> onCursorRefreshListener) {
        Set<OnCursorRefreshListener<TModel>> set = this.cursorRefreshListenerSet;
        synchronized (set) {
            this.cursorRefreshListenerSet.add(onCursorRefreshListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnCursorRefreshListener(OnCursorRefreshListener<TModel> onCursorRefreshListener) {
        Set<OnCursorRefreshListener<TModel>> set = this.cursorRefreshListenerSet;
        synchronized (set) {
            this.cursorRefreshListenerSet.remove(onCursorRefreshListener);
        }
    }

    @Deprecated
    public void setCacheModels(boolean cacheModels) {
        if (cacheModels) {
            this.throwIfCursorClosed();
            this.setCacheModels(true, this.cursor == null ? 0 : this.cursor.getCount());
        } else {
            this.setCacheModels(false, this.cursor == null ? 0 : this.cursor.getCount());
        }
    }

    @Deprecated
    public void setCacheModels(boolean cacheModels, int cacheSize) {
        this.cacheModels = cacheModels;
        if (!cacheModels) {
            this.clearCache();
        } else {
            this.throwIfCursorClosed();
            if (cacheSize <= 20) {
                cacheSize = cacheSize == 0 ? 50 : 20;
            }
            this.cacheSize = cacheSize;
            if (this.modelCache == null) {
                this.modelCache = this.getBackingCache();
            }
        }
    }

    @Deprecated
    protected ModelCache<TModel, ?> getBackingCache() {
        return ModelLruCache.newInstance(this.cacheSize);
    }

    public void clearCache() {
        if (this.cacheModels) {
            this.modelCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        this.warnEmptyCursor();
        if (this.cursor != null) {
            this.cursor.close();
        }
        this.cursor = this.modelQueriable.query();
        if (this.cacheModels) {
            this.modelCache.clear();
            this.setCacheModels(true, this.cursor == null ? 0 : this.cursor.getCount());
        }
        Set<OnCursorRefreshListener<TModel>> set = this.cursorRefreshListenerSet;
        synchronized (set) {
            for (OnCursorRefreshListener<TModel> listener : this.cursorRefreshListenerSet) {
                listener.onCursorRefreshed(this);
            }
        }
    }

    public ModelQueriable<TModel> modelQueriable() {
        return this.modelQueriable;
    }

    @Override
    public TModel getItem(long position) {
        this.throwIfCursorClosed();
        this.warnEmptyCursor();
        Object model = null;
        if (this.cacheModels) {
            model = this.modelCache.get(position);
            if (model == null && this.cursor != null && this.cursor.moveToPosition((int)position)) {
                model = this.modelAdapter.getSingleModelLoader().convertToData(this.cursor, null, false);
                this.modelCache.addModel(position, model);
            }
        } else if (this.cursor != null && this.cursor.moveToPosition((int)position)) {
            model = this.modelAdapter.getSingleModelLoader().convertToData(this.cursor, null, false);
        }
        return model;
    }

    public List<TModel> getAll() {
        this.throwIfCursorClosed();
        this.warnEmptyCursor();
        return this.cursor == null ? new ArrayList() : FlowManager.getModelAdapter(this.table).getListModelLoader().convertToData(this.cursor, null);
    }

    public boolean isEmpty() {
        this.throwIfCursorClosed();
        this.warnEmptyCursor();
        return this.getCount() == 0;
    }

    @Override
    public int getCount() {
        this.throwIfCursorClosed();
        this.warnEmptyCursor();
        return this.cursor != null ? this.cursor.getCount() : 0;
    }

    public int cacheSize() {
        return this.cacheSize;
    }

    public ModelCache<TModel, ?> modelCache() {
        return this.modelCache;
    }

    public boolean cachingEnabled() {
        return this.cacheModels;
    }

    @Override
    public void close() {
        this.warnEmptyCursor();
        if (this.cursor != null) {
            this.cursor.close();
        }
        this.cursor = null;
    }

    @Override
    @Nullable
    public Cursor cursor() {
        this.throwIfCursorClosed();
        this.warnEmptyCursor();
        return this.cursor;
    }

    @Deprecated
    @Nullable
    public Cursor getCursor() {
        return this.cursor();
    }

    public Class<TModel> table() {
        return this.table;
    }

    @Deprecated
    public Class<TModel> getTable() {
        return this.table;
    }

    private void throwIfCursorClosed() {
        if (this.cursor != null && this.cursor.isClosed()) {
            throw new IllegalStateException("Cursor has been closed for FlowCursorList");
        }
    }

    private void warnEmptyCursor() {
        if (this.cursor == null) {
            FlowLog.log(FlowLog.Level.W, "Cursor was null for FlowCursorList");
        }
    }

    public Builder<TModel> newBuilder() {
        return new Builder<TModel>(this.table).modelQueriable(this.modelQueriable).cursor(this.cursor).cacheSize(this.cacheSize).cacheModels(this.cacheModels).modelCache(this.modelCache);
    }

    public static class Builder<TModel extends Model> {
        private final Class<TModel> modelClass;
        private Cursor cursor;
        private ModelQueriable<TModel> modelQueriable;
        private boolean cacheModels = true;
        private int cacheSize;
        private ModelCache<TModel, ?> modelCache;

        public Builder(Class<TModel> modelClass) {
            this.modelClass = modelClass;
        }

        public Builder<TModel> cursor(Cursor cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder<TModel> modelQueriable(ModelQueriable<TModel> modelQueriable) {
            this.modelQueriable = modelQueriable;
            return this;
        }

        public Builder<TModel> cacheModels(boolean cacheModels) {
            this.cacheModels = cacheModels;
            return this;
        }

        public Builder<TModel> cacheSize(int cacheSize) {
            this.cacheSize = cacheSize;
            this.cacheModels(true);
            return this;
        }

        public Builder<TModel> modelCache(ModelCache<TModel, ?> modelCache) {
            this.modelCache = modelCache;
            this.cacheModels(true);
            return this;
        }

        public FlowCursorList<TModel> build() {
            return new FlowCursorList(this);
        }
    }

    public static interface OnCursorRefreshListener<TModel extends Model> {
        public void onCursorRefreshed(FlowCursorList<TModel> var1);
    }
}

