/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.runtime;

import android.os.Looper;
import android.os.Process;
import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.database.transaction.ProcessModelTransaction;
import com.raizlabs.android.dbflow.structure.database.transaction.Transaction;
import java.util.ArrayList;
import java.util.Collection;

public class DBBatchSaveQueue
extends Thread {
    private static final int MODEL_SAVE_SIZE = 50;
    private static final int sMODEL_SAVE_CHECK_TIME = 30000;
    private int modelSaveSize = 50;
    private long modelSaveCheckTime = 30000L;
    private final ArrayList<Model> models;
    private boolean isQuitting = false;
    private Transaction.Error errorListener;
    private Transaction.Success successListener;
    private DatabaseDefinition databaseDefinition;
    private final ProcessModelTransaction.ProcessModel modelSaver = new ProcessModelTransaction.ProcessModel(){

        public void processModel(Model model) {
            model.save();
        }
    };
    private final Transaction.Success successCallback = new Transaction.Success(){

        @Override
        public void onSuccess(Transaction transaction) {
            if (DBBatchSaveQueue.this.successListener != null) {
                DBBatchSaveQueue.this.successListener.onSuccess(transaction);
            }
        }
    };
    private final Transaction.Error errorCallback = new Transaction.Error(){

        @Override
        public void onError(Transaction transaction, Throwable error) {
            if (DBBatchSaveQueue.this.errorListener != null) {
                DBBatchSaveQueue.this.errorListener.onError(transaction, error);
            }
        }
    };

    DBBatchSaveQueue(DatabaseDefinition databaseDefinition) {
        super("DBBatchSaveQueue");
        this.databaseDefinition = databaseDefinition;
        this.models = new ArrayList();
    }

    public void setModelSaveSize(int mModelSaveSize) {
        this.modelSaveSize = mModelSaveSize;
    }

    public void setModelSaveCheckTime(long time) {
        this.modelSaveCheckTime = time;
    }

    public void setErrorListener(Transaction.Error errorListener) {
        this.errorListener = errorListener;
    }

    public void setSuccessListener(Transaction.Success successListener) {
        this.successListener = successListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.run();
        Looper.prepare();
        Process.setThreadPriority((int)10);
        do {
            ArrayList<Model> tmpModels;
            ArrayList<Model> arrayList = this.models;
            synchronized (arrayList) {
                tmpModels = new ArrayList<Model>(this.models);
                this.models.clear();
            }
            if (tmpModels.size() > 0) {
                this.databaseDefinition.beginTransactionAsync(new ProcessModelTransaction.Builder<Model>(this.modelSaver).addAll((Collection<Model>)tmpModels).build()).success(this.successCallback).error(this.errorCallback).build().execute();
            }
            try {
                Thread.sleep(this.modelSaveCheckTime);
            }
            catch (InterruptedException e) {
                FlowLog.log(FlowLog.Level.I, "DBRequestQueue Batch interrupted to start saving");
            }
        } while (!this.isQuitting);
    }

    public void purgeQueue() {
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Model inModel) {
        ArrayList<Model> arrayList = this.models;
        synchronized (arrayList) {
            this.models.add(inModel);
            if (this.models.size() > this.modelSaveSize) {
                this.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<Model> list) {
        ArrayList<Model> arrayList = this.models;
        synchronized (arrayList) {
            this.models.addAll(list);
            if (this.models.size() > this.modelSaveSize) {
                this.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Model outModel) {
        ArrayList<Model> arrayList = this.models;
        synchronized (arrayList) {
            this.models.remove(outModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Collection<Model> outCollection) {
        ArrayList<Model> arrayList = this.models;
        synchronized (arrayList) {
            this.models.removeAll(outCollection);
        }
    }

    public void quit() {
        this.isQuitting = true;
    }
}

