/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql;

import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.database.transaction.ITransaction;
import com.raizlabs.android.dbflow.structure.database.transaction.Transaction;

public class BaseAsyncObject<TAsync> {
    private Transaction.Success successCallback;
    private Transaction.Error errorCallback;
    private Transaction currentTransaction;
    private final DatabaseDefinition databaseDefinition;
    private final Transaction.Error error = new Transaction.Error(){

        @Override
        public void onError(Transaction transaction, Throwable error) {
            if (BaseAsyncObject.this.errorCallback != null) {
                BaseAsyncObject.this.errorCallback.onError(transaction, error);
            }
            BaseAsyncObject.this.onError(transaction, error);
            BaseAsyncObject.this.currentTransaction = null;
        }
    };
    private final Transaction.Success success = new Transaction.Success(){

        @Override
        public void onSuccess(Transaction transaction) {
            if (BaseAsyncObject.this.successCallback != null) {
                BaseAsyncObject.this.successCallback.onSuccess(transaction);
            }
            BaseAsyncObject.this.onSuccess(transaction);
            BaseAsyncObject.this.currentTransaction = null;
        }
    };

    public BaseAsyncObject(Class<? extends Model> modelClass) {
        this.databaseDefinition = FlowManager.getDatabaseForTable(modelClass);
    }

    public TAsync error(Transaction.Error errorCallback) {
        this.errorCallback = errorCallback;
        return (TAsync)this;
    }

    public TAsync success(Transaction.Success success) {
        this.successCallback = success;
        return (TAsync)this;
    }

    public void cancel() {
        if (this.currentTransaction != null) {
            this.currentTransaction.cancel();
        }
    }

    protected void executeTransaction(ITransaction transaction) {
        this.cancel();
        this.currentTransaction = this.databaseDefinition.beginTransactionAsync(transaction).error(this.error).success(this.success).build();
        this.currentTransaction.execute();
    }

    protected void onError(Transaction transaction, Throwable error) {
    }

    protected void onSuccess(Transaction transaction) {
    }
}

