/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.builder;

import android.database.DatabaseUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.converter.TypeConverter;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.structure.Model;

public class ValueQueryBuilder
extends QueryBuilder<ValueQueryBuilder> {
    public static String joinArguments(CharSequence delimiter, Object[] tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(ValueQueryBuilder.convertValueToDatabaseString(token));
        }
        return sb.toString();
    }

    public static String joinArguments(CharSequence delimiter, Iterable tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(ValueQueryBuilder.convertValueToDatabaseString(token));
        }
        return sb.toString();
    }

    public static String convertValueToDatabaseString(Object modelValue) {
        String stringVal;
        TypeConverter typeConverter;
        Object value = modelValue;
        if (value != null && (typeConverter = FlowManager.getTypeConverterForClass(value.getClass())) != null) {
            value = typeConverter.getDBValue(value);
        }
        if (value instanceof Number) {
            stringVal = String.valueOf(value);
        } else {
            stringVal = String.valueOf(value);
            if (!stringVal.equals("?")) {
                stringVal = DatabaseUtils.sqlEscapeString((String)stringVal);
            }
        }
        return stringVal;
    }

    public ValueQueryBuilder() {
    }

    public ValueQueryBuilder(String string) {
        super((Object)string);
    }

    public ValueQueryBuilder appendTableName(Class<? extends Model> table) {
        return (ValueQueryBuilder)this.append(FlowManager.getTableName(table));
    }

    public ValueQueryBuilder appendDBValue(Object modelValue) {
        return (ValueQueryBuilder)this.append(ValueQueryBuilder.convertValueToDatabaseString(modelValue));
    }

    public ValueQueryBuilder appendModelList(Iterable<?> modelList) {
        if (modelList != null) {
            this.append(ValueQueryBuilder.joinArguments((CharSequence)",", modelList));
        }
        return this;
    }

    public ValueQueryBuilder appendModelArray(Object[] modelList) {
        if (modelList != null) {
            this.append(ValueQueryBuilder.joinArguments((CharSequence)",", modelList));
        }
        return this;
    }
}

