/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.database.DatabaseUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.converter.TypeConverter;
import com.raizlabs.android.dbflow.data.Blob;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.SqlUtils;
import com.raizlabs.android.dbflow.sql.language.BaseModelQueriable;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;

public abstract class BaseCondition
implements SQLCondition {
    protected String operation = "";
    protected Object value;
    protected NameAlias nameAlias;
    protected String postArg;
    protected String separator;
    protected boolean isValueSet;

    public static String convertValueToString(Object value, boolean appendInnerQueryParenthesis) {
        String stringVal;
        if (value == null) {
            return "NULL";
        }
        TypeConverter typeConverter = FlowManager.getTypeConverterForClass(value.getClass());
        if (typeConverter != null) {
            value = typeConverter.getDBValue(value);
        }
        if (value instanceof Number) {
            stringVal = String.valueOf(value);
        } else if (appendInnerQueryParenthesis && value instanceof BaseModelQueriable) {
            stringVal = String.format("(%1s)", ((BaseModelQueriable)value).getQuery().trim());
        } else if (value instanceof NameAlias) {
            stringVal = ((NameAlias)value).getQuery();
        } else if (value instanceof SQLCondition) {
            QueryBuilder queryBuilder = new QueryBuilder();
            ((SQLCondition)value).appendConditionToQuery(queryBuilder);
            stringVal = queryBuilder.toString();
        } else if (value instanceof Query) {
            stringVal = ((Query)value).getQuery();
        } else if (value instanceof Blob || value instanceof byte[]) {
            byte[] bytes = value instanceof Blob ? ((Blob)value).getBlob() : (byte[])value;
            stringVal = "X" + DatabaseUtils.sqlEscapeString((String)SqlUtils.byteArrayToHexString(bytes));
        } else {
            stringVal = String.valueOf(value);
            if (!stringVal.equals("?")) {
                stringVal = DatabaseUtils.sqlEscapeString((String)stringVal);
            }
        }
        return stringVal;
    }

    public static String joinArguments(CharSequence delimiter, Object[] tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(BaseCondition.convertValueToString(token, false));
        }
        return sb.toString();
    }

    public static String joinArguments(CharSequence delimiter, Iterable tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(BaseCondition.convertValueToString(token, false));
        }
        return sb.toString();
    }

    BaseCondition(NameAlias nameAlias) {
        this.nameAlias = nameAlias;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public String columnName() {
        return this.nameAlias.getQuery();
    }

    @Override
    public SQLCondition separator(String separator) {
        this.separator = separator;
        return this;
    }

    @Override
    public String separator() {
        return this.separator;
    }

    @Override
    public boolean hasSeparator() {
        return this.separator != null && this.separator.length() > 0;
    }

    @Override
    public String operation() {
        return this.operation;
    }

    public String postArgument() {
        return this.postArg;
    }

    NameAlias columnAlias() {
        return this.nameAlias;
    }
}

