/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.BaseCondition;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConditionGroup
extends BaseCondition
implements Query,
Iterable<SQLCondition> {
    private final List<SQLCondition> conditionsList = new ArrayList<SQLCondition>();
    private QueryBuilder query;
    private boolean isChanged;
    private boolean allCommaSeparated;
    private boolean useParenthesis = true;

    public static ConditionGroup clause() {
        return new ConditionGroup();
    }

    public static ConditionGroup clause(SQLCondition condition) {
        return new ConditionGroup().and(condition);
    }

    public static ConditionGroup nonGroupingClause() {
        return new ConditionGroup().setUseParenthesis(false);
    }

    protected ConditionGroup(NameAlias columnName) {
        super(columnName);
        this.separator = "AND";
    }

    protected ConditionGroup() {
        this(null);
    }

    public ConditionGroup setAllCommaSeparated(boolean allCommaSeparated) {
        this.allCommaSeparated = allCommaSeparated;
        this.isChanged = true;
        return this;
    }

    public ConditionGroup setUseParenthesis(boolean useParenthesis) {
        this.useParenthesis = useParenthesis;
        this.isChanged = true;
        return this;
    }

    public ConditionGroup or(SQLCondition sqlCondition) {
        return this.operator("OR", sqlCondition);
    }

    public ConditionGroup and(SQLCondition sqlCondition) {
        return this.operator("AND", sqlCondition);
    }

    public ConditionGroup andAll(SQLCondition ... sqlConditions) {
        for (SQLCondition sqlCondition : sqlConditions) {
            this.and(sqlCondition);
        }
        return this;
    }

    public ConditionGroup andAll(List<SQLCondition> sqlConditions) {
        for (SQLCondition sqlCondition : sqlConditions) {
            this.and(sqlCondition);
        }
        return this;
    }

    public ConditionGroup orAll(SQLCondition ... sqlConditions) {
        for (SQLCondition sqlCondition : sqlConditions) {
            this.or(sqlCondition);
        }
        return this;
    }

    public ConditionGroup orAll(List<SQLCondition> sqlConditions) {
        for (SQLCondition sqlCondition : sqlConditions) {
            this.or(sqlCondition);
        }
        return this;
    }

    private ConditionGroup operator(String operator, SQLCondition sqlCondition) {
        this.setPreviousSeparator(operator);
        this.conditionsList.add(sqlCondition);
        this.isChanged = true;
        return this;
    }

    @Override
    public void appendConditionToQuery(QueryBuilder queryBuilder) {
        int conditionListSize = this.conditionsList.size();
        if (this.useParenthesis && conditionListSize > 0) {
            queryBuilder.append((Object)"(");
        }
        for (int i = 0; i < conditionListSize; ++i) {
            SQLCondition condition = this.conditionsList.get(i);
            condition.appendConditionToQuery(queryBuilder);
            if (!condition.hasSeparator() || i >= conditionListSize - 1) continue;
            queryBuilder.appendSpaceSeparated((Object)condition.separator());
        }
        if (this.useParenthesis && conditionListSize > 0) {
            queryBuilder.append((Object)")");
        }
    }

    private void setPreviousSeparator(String separator) {
        if (this.conditionsList.size() > 0) {
            this.conditionsList.get(this.conditionsList.size() - 1).separator(separator);
        }
    }

    public String getQuery() {
        if (this.isChanged) {
            this.query = new QueryBuilder();
            int count = 0;
            int size = this.conditionsList.size();
            for (int i = 0; i < size; ++i) {
                SQLCondition condition = this.conditionsList.get(i);
                condition.appendConditionToQuery(this.query);
                if (count < size - 1) {
                    if (!this.allCommaSeparated) {
                        this.query.appendSpace().append((Object)(condition.hasSeparator() ? condition.separator() : this.separator));
                    } else {
                        this.query.append((Object)",");
                    }
                    this.query.appendSpace();
                }
                ++count;
            }
        }
        return this.query == null ? "" : this.query.toString();
    }

    public String toString() {
        return this.getQuery();
    }

    public int size() {
        return this.conditionsList.size();
    }

    public List<SQLCondition> getConditions() {
        return this.conditionsList;
    }

    @Override
    public Iterator<SQLCondition> iterator() {
        return this.conditionsList.iterator();
    }
}

