/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.sql.SQLiteType;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.Property;
import java.util.ArrayList;
import java.util.List;

public class Method
extends Property {
    private final List<IProperty> propertyList = new ArrayList<IProperty>();
    private List<String> operationsList = new ArrayList<String>();
    private final IProperty methodProperty;

    public static Method avg(IProperty ... properties) {
        return new Method("AVG", properties);
    }

    public static Method count(IProperty ... properties) {
        return new Method("COUNT", properties);
    }

    public static Method group_concat(IProperty ... properties) {
        return new Method("GROUP_CONCAT", properties);
    }

    public static Method max(IProperty ... properties) {
        return new Method("MAX", properties);
    }

    public static Method min(IProperty ... properties) {
        return new Method("MIN", properties);
    }

    public static Method sum(IProperty ... properties) {
        return new Method("SUM", properties);
    }

    public static Method total(IProperty ... properties) {
        return new Method("TOTAL", properties);
    }

    public static Cast cast(@NonNull IProperty property) {
        return new Cast(property);
    }

    public Method(IProperty ... properties) {
        this((String)null, properties);
    }

    public Method(String methodName, IProperty ... properties) {
        super(null, (String)null);
        this.methodProperty = new Property(null, NameAlias.rawBuilder(methodName).build());
        if (properties.length == 0) {
            this.propertyList.add(Property.ALL_PROPERTY);
        } else {
            for (IProperty property : properties) {
                this.addProperty(property);
            }
        }
    }

    @Override
    public Method plus(IProperty property) {
        return this.append(property, "+");
    }

    @Override
    public Method minus(IProperty property) {
        return this.append(property, "-");
    }

    public Method addProperty(@NonNull IProperty property) {
        if (this.propertyList.size() == 1 && this.propertyList.get(0) == Property.ALL_PROPERTY) {
            this.propertyList.remove(0);
        }
        return this.append(property, ",");
    }

    public Method append(IProperty property, String operation) {
        this.propertyList.add(property);
        this.operationsList.add(operation);
        return this;
    }

    @NonNull
    protected List<IProperty> getPropertyList() {
        return this.propertyList;
    }

    @Override
    public NameAlias getNameAlias() {
        if (this.nameAlias == null) {
            String query = this.methodProperty.getQuery();
            if (query == null) {
                query = "";
            }
            query = query + "(";
            List<IProperty> propertyList = this.getPropertyList();
            for (int i = 0; i < propertyList.size(); ++i) {
                IProperty property = propertyList.get(i);
                if (i > 0) {
                    query = query + " " + this.operationsList.get(i) + " ";
                }
                query = query + property.toString();
            }
            query = query + ")";
            this.nameAlias = NameAlias.rawBuilder(query).build();
        }
        return this.nameAlias;
    }

    public static class Cast {
        private final IProperty property;

        private Cast(@NonNull IProperty property) {
            this.property = property;
        }

        public IProperty as(SQLiteType sqLiteType) {
            Property newProperty = new Property(this.property.getTable(), this.property.getNameAlias().newBuilder().shouldAddIdentifierToAliasName(false).as(sqLiteType.name()).build());
            return new Method("CAST", newProperty);
        }
    }
}

