/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.content.ContentValues;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.SqlUtils;
import com.raizlabs.android.dbflow.sql.language.BaseQueriable;
import com.raizlabs.android.dbflow.sql.language.ConditionGroup;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.Transformable;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.WhereBase;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.queriable.Queriable;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;

public class Set<TModel extends Model>
extends BaseQueriable<TModel>
implements WhereBase<TModel>,
Queriable,
Transformable<TModel> {
    private ConditionGroup conditionGroup;
    private Query update;

    Set(Query update, Class<TModel> table) {
        super(table);
        this.update = update;
        this.conditionGroup = new ConditionGroup();
        this.conditionGroup.setAllCommaSeparated(true);
    }

    public Set<TModel> conditions(SQLCondition ... conditions) {
        this.conditionGroup.andAll(conditions);
        return this;
    }

    public Set<TModel> conditionValues(ContentValues contentValues) {
        SqlUtils.addContentValues(contentValues, this.conditionGroup);
        return this;
    }

    public Where<TModel> where(SQLCondition ... conditions) {
        return new Where(this, conditions);
    }

    @Override
    public Where<TModel> groupBy(NameAlias ... nameAliases) {
        return this.where(new SQLCondition[0]).groupBy(nameAliases);
    }

    @Override
    public Where<TModel> groupBy(IProperty ... properties) {
        return this.where(new SQLCondition[0]).groupBy(properties);
    }

    @Override
    public Where<TModel> orderBy(NameAlias nameAlias, boolean ascending) {
        return this.where(new SQLCondition[0]).orderBy(nameAlias, ascending);
    }

    @Override
    public Where<TModel> orderBy(IProperty property, boolean ascending) {
        return this.where(new SQLCondition[0]).orderBy(property, ascending);
    }

    @Override
    public Where<TModel> orderBy(OrderBy orderBy) {
        return this.where(new SQLCondition[0]).orderBy(orderBy);
    }

    @Override
    public Where<TModel> limit(int count) {
        return this.where(new SQLCondition[0]).limit(count);
    }

    @Override
    public Where<TModel> offset(int offset) {
        return this.where(new SQLCondition[0]).offset(offset);
    }

    @Override
    public Where<TModel> having(SQLCondition ... conditions) {
        return this.where(new SQLCondition[0]).having(conditions);
    }

    @Override
    public long count() {
        return this.where(new SQLCondition[0]).count();
    }

    @Override
    public long count(DatabaseWrapper databaseWrapper) {
        return this.where(new SQLCondition[0]).count(databaseWrapper);
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder((Object)this.update.getQuery()).append((Object)"SET ").append((Object)this.conditionGroup.getQuery()).appendSpace();
        return queryBuilder.getQuery();
    }

    @Override
    public Query getQueryBuilderBase() {
        return this.update;
    }
}

